/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleAddon;

public class ModuleChunkLoader
extends ModuleAddon
implements IActivatorModule {
    private boolean rdyToInit;
    private int[] buttonRect = new int[]{20, 20, 24, 12};
    private EntityDataAccessor<Boolean> LOADING_CHUNK;

    public ModuleChunkLoader(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, "Chunk Loader", 8, 6, 0x404040);
    }

    @Override
    public void update() {
        super.update();
        if (!this.rdyToInit) {
            this.rdyToInit = true;
        }
        if (this.isLoadingChunk() && !this.getCart().hasFuelForModule() && !this.getCart().f_19853_.f_46443_) {
            this.setChunkLoading(false);
        }
    }

    public void setChunkLoading(boolean val) {
        if (!this.isPlaceholder()) {
            this.updateDw(this.LOADING_CHUNK, val);
            if (!this.getCart().f_19853_.f_46443_ && this.rdyToInit) {
                if (val) {
                    this.getCart().initChunkLoading();
                } else {
                    this.getCart().dropChunkLoading();
                }
            }
        }
    }

    private boolean isLoadingChunk() {
        return !this.isPlaceholder() && this.getDw(this.LOADING_CHUNK) != false;
    }

    @Override
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/chunk.png");
        int imageID = this.isLoadingChunk() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(matrixStack, gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(matrixStack, gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        if (!this.isLoadingChunk()) {
            return "Activate chunk loading";
        }
        return "Deactivate chunk loading";
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.setChunkLoading(!this.isLoadingChunk());
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.LOADING_CHUNK = this.createDw(EntityDataSerializers.f_135035_);
        this.registerDw(this.LOADING_CHUNK, false);
    }

    @Override
    public int getConsumption(boolean isMoving) {
        return this.isLoadingChunk() ? 5 : super.getConsumption(isMoving);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128379_(this.generateNBTName("ChunkLoading", id), this.isLoadingChunk());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setChunkLoading(tagCompound.m_128471_(this.generateNBTName("ChunkLoading", id)));
    }

    @Override
    public void doActivate(int id) {
        this.setChunkLoading(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setChunkLoading(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isLoadingChunk();
    }
}

