/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.interfaces.ILeverModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleAddon;

public class ModuleBrake
extends ModuleAddon
implements ILeverModule {
    private int[] startstopRect = new int[]{15, 20, 24, 12};
    private int[] turnbackRect = new int[]{this.startstopRect[0] + this.startstopRect[2] + 5, this.startstopRect[1], this.startstopRect[2], this.startstopRect[3]};
    private EntityDataAccessor<Boolean> FORGE_STOPPING;

    public ModuleBrake(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.ADDONS.CONTROL_LEVER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/lever.png");
        this.drawButton(matrixStack, gui, x, y, this.startstopRect, this.isForceStopping() ? 2 : 1);
        this.drawButton(matrixStack, gui, x, y, this.turnbackRect, 0);
    }

    private void drawButton(PoseStack matrixStack, GuiMinecart gui, int x, int y, int[] coords, int imageID) {
        if (this.inRect(x, y, coords)) {
            this.drawImage(matrixStack, gui, coords, 0, coords[3]);
        } else {
            this.drawImage(matrixStack, gui, coords, 0, 0);
        }
        int srcY = coords[3] * 2 + imageID * (coords[3] - 2);
        this.drawImage(matrixStack, gui, coords[0] + 1, coords[1] + 1, 0, srcY, coords[2] - 2, coords[3] - 2);
    }

    @Override
    public boolean stopEngines() {
        return this.isForceStopping();
    }

    private boolean isForceStopping() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getBrakeActive();
        }
        return this.getDw(this.FORGE_STOPPING);
    }

    private void setForceStopping(boolean val) {
        this.updateDw(this.FORGE_STOPPING, val);
    }

    @Override
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, this.isForceStopping() ? Localization.MODULES.ADDONS.LEVER_START.translate(new String[0]) : Localization.MODULES.ADDONS.LEVER_STOP.translate(new String[0]), x, y, this.startstopRect);
        this.drawStringOnMouseOver(matrixStack, gui, Localization.MODULES.ADDONS.LEVER_TURN.translate(new String[0]), x, y, this.turnbackRect);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            if (this.inRect(x, y, this.startstopRect)) {
                this.sendPacket(0);
            } else if (this.inRect(x, y, this.turnbackRect)) {
                this.sendPacket(1);
            }
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.setForceStopping(!this.isForceStopping());
        } else if (id == 1) {
            this.turnback();
        }
    }

    @Override
    public int numberOfPackets() {
        return 2;
    }

    @Override
    public float getLeverState() {
        if (this.isForceStopping()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.FORGE_STOPPING = this.createDw(EntityDataSerializers.f_135035_);
        this.registerDw(this.FORGE_STOPPING, false);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128379_(this.generateNBTName("ForceStop", id), this.isForceStopping());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setForceStopping(tagCompound.m_128471_(this.generateNBTName("ForceStop", id)));
    }
}

