/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.client.renders.ItemStackRenderer;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ItemCarts
extends MinecartItem {
    public ItemCarts() {
        super(AbstractMinecart.Type.RIDEABLE, new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public String getName() {
        return "Modular Cart";
    }

    public InteractionResult m_6225_(UseOnContext itemUseContext) {
        BlockState blockstate;
        Player player = itemUseContext.m_43723_();
        Level world = itemUseContext.m_43725_();
        ItemStack stack = player.m_21120_(itemUseContext.m_43724_());
        BlockPos pos = itemUseContext.m_8083_();
        if (!world.f_46443_ && (blockstate = world.m_8055_(pos)).m_204336_(BlockTags.f_13034_)) {
            block8: {
                try {
                    CompoundTag info = stack.m_41783_();
                    if (info == null || info.m_128441_("maxTime")) break block8;
                    try {
                        EntityMinecartModular cart = new EntityMinecartModular(world, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f, info, (Component)Component.m_237113_((String)""));
                        world.m_7967_((Entity)cart);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        player.m_5661_((Component)Component.m_237113_((String)("The cart failed to be placed into the world, this is due to an issue with one or more modules. Please post your log on the issue tracker here: " + ChatFormatting.BLUE + " https://github.com/modmuss50/SC2/issues")), false);
                        StevesCarts.LOGGER.error(" --------------- Broken cart info --------------- ");
                        StevesCarts.LOGGER.error((Object)info);
                        ByteArrayTag moduleIDTag = (ByteArrayTag)info.m_128423_("Modules");
                        for (byte id : moduleIDTag.m_128227_()) {
                            try {
                                Class<? extends ModuleBase> moduleClass = StevesCartsAPI.MODULE_REGISTRY.get(id).getModuleClass();
                                StevesCarts.LOGGER.error("--- " + moduleClass.getCanonicalName());
                            }
                            catch (Exception ex) {
                                StevesCarts.LOGGER.error("Failed to load module with ID " + id + "! More info below.");
                                e.printStackTrace();
                            }
                        }
                        StevesCarts.LOGGER.error(" --------------- Broken cart info --------------- ");
                        return InteractionResult.FAIL;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return InteractionResult.FAIL;
                }
            }
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(@NotNull ItemStack item, @Nullable Level p_77624_2_, @NotNull List<Component> list, @NotNull TooltipFlag p_77624_4_) {
        if (item.m_41782_() && item.m_41783_().m_128441_("modules")) {
            list.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + "Installed Modules:")));
            ListTag moduleListTag = (ListTag)item.m_41783_().m_128423_("modules");
            if (moduleListTag != null && !moduleListTag.isEmpty()) {
                for (int i = 0; i < moduleListTag.size(); ++i) {
                    CompoundTag moduleTag = (CompoundTag)moduleListTag.get(i);
                    ResourceLocation resourceLocation = new ResourceLocation(moduleTag.m_128461_(String.valueOf(i)));
                    ModuleData moduleData = StevesCartsAPI.MODULE_REGISTRY.get(resourceLocation);
                    if (moduleData == null) continue;
                    list.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + moduleData.getDisplayName())));
                }
            } else {
                list.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "No modules loaded")));
            }
        }
    }

    @Deprecated(forRemoval=true)
    private String formatTime(int ticks) {
        int seconds = ticks / 20;
        ticks -= seconds * 20;
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        return String.format("%02d:%02d:%02d", hours, minutes -= hours * 60, seconds);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ItemStackRenderer.getInstance();
            }
        });
    }
}

