/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.containers.slots.ISpecialItemTransferValidator;
import vswe.stevescarts.containers.slots.ISpecialSlotValidator;

public class TransferHandler {
    public static boolean isSlotOfType(Slot slot, Class slotType) {
        if (slot instanceof ISpecialSlotValidator) {
            ISpecialSlotValidator specSlot = (ISpecialSlotValidator)slot;
            return specSlot.isSlotValid();
        }
        return slotType.isInstance(slot);
    }

    public static boolean isItemValidForTransfer(Slot slot, @Nonnull ItemStack item, TRANSFER_TYPE type) {
        if (slot instanceof ISpecialItemTransferValidator) {
            ISpecialItemTransferValidator specSlot = (ISpecialItemTransferValidator)slot;
            return specSlot.isItemValidForTransfer(item, type);
        }
        return slot.m_5857_(item);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, AbstractContainerMenu cont, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, cont, Slot.class, null, maxItems);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, AbstractContainerMenu cont, Class validSlot, int maxItems, TRANSFER_TYPE type) {
        TransferHandler.TransferItem(iStack, inv, 0, inv.m_6643_() - 1, cont, validSlot, null, maxItems, type, false);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, AbstractContainerMenu cont, Class validSlot, Class invalidSlot, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, 0, inv.m_6643_() - 1, cont, validSlot, invalidSlot, maxItems);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, int start, int end, AbstractContainerMenu cont, Class validSlot, Class invalidSlot, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, start, end, cont, validSlot, invalidSlot, maxItems, TRANSFER_TYPE.OTHER, false);
    }

    public static void TransferItem(@Nonnull ItemStack iStack, Container inv, int start, int end, AbstractContainerMenu cont, Class validSlot, Class invalidSlot, int maxItems, TRANSFER_TYPE type, boolean fake) {
        int pos;
        start = Math.max(0, start);
        end = Math.min(inv.m_6643_() - 1, end);
        int startEmpty = start;
        int startOccupied = start;
        do {
            int i;
            pos = -1;
            for (i = startEmpty; i <= end; ++i) {
                if (!TransferHandler.isSlotOfType(cont.m_38853_(i), validSlot) || invalidSlot != null && TransferHandler.isSlotOfType(cont.m_38853_(i), invalidSlot) || inv.m_8020_(i).m_41619_() || inv.m_8020_(i).m_41720_() != iStack.m_41720_() || !inv.m_8020_(i).m_41753_() || inv.m_8020_(i).m_41613_() >= inv.m_8020_(i).m_41741_() || inv.m_8020_(i).m_41613_() >= cont.m_38853_(i).m_6641_() || inv.m_8020_(i).m_41613_() <= 0 || iStack.m_41613_() <= 0 || inv.m_8020_(i).m_41783_() != null && !inv.m_8020_(i).m_41783_().equals((Object)iStack.m_41783_())) continue;
                pos = i;
                startEmpty = pos + 1;
                break;
            }
            if (pos == -1) {
                for (i = startOccupied; i <= end; ++i) {
                    Slot slot;
                    if (!TransferHandler.isSlotOfType(cont.m_38853_(i), validSlot) || invalidSlot != null && TransferHandler.isSlotOfType(cont.m_38853_(i), invalidSlot) || !TransferHandler.isItemValidForTransfer(slot = cont.m_38853_(i), iStack, type) || !inv.m_8020_(i).m_41619_()) continue;
                    pos = i;
                    startOccupied = pos + 1;
                    break;
                }
            }
            if (pos == -1) continue;
            ItemStack existingItem = null;
            if (inv.m_8020_(pos).m_41619_()) {
                ItemStack clone = iStack.m_41777_();
                clone.m_41764_(0);
                if (!fake) {
                    inv.m_6836_(pos, clone);
                }
                existingItem = clone;
            } else {
                existingItem = inv.m_8020_(pos);
            }
            int stackSize = iStack.m_41613_();
            if (stackSize > existingItem.m_41741_() - existingItem.m_41613_()) {
                stackSize = existingItem.m_41741_() - existingItem.m_41613_();
            }
            if (stackSize > cont.m_38853_(pos).m_6641_() - existingItem.m_41613_()) {
                stackSize = cont.m_38853_(pos).m_6641_() - existingItem.m_41613_();
            }
            boolean killMe = false;
            if (maxItems != -1) {
                if (stackSize > maxItems) {
                    stackSize = maxItems;
                    killMe = true;
                }
                maxItems -= stackSize;
            }
            if (stackSize <= 0) {
                pos = -1;
                continue;
            }
            iStack.m_41774_(stackSize);
            if (!fake) {
                ItemStack stackInSlot = inv.m_8020_(pos);
                stackInSlot.m_41769_(stackSize);
            }
            if (iStack.m_41613_() != 0 && !killMe && maxItems != 0) continue;
            pos = -1;
        } while (pos != -1);
        if (!fake) {
            inv.m_6596_();
        }
    }

    public static enum TRANSFER_TYPE {
        SHIFT,
        MANAGER,
        OTHER;

    }
}

