/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.text.NumberFormat;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.ITankHolder;

public class SCTank
extends FluidTank {
    private final ITankHolder owner;
    private final int tankid;
    private boolean isLocked;

    public SCTank(ITankHolder owner, int tankSize, int tankid) {
        super(tankSize);
        this.owner = owner;
        this.tankid = tankid;
    }

    public SCTank copy() {
        SCTank tank = new SCTank(this.owner, this.capacity, this.tankid);
        if (!this.getFluid().isEmpty()) {
            tank.setFluid(this.getFluid().copy());
        }
        return tank;
    }

    public void containerTransfer() {
        ItemStack itemStack = this.owner.getInputContainer(this.tankid);
        if (itemStack.m_41619_()) {
            return;
        }
        FluidUtil.getFluidHandler((ItemStack)itemStack).ifPresent(itemHandler -> {
            FluidStack fluidStack = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (!fluidStack.isEmpty()) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)false);
                if (result.isSuccess()) {
                    IFluidHandlerItem handler;
                    ItemStack container = result.getResult();
                    LazyOptional opt = FluidUtil.getFluidHandler((ItemStack)container);
                    if (opt.isPresent() && !(fluidStack = (handler = (IFluidHandlerItem)opt.orElseThrow(RuntimeException::new)).drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && fluidStack.getAmount() == 1000) {
                        FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        this.owner.setInputContainer(this.tankid, container);
                        return;
                    }
                    if (!container.m_41619_()) {
                        this.owner.addToOutputContainer(this.tankid, container);
                    }
                    if (container.m_41613_() == 0) {
                        FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            this.owner.setInputContainer(this.tankid, ItemStack.f_41583_);
                        }
                    }
                }
            } else {
                ItemStack container;
                FluidActionResult result = SCTank.tryFillContainer(itemStack, (IFluidHandler)this, Integer.MAX_VALUE, null, false);
                if (result.isSuccess() && !(container = result.getResult()).m_41619_()) {
                    this.owner.addToOutputContainer(this.tankid, container);
                    if (container.m_41613_() == 0) {
                        FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            this.owner.setInputContainer(this.tankid, ItemStack.f_41583_);
                        }
                    }
                }
            }
        });
    }

    @Deprecated
    public static FluidActionResult tryFillContainer(@NotNull ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable Player player, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)false);
            if (!simulatedTransfer.isEmpty()) {
                if (doFill) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)true);
                    if (player != null) {
                        SoundEvent soundevent = simulatedTransfer.getFluid().getFluidType().getSound(simulatedTransfer, SoundActions.BUCKET_FILL);
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    containerFluidHandler.fill(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty() || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.fluid.shrink(drained);
            if (this.fluid.getAmount() <= 0 && !this.isLocked) {
                this.fluid = FluidStack.EMPTY;
            }
            this.onContentsChanged();
        }
        return stack;
    }

    public void setLocked(boolean val) {
        this.isLocked = val;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public String getMouseOver() {
        String name = Localization.MODULES.TANKS.EMPTY.translate(new String[0]);
        int amount = 0;
        if (!this.fluid.isEmpty()) {
            name = this.fluid.getDisplayName().getString();
            amount = this.fluid.getAmount();
        }
        NumberFormat format = NumberFormat.getInstance();
        return name + ": " + format.format(amount) + " / " + format.format(this.capacity);
    }

    protected void onContentsChanged() {
        this.owner.onFluidUpdated(this.tankid);
    }

    public static void applyColour(FluidStack fluidStack) {
        int fluidColor = FluidStackHooks.getColor((Fluid)fluidStack.getFluid());
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        float alpha = (float)(fluidColor >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFluid(PoseStack matrixStack, AbstractContainerScreen<?> gui, int startX, int startY) {
        if (this.fluid.isEmpty()) {
            return;
        }
        int fluidLevel = (int)(48.0f * ((float)this.fluid.getAmount() / (float)this.capacity));
        TextureAtlasSprite icon = FluidStackHooks.getStillTexture((Fluid)this.fluid.getFluid());
        if (icon == null) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        SCTank.applyColour(this.fluid);
        for (int y = 0; y < 3; ++y) {
            int pixels = fluidLevel - (2 - y) * 16;
            if (pixels <= 0) continue;
            if (pixels > 16) {
                pixels = 16;
            }
            for (int x = 0; x < 2; ++x) {
                this.owner.drawImage(this.tankid, gui, icon, startX + 2 + 16 * x, startY + 1 + 16 * y + (16 - pixels), 16, pixels);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

