/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.helpers.EnchantmentData;

public class ModularEnchantments {
    private static final Map<Enchantment, EnchantmentType> ENCHANTMENT_TYPES = new HashMap<Enchantment, EnchantmentType>();
    private static final Map<Enchantment, Integer> ENCHANTMENT_BASE_VALUES = new HashMap<Enchantment, Integer>();

    public static void addValidEnchantment(Enchantment enchantment, EnchantmentType type, int baseValue) {
        ENCHANTMENT_TYPES.put(enchantment, type);
        ENCHANTMENT_BASE_VALUES.put(enchantment, baseValue);
    }

    public static int getValue(Enchantment enchant, int level) {
        return (int)Math.pow(2.0, level - 1) * ENCHANTMENT_BASE_VALUES.getOrDefault(enchant, 0);
    }

    public static int getMaxValue(Enchantment enchant) {
        int max = 0;
        for (int i = 0; i < enchant.m_6586_(); ++i) {
            max += ModularEnchantments.getValue(enchant, i + 1);
        }
        return max;
    }

    public static boolean isValidBook(ItemStack stack, List<EnchantmentType> validTypes) {
        if (stack.m_41619_() || !stack.m_150930_(Items.f_42690_)) {
            return false;
        }
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Enchantment enchantment : enchants.keySet()) {
            if (!ENCHANTMENT_TYPES.containsKey(enchantment)) continue;
            for (EnchantmentType validType : validTypes) {
                if (ENCHANTMENT_TYPES.get(enchantment) != validType) continue;
                return true;
            }
        }
        return false;
    }

    public static EnchantmentData addBook(List<EnchantmentType> enabledTypes, EnchantmentData data, @NotNull ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() != Items.f_42690_) {
            return data;
        }
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        int addLevel = -1;
        if (data.getEnchant() == null) {
            for (Enchantment enchantment : enchants.keySet()) {
                if (!ENCHANTMENT_TYPES.containsKey(enchantment) || !enabledTypes.contains((Object)ENCHANTMENT_TYPES.get(enchantment))) continue;
                data.setEnchantment(enchantment);
                data.setValue(0);
                addLevel = (Integer)enchants.get(enchantment);
                break;
            }
        } else if (enchants.containsKey(data.getEnchant())) {
            addLevel = (Integer)enchants.get(data.getEnchant());
        }
        if (addLevel == -1) {
            return data;
        }
        int newValue = ModularEnchantments.getValue(data.getEnchant(), addLevel) + data.getValue();
        if (newValue <= ModularEnchantments.getMaxValue(data.getEnchant())) {
            data.setValue(newValue);
            stack.m_41774_(1);
        }
        return data;
    }

    public static EnchantmentType getType(Enchantment enchant) {
        return ENCHANTMENT_TYPES.get(enchant);
    }

    static {
        ModularEnchantments.addValidEnchantment(Enchantments.f_44987_, EnchantmentType.TOOL, 50000);
        ModularEnchantments.addValidEnchantment(Enchantments.f_44984_, EnchantmentType.TOOL, 50000);
        ModularEnchantments.addValidEnchantment(Enchantments.f_44986_, EnchantmentType.TOOL, 64000);
        ModularEnchantments.addValidEnchantment(Enchantments.f_44988_, EnchantmentType.SHOOTER, 750);
        ModularEnchantments.addValidEnchantment(Enchantments.f_44989_, EnchantmentType.SHOOTER, 1000);
        ModularEnchantments.addValidEnchantment(Enchantments.f_44990_, EnchantmentType.SHOOTER, 1000);
        ModularEnchantments.addValidEnchantment(Enchantments.f_44952_, EnchantmentType.SHOOTER, 500);
    }

    public static enum EnchantmentType {
        TOOL,
        SHOOTER;

    }
}

