/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.GuiAllocationHelper;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModEntities;
import vswe.stevescarts.modules.addons.ModuleCreativeSupplies;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.modules.workers.CompWorkModule;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class EntityMinecartModular
extends AbstractMinecart
implements Container,
IEntityAdditionalSpawnData,
IFluidHandler,
MenuProvider {
    public BlockPos disabledPos;
    protected boolean wasDisabled;
    public double pushX;
    public double pushZ;
    public double temppushX;
    public double temppushZ;
    protected boolean engineFlag = false;
    private int motorRotation;
    public boolean cornerFlip;
    private List<ResourceLocation> moduleLoadingData;
    private RailShape fixedRailDirection = null;
    private BlockPos fixedRailPos;
    private int wrongRender;
    private boolean oldRender;
    private float lastRenderYaw;
    private double lastMotionX;
    private double lastMotionZ;
    private int workingTime;
    private ModuleWorker workingComponent;
    public TileEntityCartAssembler placeholderAsssembler;
    public boolean isPlaceholder;
    public int keepAlive;
    public static final int MODULAR_SPACE_WIDTH = 443;
    public static final int MODULAR_SPACE_HEIGHT = 168;
    public int modularSpaceHeight;
    public boolean canScrollModules;
    private ArrayList<ModuleCountPair> moduleCounts;
    public static final int[][][] railDirectionCoordinates;
    private ArrayList<ModuleBase> modules;
    private ArrayList<ModuleWorker> workModules;
    private ArrayList<ModuleEngine> engineModules;
    private ArrayList<ModuleTank> tankModules;
    private ModuleCreativeSupplies creativeSupplies;
    public RandomSource f_19796_;
    protected Component name;
    private int scrollY;
    @Deprecated(forRemoval=true)
    private int keepSilent;
    private static final EntityDataAccessor<Boolean> IS_BURNING;
    private static final EntityDataAccessor<Boolean> IS_DISANABLED;
    int base = 0;
    protected final SimpleContainerData dataAccess = new SimpleContainerData(0){

        public int m_6413_(int id) {
            throw new IllegalArgumentException("Invalid index: " + id);
        }

        public void m_8050_(int p_221477_1_, int p_221477_2_) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 0;
        }
    };
    AbstractContainerMenu container = null;

    public ArrayList<ModuleBase> getModules() {
        return this.modules;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean hasModule(Class<? extends ModuleBase> module) {
        for (ModuleBase moduleBase : this.getModules()) {
            if (!moduleBase.getClass().equals(module)) continue;
            return true;
        }
        return false;
    }

    public boolean hasModule(ModuleData moduleData) {
        if (moduleData == null) {
            return false;
        }
        for (ModuleBase module : this.getModules()) {
            if (module.getModuleId() != moduleData.getID()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ModuleWorker> getWorkers() {
        return this.workModules;
    }

    public ArrayList<ModuleEngine> getEngines() {
        return this.engineModules;
    }

    public ArrayList<ModuleTank> getModuleTanks() {
        return this.tankModules;
    }

    public ArrayList<ModuleCountPair> getModuleCounts() {
        return this.moduleCounts;
    }

    public EntityMinecartModular(Level world, double x, double y, double z, CompoundTag info, Component name) {
        super((EntityType)ModEntities.MODULAR_CART.get(), world, x, y, z);
        this.f_19796_ = world.f_46441_;
        this.loadModules(info);
    }

    public EntityMinecartModular(Level world) {
        super((EntityType)ModEntities.MODULAR_CART.get(), world);
        this.f_19796_ = world.f_46441_;
    }

    public EntityMinecartModular(EntityType<EntityMinecartModular> entityType, Level world) {
        super(entityType, world);
        this.f_19796_ = RandomSource.m_216327_();
    }

    public EntityMinecartModular(Level world, TileEntityCartAssembler assembler, ArrayList<ResourceLocation> data) {
        this(world);
        this.setPlaceholder(assembler);
        this.loadPlaceHolderModules(data);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BURNING, (Object)false);
        this.f_19804_.m_135372_(IS_DISANABLED, (Object)false);
    }

    private void loadPlaceHolderModules(List<ResourceLocation> data) {
        if (this.modules == null) {
            this.modules = new ArrayList();
            for (ResourceLocation moduleResourceLocation : data) {
                ModuleData moduleData = StevesCartsAPI.MODULE_REGISTRY.get(moduleResourceLocation);
                this.doLoadModules(moduleData, null);
            }
        } else {
            this.modules.clear();
            for (ResourceLocation moduleResourceLocation : data) {
                ModuleData moduleData = StevesCartsAPI.MODULE_REGISTRY.get(moduleResourceLocation);
                this.doLoadModules(moduleData, null);
            }
        }
        this.initModules();
        this.moduleLoadingData = data;
    }

    private void doLoadModules(ModuleData moduleData, @org.jetbrains.annotations.Nullable CompoundTag data) {
        if (moduleData == null) {
            return;
        }
        try {
            Class<? extends ModuleBase> moduleClass = moduleData.getModuleClass();
            Constructor<? extends ModuleBase> moduleConstructor = moduleClass.getConstructor(EntityMinecartModular.class);
            ModuleBase module = moduleConstructor.newInstance(new Object[]{this});
            module.setModuleId(moduleData.getID());
            this.modules.add(module);
            if (data != null && data.m_128441_("data")) {
                module.readExtraData(data.m_128469_("data"));
            }
        }
        catch (Exception e) {
            StevesCarts.LOGGER.error("Failed to load module with ID " + moduleData.getID() + "! More info below.");
            e.printStackTrace();
        }
    }

    private void loadModules(CompoundTag info) {
        ArrayList<CompoundTag> modules = new ArrayList<CompoundTag>();
        if (info == null) {
            return;
        }
        ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>();
        ListTag listTag = (ListTag)info.m_128423_("modules");
        for (int i = 0; i < listTag.size(); ++i) {
            Tag tag = listTag.get(i);
            modules.add((CompoundTag)tag);
            names.add(new ResourceLocation(((CompoundTag)tag).m_128461_(String.valueOf(i))));
        }
        if (!names.isEmpty()) {
            this.moduleLoadingData = names;
        }
        this.loadModules(modules);
    }

    public void updateSimulationModules(List<ResourceLocation> data) {
        if (!this.isPlaceholder) {
            StevesCarts.LOGGER.error("You're stupid! This is not a placeholder cart.");
        } else {
            this.loadPlaceHolderModules(data);
        }
    }

    protected void loadModules(List<CompoundTag> data) {
        this.modules = new ArrayList();
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                CompoundTag tag = data.get(i);
                ResourceLocation name = new ResourceLocation(tag.m_128461_(String.valueOf(i)));
                this.doLoadModules(StevesCartsAPI.MODULE_REGISTRY.get(name), tag);
            }
        }
        this.initModules();
    }

    protected void loadModulesFromNames(List<ResourceLocation> data) {
        this.modules = new ArrayList();
        if (data != null) {
            for (ResourceLocation name : data) {
                this.doLoadModules(StevesCartsAPI.MODULE_REGISTRY.get(name), null);
            }
        }
        this.initModules();
    }

    private void initModules() {
        this.moduleCounts = new ArrayList();
        for (ModuleBase module : this.modules) {
            ModuleData data = StevesCartsAPI.MODULE_REGISTRY.get(module.getModuleId());
            boolean found = false;
            for (ModuleCountPair moduleCountPair : this.moduleCounts) {
                if (!moduleCountPair.isContainingData(data)) continue;
                moduleCountPair.increase();
                found = true;
                break;
            }
            if (found) continue;
            this.moduleCounts.add(new ModuleCountPair(data));
        }
        for (ModuleBase module : this.modules) {
            module.preInit();
        }
        this.workModules = new ArrayList();
        this.engineModules = new ArrayList();
        this.tankModules = new ArrayList();
        boolean x = false;
        boolean y = false;
        boolean maxH = false;
        int guidata = 0;
        int packets = 0;
        if (this.f_19853_.f_46443_) {
            this.generateModels();
        }
        for (ModuleBase module2 : this.modules) {
            if (module2 instanceof ModuleWorker) {
                this.workModules.add((ModuleWorker)module2);
                continue;
            }
            if (module2 instanceof ModuleEngine) {
                this.engineModules.add((ModuleEngine)module2);
                continue;
            }
            if (module2 instanceof ModuleTank) {
                this.tankModules.add((ModuleTank)module2);
                continue;
            }
            if (!(module2 instanceof ModuleCreativeSupplies)) continue;
            this.creativeSupplies = (ModuleCreativeSupplies)module2;
        }
        CompWorkModule compWorkModule = new CompWorkModule();
        this.workModules.sort(compWorkModule);
        if (!this.isPlaceholder) {
            ArrayList<GuiAllocationHelper> lines = new ArrayList<GuiAllocationHelper>();
            int slots = 0;
            for (ModuleBase module3 : this.modules) {
                if (module3.hasGui()) {
                    boolean foundLine = false;
                    for (GuiAllocationHelper line : lines) {
                        if (line.width + module3.guiWidth() > 443) continue;
                        module3.setX(line.width);
                        line.width += module3.guiWidth();
                        line.maxHeight = Math.max(line.maxHeight, module3.guiHeight());
                        line.modules.add(module3);
                        foundLine = true;
                        break;
                    }
                    if (!foundLine) {
                        GuiAllocationHelper line2 = new GuiAllocationHelper();
                        module3.setX(0);
                        line2.width = module3.guiWidth();
                        line2.maxHeight = module3.guiHeight();
                        line2.modules.add(module3);
                        lines.add(line2);
                    }
                    module3.setGuiDataStart(guidata);
                    guidata += module3.numberOfGuiData();
                    if (module3.hasSlots()) {
                        slots = module3.generateSlots(slots);
                    }
                }
                if (module3.numberOfDataWatchers() > 0) {
                    module3.initDw();
                }
                module3.setPacketStart(packets);
                packets += module3.totalNumberOfPackets();
            }
            int currentY = 0;
            for (GuiAllocationHelper line3 : lines) {
                for (ModuleBase module4 : line3.modules) {
                    module4.setY(currentY);
                }
                currentY += line3.maxHeight;
            }
            if (currentY > 168) {
                this.canScrollModules = true;
            }
            this.modularSpaceHeight = currentY;
        }
        for (ModuleBase module5 : this.modules) {
            module5.init();
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason removalReason) {
        if (this.f_19853_.f_46443_) {
            for (int var1 = 0; var1 < this.m_6643_(); ++var1) {
                this.m_6836_(var1, ItemStack.f_41583_);
            }
        }
        super.m_142687_(removalReason);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onDeath();
            }
        }
        this.dropChunkLoading();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(PoseStack matrixStack, Minecraft minecraft) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.renderOverlay(matrixStack, minecraft);
            }
        }
    }

    public void updateFuel() {
        ModuleEngine engine;
        int consumption = this.getConsumption();
        if (consumption > 0 && (engine = this.getCurrentEngine()) != null) {
            engine.consumeFuel(consumption);
            if (!this.isPlaceholder && this.f_19853_.f_46443_ && this.hasFuel() && !this.isDisabled()) {
                engine.smoke();
            }
        }
        if (this.hasFuel()) {
            if (!this.engineFlag) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
        } else if (this.engineFlag) {
            this.temppushX = this.pushX;
            this.temppushZ = this.pushZ;
            double n = 0.0;
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        this.setEngineBurning(this.hasFuel() && !this.isDisabled());
    }

    public boolean isEngineBurning() {
        return (Boolean)this.f_19804_.m_135370_(IS_BURNING);
    }

    public void setEngineBurning(boolean on) {
        this.f_19804_.m_135381_(IS_BURNING, (Object)on);
    }

    private ModuleEngine getCurrentEngine() {
        if (this.modules == null) {
            return null;
        }
        for (ModuleBase module : this.modules) {
            if (!module.stopEngines()) continue;
            return null;
        }
        int consumption = this.getConsumption(true);
        ArrayList<ModuleEngine> priority = new ArrayList<ModuleEngine>();
        int mostImportant = -1;
        for (ModuleEngine engine : this.engineModules) {
            if (!engine.hasFuel(consumption) || mostImportant != -1 && mostImportant < engine.getPriority()) continue;
            if (engine.getPriority() < mostImportant) {
                priority.clear();
            }
            mostImportant = engine.getPriority();
            priority.add(engine);
        }
        if (priority.size() > 0) {
            if (this.motorRotation >= priority.size()) {
                this.motorRotation = 0;
            }
            this.motorRotation = (this.motorRotation + 1) % priority.size();
            return (ModuleEngine)priority.get(this.motorRotation);
        }
        return null;
    }

    public int getConsumption() {
        return this.getConsumption(!this.isDisabled() && this.isEngineBurning());
    }

    public int getConsumption(boolean isMoving) {
        int consumption;
        int n = consumption = isMoving ? 1 : 0;
        if (this.modules != null && !this.isPlaceholder) {
            for (ModuleBase module : this.modules) {
                consumption += module.getConsumption(isMoving);
            }
        }
        return consumption;
    }

    @NotNull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.FURNACE;
    }

    @NotNull
    public HitResult m_19907_(double p_19908_, float p_19909_, boolean p_19910_) {
        return super.m_19907_(p_19908_, p_19909_, p_19910_);
    }

    protected float m_6380_(@NotNull Pose pose, @NotNull EntityDimensions entityDimensions) {
        return 0.9f;
    }

    public double m_6049_() {
        if (this.modules != null && !this.m_20197_().isEmpty()) {
            for (ModuleBase module : this.modules) {
                float offset = module.mountedOffset((Entity)this.m_20197_().get(0));
                if (offset == 0.0f) continue;
                return offset;
            }
        }
        return super.m_6049_();
    }

    @NotNull
    public Item m_213728_() {
        return Items.f_41852_;
    }

    @Nonnull
    public ItemStack getCartItem() {
        if (this.modules != null) {
            ItemStack cart = ModuleData.createModularCart(this);
            return cart;
        }
        return ItemStack.f_41583_;
    }

    public void m_7617_(@NotNull DamageSource damageSource) {
        this.m_6074_();
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_) && this.dropOnDeath()) {
            ItemStack itemstack = this.getCartItem();
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
            }
            for (int i = 0; i < this.m_6643_(); ++i) {
                ItemStack stack = this.m_8020_(i);
                if (stack.m_41619_()) continue;
                this.m_19983_(stack);
            }
            this.m_19983_(itemstack);
        }
    }

    public boolean dropOnDeath() {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (module.dropOnDeath()) continue;
                return false;
            }
        }
        return true;
    }

    public float getMaxCartSpeedOnRail() {
        float maxSpeed = super.getMaxCartSpeedOnRail();
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                float tempMax = module.getMaxSpeed();
                if (!(tempMax < maxSpeed)) continue;
                maxSpeed = tempMax;
            }
        }
        return maxSpeed;
    }

    public boolean isPoweredCart() {
        return this.engineModules.size() > 0;
    }

    public int getDefaultDisplayTileData() {
        return -1;
    }

    public float[] getColor() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                float[] color = module.getColor();
                if (color[0] == 1.0f && color[1] == 1.0f && color[2] == 1.0f) continue;
                return color;
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public int getYTarget() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                int yTarget = module.getYTarget();
                if (yTarget == -1) continue;
                return yTarget;
            }
        }
        return this.y();
    }

    public ModuleBase getInterfaceThief() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (!module.doStealInterface()) continue;
                return module;
            }
        }
        return null;
    }

    public boolean m_6469_(@NotNull DamageSource dmg, float par2) {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (module.receiveDamage(dmg, par2)) continue;
                return false;
            }
        }
        return super.m_6469_(dmg, par2);
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_6025_(int x, int y, int z, boolean active) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.activatedByRail(x, y, z, active);
            }
        }
    }

    public void moveMinecartOnRail(@NotNull BlockPos pos) {
        boolean forceUnDisable;
        BlockState blockState;
        RailShape railDirection;
        super.moveMinecartOnRail(pos);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.moveMinecartOnRail(pos);
            }
        }
        boolean bl = this.cornerFlip = ((railDirection = ((BaseRailBlock)(blockState = this.f_19853_.m_8055_(pos)).m_60734_()).getRailDirection(blockState, (BlockGetter)this.f_19853_, pos, (AbstractMinecart)this)) == RailShape.SOUTH_EAST || railDirection == RailShape.SOUTH_WEST) && this.m_20184_().f_82479_ < 0.0 || (railDirection == RailShape.NORTH_EAST || railDirection == RailShape.NORTH_WEST) && this.m_20184_().f_82479_ > 0.0;
        if (blockState.m_60734_() != ModBlocks.ADVANCED_DETECTOR.get() && this.isDisabled()) {
            this.releaseCart();
        }
        boolean canBeDisabled = blockState.m_60734_() == ModBlocks.ADVANCED_DETECTOR.get();
        boolean bl2 = forceUnDisable = this.wasDisabled && this.disabledPos != null && this.disabledPos.equals((Object)pos);
        if (!forceUnDisable && this.wasDisabled) {
            this.wasDisabled = false;
        }
        boolean bl3 = canBeDisabled = !forceUnDisable && canBeDisabled;
        if (canBeDisabled && !this.isDisabled()) {
            this.setIsDisabled(true);
            if (this.pushX != 0.0 || this.pushZ != 0.0) {
                this.temppushX = this.pushX;
                this.temppushZ = this.pushZ;
                double n = 0.0;
                this.pushZ = 0.0;
                this.pushX = 0.0;
            }
            this.disabledPos = new BlockPos((Vec3i)pos);
        }
        if (this.fixedRailPos != null && !this.fixedRailPos.equals((Object)pos)) {
            this.fixedRailDirection = null;
            this.fixedRailPos = new BlockPos(this.fixedRailPos.m_123341_(), -1, this.fixedRailPos.m_123343_());
        }
    }

    public boolean isCorner(BlockPos blockPos) {
        if (this.f_19853_.m_8055_(blockPos).m_60734_() == Blocks.f_50156_) {
            RailShape value = (RailShape)this.f_19853_.m_8055_(blockPos).m_61143_((Property)RailBlock.f_55392_);
            if (value == RailShape.NORTH_EAST) {
                return true;
            }
            if (value == RailShape.NORTH_WEST) {
                return true;
            }
            if (value == RailShape.SOUTH_WEST) {
                return true;
            }
            if (value == RailShape.SOUTH_EAST) {
                return true;
            }
        }
        return false;
    }

    public RailShape getRailDirection(BlockPos pos) {
        ModuleBase module;
        ModuleBase.RAILDIRECTION dir = ModuleBase.RAILDIRECTION.DEFAULT;
        Iterator<ModuleBase> iterator = this.getModules().iterator();
        while (iterator.hasNext() && (dir = (module = iterator.next()).getSpecialRailDirection(pos)) == ModuleBase.RAILDIRECTION.DEFAULT) {
        }
        if (dir == ModuleBase.RAILDIRECTION.DEFAULT) {
            return null;
        }
        int Yaw = (int)(this.m_146908_() % 180.0f);
        if (Yaw < 0) {
            Yaw += 180;
        }
        boolean flag = Yaw >= 45 && Yaw <= 135;
        Vec3 motion = this.m_20184_();
        if (this.fixedRailDirection == null) {
            switch (dir) {
                case FORWARD: {
                    if (flag) {
                        this.fixedRailDirection = RailShape.NORTH_SOUTH;
                        break;
                    }
                    this.fixedRailDirection = RailShape.EAST_WEST;
                    break;
                }
                case LEFT: {
                    if (flag) {
                        if (motion.f_82481_ > 0.0) {
                            this.fixedRailDirection = RailShape.NORTH_EAST;
                            break;
                        }
                        if (!(motion.f_82481_ <= 0.0)) break;
                        this.fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (motion.f_82479_ > 0.0) {
                        this.fixedRailDirection = RailShape.NORTH_WEST;
                        break;
                    }
                    if (!(motion.f_82479_ < 0.0)) break;
                    this.fixedRailDirection = RailShape.SOUTH_EAST;
                    break;
                }
                case RIGHT: {
                    if (flag) {
                        if (motion.f_82481_ > 0.0) {
                            this.fixedRailDirection = RailShape.NORTH_WEST;
                            break;
                        }
                        if (!(motion.f_82481_ <= 0.0)) break;
                        this.fixedRailDirection = RailShape.SOUTH_EAST;
                        break;
                    }
                    if (motion.f_82479_ > 0.0) {
                        this.fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (!(motion.f_82479_ < 0.0)) break;
                    this.fixedRailDirection = RailShape.NORTH_EAST;
                    break;
                }
                case NORTH: {
                    if (flag) {
                        if (!(motion.f_82481_ > 0.0)) break;
                        this.fixedRailDirection = RailShape.NORTH_SOUTH;
                        break;
                    }
                    if (motion.f_82479_ > 0.0) {
                        this.fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (!(motion.f_82479_ < 0.0)) break;
                    this.fixedRailDirection = RailShape.SOUTH_EAST;
                    break;
                }
            }
            if (this.fixedRailDirection == null) {
                return null;
            }
            this.fixedRailPos = new BlockPos((Vec3i)pos);
        }
        return this.fixedRailDirection;
    }

    public void resetRailDirection() {
        this.fixedRailDirection = null;
    }

    public void turnback() {
        this.pushX *= -1.0;
        this.pushZ *= -1.0;
        this.temppushX *= -1.0;
        this.temppushZ *= -1.0;
        this.m_20256_(this.m_20184_().m_82542_(-1.0, -1.0, -1.0));
    }

    public void releaseCart() {
        this.wasDisabled = true;
        this.setIsDisabled(false);
        this.pushX = this.temppushX;
        this.pushZ = this.temppushZ;
    }

    public ItemStack m_142340_() {
        return this.getCartItem();
    }

    public int m_6643_() {
        int slotCount = 0;
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                slotCount += module.getInventorySize();
            }
        }
        return slotCount;
    }

    public boolean m_7983_() {
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    return module.getStack(i);
                }
                i -= module.getInventorySize();
            }
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int i, int p_70298_2_) {
        if (!this.m_8020_(i).m_41619_()) {
            ItemStack var2 = this.m_8020_(i);
            this.m_6836_(i, ItemStack.f_41583_);
            return var2;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_8016_(int i) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int i, @NotNull ItemStack item) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    module.setStack(i, item);
                    break;
                }
                i -= module.getInventorySize();
            }
        }
    }

    public void m_6596_() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onInventoryChanged();
            }
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    protected void m_6401_(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (!this.m_20197_().isEmpty()) {
            Entity riddenByEntity = (Entity)this.m_20197_().get(0);
            if (riddenByEntity instanceof LivingEntity) {
                float move = riddenByEntity.f_19788_;
                riddenByEntity.f_19788_ = 0.0f;
                super.m_6401_(pos, state);
                riddenByEntity.f_19788_ = move;
            } else {
                super.m_6401_(pos, state);
            }
        } else {
            super.m_6401_(pos, state);
        }
        double d2 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        Vec3 motion = this.m_20184_();
        if (d2 > 1.0E-4 && motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_ > 0.001) {
            d2 = Math.sqrt(d2);
            this.pushX /= d2;
            this.pushZ /= d2;
            if (this.pushX * motion.f_82479_ + this.pushZ * motion.f_82481_ < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = motion.f_82479_;
                this.pushZ = motion.f_82481_;
            }
        }
    }

    protected void m_7114_() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        boolean bl = this.engineFlag = d0 > 1.0E-4;
        if (this.isDisabled()) {
            this.m_20334_(0.0, 0.0, 0.0);
        } else if (this.engineFlag) {
            d0 = Math.sqrt(d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            double d2 = this.getPushFactor();
            Vec3 vec3 = this.m_20184_().m_82542_(0.8, 0.0, 0.8).m_82520_(this.pushX * d2, 0.0, this.pushZ * d2);
            if (this.m_20069_()) {
                vec3 = vec3.m_82490_(0.1);
            }
            this.m_20256_(vec3);
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.98, 0.0, 0.98));
        }
        super.m_7114_();
    }

    protected double getPushFactor() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                double factor = module.getPushFactor();
                if (!(factor >= 0.0)) continue;
                return factor;
            }
        }
        return 0.05;
    }

    public boolean m_20223_(@NotNull CompoundTag tagCompound) {
        super.m_20223_(tagCompound);
        if (this.name != null) {
            tagCompound.m_128359_("cartName", this.name.getString());
        }
        tagCompound.m_128379_("engineFlag", this.engineFlag);
        tagCompound.m_128347_("pushX", this.pushX);
        tagCompound.m_128347_("pushZ", this.pushZ);
        tagCompound.m_128347_("temppushX", this.temppushX);
        tagCompound.m_128347_("temppushZ", this.temppushZ);
        tagCompound.m_128376_("workingTime", (short)this.workingTime);
        this.writeModulesToNbt(tagCompound);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.writeToNBT(tagCompound, i);
            }
        }
        return true;
    }

    public void writeModulesToNbt(CompoundTag compoundTag) {
        ListTag listTag = new ListTag();
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                CompoundTag compoundTag1 = new CompoundTag();
                compoundTag1.m_128359_(String.valueOf(i), this.modules.get(i).getModuleId().toString());
                listTag.add(i, (Tag)compoundTag1);
            }
            compoundTag.m_128365_("modules", (Tag)listTag);
        }
    }

    public void m_20258_(@NotNull CompoundTag tagCompound) {
        super.m_20258_(tagCompound);
        this.name = Component.m_237115_((String)tagCompound.m_128461_("cartName"));
        this.engineFlag = tagCompound.m_128471_("engineFlag");
        this.pushX = tagCompound.m_128459_("pushX");
        this.pushZ = tagCompound.m_128459_("pushZ");
        this.temppushX = tagCompound.m_128459_("temppushX");
        this.temppushZ = tagCompound.m_128459_("temppushZ");
        this.workingTime = tagCompound.m_128448_("workingTime");
        this.loadModules(tagCompound);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.readFromNBT(tagCompound, i);
            }
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.f_19804_.m_135370_(IS_DISANABLED);
    }

    public void setIsDisabled(boolean disabled) {
        this.f_19804_.m_135381_(IS_DISANABLED, (Object)disabled);
    }

    public void m_8119_() {
        this.f_38068_ = true;
        this.onCartUpdate();
        if (this.f_19853_.f_46443_) {
            this.updateSounds();
        }
        super.m_8119_();
    }

    public void onCartUpdate() {
        if (this.modules != null) {
            this.updateFuel();
            for (ModuleBase module : this.modules) {
                module.update();
            }
            for (ModuleBase module : this.modules) {
                module.postUpdate();
            }
            this.work();
            this.setCurrentCartSpeedCapOnRail(this.getMaxCartSpeedOnRail());
        }
        if (this.isPlaceholder && this.keepAlive++ > 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.placeholderAsssembler.resetPlaceholder();
        }
    }

    public boolean hasFuel() {
        if (this.isDisabled()) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.stopEngines()) continue;
                return false;
            }
        }
        return this.hasFuelForModule();
    }

    public boolean hasFuelForModule() {
        if (this.isPlaceholder) {
            return true;
        }
        int consumption = this.getConsumption(true);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.hasFuel(consumption)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        if (this.isPlaceholder) {
            return InteractionResult.FAIL;
        }
        if (this.modules != null && !player.m_6047_()) {
            boolean interupt = false;
            for (ModuleBase module : this.modules) {
                if (!module.onInteractFirst(player)) continue;
                interupt = true;
            }
            if (interupt) {
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (!this.isDisabled() && !this.m_20363_((Entity)player)) {
                this.temppushX = this.m_20185_() - player.m_20185_();
                this.temppushZ = this.m_20189_() - player.m_20189_();
            }
            if (!this.isDisabled() && this.hasFuel() && this.pushX == 0.0 && this.pushZ == 0.0) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, packetBuffer -> packetBuffer.writeInt(this.m_19879_()));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"entity.minecart");
    }

    public void loadChunks() {
    }

    public void loadChunks(int chunkX, int chunkZ) {
    }

    public void initChunkLoading() {
    }

    public void dropChunkLoading() {
    }

    public void setWorker(ModuleWorker worker) {
        if (this.workingComponent != null && worker != null) {
            this.workingComponent.stopWorking();
        }
        if ((this.workingComponent = worker) == null) {
            this.setWorkingTime(0);
        }
    }

    public ModuleWorker getWorker() {
        return this.workingComponent;
    }

    public void setWorkingTime(int val) {
        this.workingTime = val;
    }

    private void work() {
        if (this.isPlaceholder) {
            return;
        }
        if (!this.f_19853_.f_46443_ && this.hasFuel()) {
            if (this.workingTime <= 0) {
                ModuleWorker oldComponent = this.workingComponent;
                if (this.workingComponent != null) {
                    boolean result = this.workingComponent.work();
                    if (this.workingComponent != null && oldComponent == this.workingComponent && this.workingTime <= 0 && !this.workingComponent.preventAutoShutdown()) {
                        this.workingComponent.stopWorking();
                    }
                    if (result) {
                        this.work();
                        return;
                    }
                }
                if (this.workModules != null) {
                    for (ModuleWorker module : this.workModules) {
                        if (!module.work()) continue;
                        return;
                    }
                }
            } else {
                --this.workingTime;
            }
        }
    }

    public void handleActivator(ActivatorOption option, boolean isOrange) {
        for (ModuleBase module : this.modules) {
            if (!(module instanceof IActivatorModule)) continue;
            IActivatorModule activator = (IActivatorModule)((Object)module);
            if (!option.getModule().isAssignableFrom(module.getClass())) continue;
            if (option.shouldActivate(isOrange)) {
                activator.doActivate(option.getId());
                continue;
            }
            if (option.shouldDeactivate(isOrange)) {
                activator.doDeActivate(option.getId());
                continue;
            }
            if (!option.shouldToggle()) continue;
            if (activator.isActive(option.getId())) {
                activator.doDeActivate(option.getId());
                continue;
            }
            activator.doActivate(option.getId());
        }
    }

    public boolean getRenderFlippedYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        Vec3 motion = this.m_20184_();
        if (!this.oldRender || Math.abs(yaw - this.lastRenderYaw) < 90.0f || Math.abs(yaw - this.lastRenderYaw) > 270.0f || motion.f_82479_ > 0.0 && this.lastMotionX < 0.0 || motion.f_82481_ > 0.0 && this.lastMotionZ < 0.0 || motion.f_82479_ < 0.0 && this.lastMotionX > 0.0 || motion.f_82481_ < 0.0 && this.lastMotionZ > 0.0 || this.wrongRender >= 50) {
            this.lastMotionX = motion.f_82479_;
            this.lastMotionZ = motion.f_82481_;
            this.lastRenderYaw = yaw;
            this.oldRender = true;
            this.wrongRender = 0;
            return false;
        }
        ++this.wrongRender;
        return true;
    }

    public ArrayList<Component> getLabel() {
        ArrayList<Component> label = new ArrayList<Component>();
        if (this.getModules() != null) {
            for (ModuleBase module : this.getModules()) {
                module.addToLabel(label);
            }
        }
        return label;
    }

    public int x() {
        return Mth.m_14107_((double)this.m_20182_().f_82479_);
    }

    public int y() {
        return Mth.m_14107_((double)this.m_20182_().f_82480_);
    }

    public int z() {
        return Mth.m_14107_((double)this.m_20182_().f_82481_);
    }

    public BlockPos getExactPosition() {
        return this.m_20183_();
    }

    public void addItemToChest(@Nonnull ItemStack iStack) {
        TransferHandler.TransferItem(iStack, (Container)this, this.getCon(null), Slot.class, null, -1);
    }

    public void addItemToChest(@Nonnull ItemStack iStack, int start, int end) {
        TransferHandler.TransferItem(iStack, this, start, end, this.getCon(null), Slot.class, null, -1);
    }

    public void addItemToChest(@Nonnull ItemStack iStack, Class validSlot, Class invalidSlot) {
        TransferHandler.TransferItem(iStack, (Container)this, this.getCon(null), validSlot, invalidSlot, -1);
    }

    public AbstractContainerMenu getCon(Inventory playerInventory) {
        return new ContainerMinecart(0, playerInventory, this, this.dataAccess);
    }

    public void setPlaceholder(TileEntityCartAssembler assembler) {
        this.isPlaceholder = true;
        this.placeholderAsssembler = assembler;
    }

    public boolean m_5829_() {
        return !this.isPlaceholder && super.m_5829_();
    }

    private void generateModels() {
        if (this.modules != null) {
            ModuleData data;
            ArrayList<String> invalid = new ArrayList<String>();
            for (ModuleBase module : this.modules) {
                data = module.getData();
                if (!data.haveRemovedModels()) continue;
                invalid.addAll(data.getRemovedModels());
            }
            for (int i = this.modules.size() - 1; i >= 0; --i) {
                ModuleBase module;
                module = this.modules.get(i);
                data = module.getData();
                if (data == null || !data.haveModels(this.isPlaceholder)) continue;
                ArrayList<ModelCartbase> models = new ArrayList<ModelCartbase>();
                for (String str : data.getModels(this.isPlaceholder).keySet()) {
                    if (invalid.contains(str)) continue;
                    models.add(data.getModels(this.isPlaceholder).get(str));
                    invalid.add(str);
                }
                if (models.size() <= 0) continue;
                module.setModels(models);
            }
        }
    }

    public void writeSpawnData(FriendlyByteBuf data) {
        if (this.moduleLoadingData == null) {
            return;
        }
        data.writeByte(this.moduleLoadingData.size());
        for (ResourceLocation b : this.moduleLoadingData) {
            data.m_130085_(b);
        }
    }

    public void readSpawnData(FriendlyByteBuf data) {
        int length = data.readByte();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < length; ++i) {
            list.add(data.m_130281_());
        }
        this.loadModulesFromNames(list);
    }

    public void setScrollY(int val) {
        if (this.canScrollModules) {
            this.scrollY = val;
        }
    }

    public int getScrollY() {
        if (this.getInterfaceThief() != null) {
            return 0;
        }
        return this.scrollY;
    }

    public int getRealScrollY() {
        return (int)((float)(this.modularSpaceHeight - 168) / 198.0f * (float)this.getScrollY());
    }

    public boolean hasCreativeSupplies() {
        return this.creativeSupplies != null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void silent() {
        this.keepSilent = 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateSounds() {
    }

    public Entity getCartRider() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    @Nullable
    public Entity m_6688_() {
        return null;
    }

    public SynchedEntityData getDataManager() {
        return this.f_19804_;
    }

    public int getNextDataWatcher() {
        ++this.base;
        return this.getDataManager().m_135384_().size() + this.base + 1;
    }

    public void m_6211_() {
    }

    public int getTanks() {
        return this.getModuleTanks().size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.tankModules.get(tank).getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tankModules.get(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.tankModules.get(tank).isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = 0;
        if (resource != null && resource.getAmount() > 0) {
            FluidStack fluid = resource.copy();
            for (int i = 0; i < this.tankModules.size(); ++i) {
                int tempAmount = this.tankModules.get(i).fill(fluid, action);
                amount += tempAmount;
                fluid.shrink(tempAmount);
                if (fluid.getAmount() <= 0) break;
            }
        }
        return amount;
    }

    private FluidStack drain(FluidStack resource, int maxDrain, IFluidHandler.FluidAction doDrain) {
        FluidStack ret = resource;
        if (ret != null) {
            ret = ret.copy();
            ret.setAmount(0);
        }
        for (int i = 0; i < this.tankModules.size(); ++i) {
            FluidStack temp = null;
            temp = this.tankModules.get(i).drain(maxDrain, doDrain);
            if (temp == null || ret != null && !ret.isFluidEqual(temp)) continue;
            if (ret == null) {
                ret = temp;
            } else {
                ret.grow(temp.getAmount());
            }
            if ((maxDrain -= temp.getAmount()) <= 0) break;
        }
        if (ret != null && ret.getAmount() == 0) {
            return null;
        }
        return ret;
    }

    public int drain(Fluid type, int maxDrain, IFluidHandler.FluidAction doDrain) {
        int amount = 0;
        if (type != null && maxDrain > 0) {
            for (ModuleTank tank : this.tankModules) {
                FluidStack drained = tank.drain(maxDrain, doDrain);
                if (drained.isEmpty() || !type.m_6212_(drained.getFluid())) continue;
                amount += drained.getAmount();
                maxDrain -= drained.getAmount();
                if (doDrain == IFluidHandler.FluidAction.EXECUTE) {
                    tank.drain(drained.getAmount(), doDrain);
                }
                if (maxDrain > 0) continue;
                break;
            }
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource, !resource.isEmpty() ? 0 : resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(maxDrain, action);
    }

    public void m_6038_() {
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            ItemEntity cartItem = new ItemEntity(this.f_19853_, (double)this.getExactPosition().m_123341_(), (double)this.getExactPosition().m_123342_(), (double)this.getExactPosition().m_123343_(), this.getCartItem());
            this.f_19853_.m_7967_((Entity)cartItem);
        }
        super.m_6038_();
    }

    @org.jetbrains.annotations.Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        this.container = new ContainerMinecart(id, inventory, this, this.dataAccess);
        return this.container;
    }

    static {
        IS_BURNING = SynchedEntityData.m_135353_(EntityMinecartModular.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        IS_DISANABLED = SynchedEntityData.m_135353_(EntityMinecartModular.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        railDirectionCoordinates = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    }
}

