/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers.slots;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.helpers.storages.SCTank;

public class SlotLiquidInput
extends SlotBase {
    private SCTank tank;
    private int maxsize;

    public SlotLiquidInput(Container iinventory, SCTank tank, int maxsize, int i, int j, int k) {
        super(iinventory, i, j, k);
        this.tank = tank;
        this.maxsize = maxsize;
    }

    public boolean m_5857_(@NotNull ItemStack itemStack) {
        LazyOptional opt = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (!opt.isPresent()) {
            return false;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)opt.orElseThrow(RuntimeException::new);
        FluidStack fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.isEmpty() && !this.tank.getFluid().isEmpty()) {
            return true;
        }
        return this.tank.getFluid().isEmpty() || this.tank.getFluid().isFluidEqual(fluidStack);
    }

    public int m_6641_() {
        if (this.maxsize != -1) {
            return this.maxsize;
        }
        return Math.min(8, this.tank.getCapacity() / 1000);
    }
}

