/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.slots.SlotLiquidFilter;
import vswe.stevescarts.containers.slots.SlotLiquidManagerInput;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.init.ModContainers;

public class ContainerLiquid
extends ContainerBase {
    public FluidStack[] oldLiquids = new FluidStack[4];
    public SimpleContainerData data;
    private final TileEntityLiquid tileEntityLiquid;

    public ContainerLiquid(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (TileEntityLiquid)Objects.requireNonNull(Minecraft.m_91087_().f_91073_.m_7702_(packetBuffer.m_130135_())), new SimpleContainerData(13));
    }

    public ContainerLiquid(int id, Inventory playerInventory, TileEntityLiquid tileEntityLiquid, SimpleContainerData data) {
        super((MenuType)ModContainers.CONTAINER_LIQUID.get(), id);
        this.tileEntityLiquid = tileEntityLiquid;
        this.data = data;
        for (int i = 0; i < 4; ++i) {
            int x = i % 2;
            int y = i / 2;
            this.m_38897_(new SlotLiquidManagerInput(tileEntityLiquid, i, i * 3, x == 0 ? 6 : 208, y == 0 ? 17 : 80));
            this.m_38897_(new SlotLiquidOutput(tileEntityLiquid, i * 3 + 1, x == 0 ? 6 : 208, y == 0 ? 42 : 105));
            this.m_38897_(new SlotLiquidFilter(tileEntityLiquid, i * 3 + 2, x == 0 ? 66 : 148, y == 0 ? 12 : 110));
        }
        for (int k = 0; k < 3; ++k) {
            for (int j1 = 0; j1 < 9; ++j1) {
                Slot s = new Slot((Container)playerInventory, j1 + k * 9 + 9, j1 * 18 + this.offsetX(), 104 + k * 18 + 36);
                this.m_38897_(s);
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInventory, l, l * 18 + this.offsetX(), 198));
        }
        this.m_38884_((ContainerData)data);
    }

    public int getLayoutType() {
        return this.data.m_6413_(0);
    }

    public int[] getColor() {
        return new int[]{this.data.m_6413_(1), this.data.m_6413_(2), this.data.m_6413_(3), this.data.m_6413_(4)};
    }

    public boolean[] toCart() {
        return new boolean[]{this.data.m_6413_(5) == 1, this.data.m_6413_(6) == 1, this.data.m_6413_(7) == 1, this.data.m_6413_(8) == 1};
    }

    public boolean[] doReturn() {
        return new boolean[]{this.data.m_6413_(9) == 1, this.data.m_6413_(10) == 1, this.data.m_6413_(11) == 1, this.data.m_6413_(12) == 1};
    }

    protected int offsetX() {
        return 35;
    }

    public TileEntityLiquid getTileEntityLiquid() {
        return this.tileEntityLiquid;
    }

    public boolean m_6875_(@NotNull Player playerEntity) {
        return true;
    }
}

