/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models.engines;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.engines.ModuleSolarCompact;

public class ModelCompactSolarPanel
extends ModelCartbase {
    private static ResourceLocation texture = ResourceHelper.getResource("/models/panelModelSideActive.png");
    private static ResourceLocation texture2 = ResourceHelper.getResource("/models/panelModelSideIdle.png");
    private ModelPart modelLeft;
    private ModelPart modelRight;
    private ModelPart[][] modelParts;

    public ModelCompactSolarPanel() {
        super(null, texture);
        this.generateModels();
    }

    @Override
    public RenderType getRenderType(ModuleBase module) {
        if (module != null && ((ModuleSolarCompact)module).getLight() == 15) {
            return RenderType.m_110446_((ResourceLocation)texture);
        }
        return RenderType.m_110446_((ResourceLocation)texture2);
    }

    private void generateModels() {
        this.modelParts = new ModelPart[2][];
        this.modelParts[0] = this.createSide(false, modelPart -> {
            this.modelLeft = modelPart;
        });
        this.modelParts[1] = this.createSide(true, modelPart -> {
            this.modelRight = modelPart;
        });
    }

    private ModelPart[] createSide(boolean reverse, Consumer<ModelPart> buildModel) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition anchor = modelPartData.m_171599_("anchor", CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)(reverse ? (float)Math.PI : 0.0f), (float)0.0f));
        anchor.m_171599_("base", CubeListBuilder.m_171558_().m_171481_(-7.0f, -6.0f, -1.5f, 14.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-9.0f));
        PartDefinition panelArmInner = anchor.m_171599_("panelArmInner", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171481_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition panelArmOuter = panelArmInner.m_171599_("panelArmOuter", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171481_(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 4.0f), PartPose.m_171419_((float)0.001f, (float)0.001f, (float)0.001f));
        PartDefinition panelBase = panelArmOuter.m_171599_("panelBase", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-5.5f, -2.0f, -1.0f, 11.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.8f));
        this.createPanel(panelBase, "panelTop", 10, 4, -0.497f, 0, 15);
        this.createPanel(panelBase, "panelBot", 10, 4, -0.494f, 22, 15);
        PartDefinition panelLeft = this.createPanel(panelBase, "panelLeft", 6, 4, -0.491f, 0, 20);
        PartDefinition panelRight = this.createPanel(panelBase, "panelRight", 6, 4, -0.488f, 14, 20);
        this.createPanel(panelLeft, "panelTopLeft", 6, 4, 0.002f, 0, 25);
        this.createPanel(panelLeft, "panelBotLeft", 6, 4, 0.001f, 28, 25);
        this.createPanel(panelRight, "panelTopRight", 6, 4, 0.002f, 14, 25);
        this.createPanel(panelRight, "panelBotRight", 6, 4, 0.001f, 42, 25);
        ModelPart anchorPart = anchor.m_171583_(64, 32);
        buildModel.accept(anchorPart);
        ModelPart armInnerPart = anchorPart.m_171324_("panelArmInner");
        ModelPart armOuterPart = armInnerPart.m_171324_("panelArmOuter");
        ModelPart panelBasePart = armOuterPart.m_171324_("panelBase");
        ModelPart panelLeftPart = panelBasePart.m_171324_("panelLeft");
        ModelPart panelRightPart = panelBasePart.m_171324_("panelRight");
        return new ModelPart[]{panelBasePart, panelBasePart.m_171324_("panelTop"), panelBasePart.m_171324_("panelBot"), panelLeftPart, panelRightPart, panelLeftPart.m_171324_("panelTopLeft"), panelRightPart.m_171324_("panelTopRight"), panelLeftPart.m_171324_("panelBotLeft"), panelRightPart.m_171324_("panelBotRight"), armOuterPart, armInnerPart};
    }

    private PartDefinition createPanel(PartDefinition parent, String name, int width, int height, float offset, int textureOffsetX, int textureOffsetY) {
        return parent.m_171599_(name, CubeListBuilder.m_171558_().m_171514_(textureOffsetX, textureOffsetY).m_171481_((float)(-width / 2), (float)(-height / 2), -0.5f, (float)width, (float)height, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)offset));
    }

    @Override
    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, float red, float green, float blue, float alpha) {
        this.modelLeft.m_104306_(poseStack, vertexConsumers, light, overlay, red, green, blue, alpha);
        this.modelRight.m_104306_(poseStack, vertexConsumers, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        this.generateModels();
        if (module == null) {
            for (int i = 0; i < 2; ++i) {
                float n2;
                float n;
                ModelPart[] models = this.modelParts[i];
                models[9].f_104202_ = 0.6f;
                models[10].f_104202_ = -8.1f;
                models[1].f_104201_ = -0.1f;
                models[2].f_104201_ = 0.1f;
                models[3].f_104200_ = -2.01f;
                models[4].f_104200_ = 2.01f;
                ModelPart modelRenderer = models[5];
                ModelPart modelRenderer2 = models[6];
                modelRenderer2.f_104201_ = n = -0.1f;
                modelRenderer.f_104201_ = n;
                ModelPart modelRenderer3 = models[7];
                ModelPart modelRenderer4 = models[8];
                modelRenderer4.f_104201_ = n2 = 0.1f;
                modelRenderer3.f_104201_ = n2;
                models[9].f_104203_ = 0.0f;
            }
        } else {
            ModuleSolarCompact solar = (ModuleSolarCompact)module;
            for (int j = 0; j < 2; ++j) {
                float cornerExtractionDist;
                float n3;
                ModelPart[] models2 = this.modelParts[j];
                models2[9].f_104202_ = 1.0f - solar.getExtractionDist();
                models2[10].f_104202_ = -7.7f - solar.getInnerExtraction();
                models2[1].f_104201_ = -solar.getTopBotExtractionDist();
                models2[2].f_104201_ = solar.getTopBotExtractionDist();
                models2[3].f_104200_ = -2.0f - solar.getLeftRightExtractionDist();
                models2[4].f_104200_ = 2.0f + solar.getLeftRightExtractionDist();
                ModelPart modelRenderer5 = models2[5];
                ModelPart modelRenderer6 = models2[6];
                modelRenderer6.f_104201_ = n3 = -solar.getCornerExtractionDist();
                modelRenderer5.f_104201_ = n3;
                ModelPart modelRenderer7 = models2[7];
                ModelPart modelRenderer8 = models2[8];
                modelRenderer8.f_104201_ = cornerExtractionDist = solar.getCornerExtractionDist();
                modelRenderer7.f_104201_ = cornerExtractionDist;
                models2[9].f_104203_ = -solar.getPanelAngle();
            }
        }
    }
}

