/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleShield;

public class ModelShield
extends ModelCartbase {
    private ModelPart[] shields;
    private boolean enabled = false;
    private ModuleBase module;

    public ModelShield() {
        super(null, ResourceHelper.getResource("/models/shieldModel.png"));
        this.buildModels();
    }

    public void buildModels() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        this.shields = new ModelPart[20];
        for (int i = 0; i < this.shields.length; ++i) {
            this.shields[i] = modelPartData.m_171599_("shield" + i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f)).m_171583_(8, 4);
        }
    }

    @Override
    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.enabled) {
            return;
        }
        for (ModelPart shield : this.shields) {
            shield.m_104306_(poseStack, vertexConsumers, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        float shieldDistance = module == null ? 18.0f : ((ModuleShield)module).getShieldDistance();
        boolean bl = this.enabled = module == null || ((ModuleShield)module).hasShield();
        if (!this.enabled) {
            return;
        }
        float shieldAngle = module == null ? 0.0f : ModelShield.interpolate(((ModuleShield)module).getShieldAngle(), ((ModuleShield)module).getShieldAngle(), Minecraft.m_91087_().getPartialTick());
        for (int i = 0; i < this.shields.length; ++i) {
            ModelPart part = this.shields[i];
            int yPos = i / 5;
            double angularPos = (double)(i % 5) / 5.0 * Math.PI * 2.0;
            part.f_104201_ = (float)Math.sin(shieldAngle / 5.0f) * 3.0f + shieldDistance / 18.0f * 5.0f * (float)(-yPos);
            part.f_104200_ = (float)Math.sin(angularPos += (double)(shieldAngle + (float)Math.PI * 2 * ((float)yPos / 4.0f))) * shieldDistance;
            part.f_104202_ = (float)Math.cos(angularPos) * shieldDistance;
        }
    }

    public static float interpolate(float a, float b, float d) {
        return a + (b - a) * d;
    }
}

