/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.realtimers.ModuleFlowerRemover;

public class ModelLawnMower
extends ModelCartbase {
    private static final ArrayList<ModelPart> bladepins = new ArrayList();
    private static ModelPart leftSide;
    private static ModelPart rightSide;

    public ModelLawnMower() {
        super(null, ResourceHelper.getResource("/models/lawnmowerModel.png"));
        ModelLawnMower.genModel();
    }

    public static void genModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        leftSide = ModelLawnMower.createSide(partdefinition, false);
        rightSide = ModelLawnMower.createSide(partdefinition, true);
    }

    private static ModelPart createSide(PartDefinition partDefinition, boolean opposite) {
        PartDefinition anchor = partDefinition.m_171599_("anchor", CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)(opposite ? (float)Math.PI : 0.0f), (float)0.0f));
        PartDefinition base = anchor.m_171599_("base", CubeListBuilder.m_171558_().m_171481_(-11.5f, -3.0f, -1.0f, 23.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-9.0f));
        for (int i = 0; i < 2; ++i) {
            PartDefinition arm = base.m_171599_("arm" + i, CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-8.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f), PartPose.m_171423_((float)(-8.25f + (float)i * 16.5f), (float)0.0f, (float)-8.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
            PartDefinition arm2 = arm.m_171599_("arm2" + i, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)6.5f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f));
            PartDefinition bladePin = arm2.m_171599_("bladepin" + i, CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f), PartPose.m_171419_((float)2.5f, (float)0.0f, (float)0.0f));
            PartDefinition bladeAnchor = bladePin.m_171599_("bladeanchor" + i, CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)1.5707964f, (float)0.0f));
            for (int j = 0; j < 4; ++j) {
                PartDefinition blade = bladeAnchor.m_171599_("blade" + j, CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-1.5f, -1.5f, -0.5f, 8.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)((float)j * 0.01f), (float)0.0f, (float)0.0f, (float)(1.5707964f * ((float)j + (float)i * 0.5f))));
                PartDefinition partDefinition2 = blade.m_171599_("bladetip" + j, CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(6.5f, -1.0f, -0.5f, 6.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.005f));
            }
        }
        ModelPart anchorPart = anchor.m_171583_(64, 32);
        ModelPart basePart = anchorPart.m_171324_("base");
        for (int i = 0; i < 2; ++i) {
            ModelPart armPart = basePart.m_171324_("arm" + i);
            ModelPart arm2Part = armPart.m_171324_("arm2" + i);
            ModelPart bladePinPart = arm2Part.m_171324_("bladepin" + i);
            bladepins.add(bladePinPart);
        }
        return anchorPart;
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        ModelLawnMower.genModel();
        boolean partialtime = false;
        float angle = module == null ? 0.0f : ((ModuleFlowerRemover)module).getBladeAngle() + (float)partialtime * ((ModuleFlowerRemover)module).getBladeSpeed();
        for (int i = 0; i < bladepins.size(); ++i) {
            ModelPart bladepin = bladepins.get(i);
            bladepin.f_104203_ = i % 2 == 0 ? angle : -angle;
        }
    }

    @Override
    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, float red, float green, float blue, float alpha) {
        leftSide.m_104306_(poseStack, vertexConsumers, light, overlay, red, green, blue, alpha);
        rightSide.m_104306_(poseStack, vertexConsumers, light, overlay, red, green, blue, alpha);
    }
}

