/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerDistributor;
import vswe.stevescarts.helpers.DistributorSetting;
import vswe.stevescarts.helpers.DistributorSide;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class GuiDistributor
extends AbstractContainerScreen<ContainerDistributor> {
    private String mouseOverText;
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/distributor.png");
    private int activeId = -1;
    private final TileEntityDistributor distributor;

    public GuiDistributor(ContainerDistributor containerDistributor, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerDistributor, playerInventory, iTextComponent);
        this.f_97726_ = 255;
        this.f_97727_ = 186;
        this.distributor = containerDistributor.getDistributor();
    }

    protected void m_7286_(@NotNull PoseStack poseStack, float p_230450_2_, int x, int y) {
        int[] box;
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(texture);
        this.m_93228_(poseStack, j, k, 0, 0, this.f_97726_, this.f_97727_);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        TileEntityManager[] invs = this.distributor.getInventories();
        ArrayList<DistributorSide> sides = this.distributor.getSides();
        int id = 0;
        for (DistributorSide side : sides) {
            if (!side.isEnabled(this.distributor)) continue;
            box = this.getSideBoxRect(id);
            int srcX = 0;
            if (this.inRect(x, y, box)) {
                srcX = box[2];
            }
            this.m_93228_(poseStack, j + box[0], k + box[1], srcX, this.f_97727_, box[2], box[3]);
            this.m_93228_(poseStack, j + box[0] + 2, k + box[1] + 2, box[2] * 2 + (box[2] - 4) * side.getId(), this.f_97727_, box[2] - 4, box[3] - 4);
            this.drawMouseMover(Localization.GUI.DISTRIBUTOR.SIDE.translate(side.getName()) + (String)(this.activeId != -1 ? ": [" + Localization.GUI.DISTRIBUTOR.DROP_INSTRUCTION.translate(new String[0]) + "]" : ""), x, y, box);
            int settingCount = 0;
            for (DistributorSetting setting : DistributorSetting.settings) {
                if (!setting.isEnabled(this.distributor) || !side.isSet(setting.getId())) continue;
                int[] settingbox = this.getActiveSettingBoxRect(id, settingCount++);
                this.drawSetting(poseStack, setting, settingbox, this.inRect(x, y, settingbox));
                this.drawMouseMover(setting.getName(invs) + ": [" + Localization.GUI.DISTRIBUTOR.REMOVE_INSTRUCTION.translate(new String[0]) + "]", x, y, settingbox);
            }
            ++id;
        }
        for (DistributorSetting setting2 : DistributorSetting.settings) {
            if (!setting2.isEnabled(this.distributor)) continue;
            box = this.getSettingBoxRect(setting2.getImageId(), setting2.getIsTop());
            this.drawSetting(poseStack, setting2, box, this.inRect(x, y, box));
            this.drawMouseMover(setting2.getName(invs), x, y, box);
        }
        if (this.activeId != -1) {
            DistributorSetting setting3 = DistributorSetting.settings.get(this.activeId);
            this.drawSetting(poseStack, setting3, new int[]{x - 8, y - 8, 16, 16}, true);
        }
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int p_230451_2_, int p_230451_3_) {
    }

    public void m_6305_(@NotNull PoseStack poseStack, int x, int y, float p_230430_4_) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, p_230430_4_);
        this.f_96547_.m_92883_(poseStack, Localization.GUI.DISTRIBUTOR.TITLE.translate(new String[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + 6), 0x404040);
        TileEntityManager[] invs = this.distributor.getInventories();
        if (invs.length == 0) {
            this.f_96547_.m_92883_(poseStack, Localization.GUI.DISTRIBUTOR.NOT_CONNECTED.translate(new String[0]), (float)(this.f_97735_ + 30), (float)(this.f_97736_ + 40), 0xFF4040);
        }
        if (this.mouseOverText != null && !this.mouseOverText.equals("")) {
            this.m_96602_(poseStack, (Component)Component.m_237113_((String)this.mouseOverText), x, y);
        }
        this.mouseOverText = null;
    }

    private void drawMouseMover(String str, int x, int y, int[] rect) {
        if (this.inRect(x, y, rect)) {
            this.mouseOverText = str;
        }
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    private void drawSetting(PoseStack matrixStack, DistributorSetting setting, int[] box, boolean hover) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        int srcX = 0;
        if (!setting.getIsTop()) {
            srcX += box[2] * 2;
        }
        if (hover) {
            srcX += box[2];
        }
        this.m_93228_(matrixStack, j + box[0], k + box[1], srcX, this.f_97727_ + this.getSideBoxRect(0)[3], box[2], box[3]);
        this.m_93228_(matrixStack, j + box[0] + 1, k + box[1] + 1, box[2] * 4 + (box[2] - 2) * setting.getImageId(), this.f_97727_ + this.getSideBoxRect(0)[3], box[2] - 2, box[3] - 2);
    }

    private int[] getSideBoxRect(int i) {
        return new int[]{20, 18 + i * 24, 22, 22};
    }

    private int[] getSettingBoxRect(int i, boolean topRow) {
        return new int[]{20 + i * 18, 143 + (topRow ? 0 : 18), 16, 16};
    }

    private int[] getActiveSettingBoxRect(int side, int setting) {
        int[] sideCoords = this.getSideBoxRect(side);
        return new int[]{sideCoords[0] + sideCoords[2] + 5 + setting * 18, sideCoords[1] + (sideCoords[3] - 16) / 2, 16, 16};
    }

    public boolean m_6375_(double x, double y, int button) {
        block5: {
            block6: {
                x -= (double)this.getGuiLeft();
                y -= (double)this.getGuiTop();
                if (button != 0) break block6;
                for (DistributorSetting setting : DistributorSetting.settings) {
                    int[] box;
                    if (!setting.isEnabled(this.distributor) || !this.inRect((int)x, (int)y, box = this.getSettingBoxRect(setting.getImageId(), setting.getIsTop()))) continue;
                    this.activeId = setting.getId();
                }
                if (this.activeId == -1) break block5;
                int id = 0;
                for (DistributorSide side : this.distributor.getSides()) {
                    int[] box;
                    if (!side.isEnabled(this.distributor) || !this.inRect((int)x, (int)y, box = this.getSideBoxRect(id++))) continue;
                    this.distributor.getSides().get(side.getId()).set(this.activeId);
                    this.distributor.sendPacket(0, new byte[]{(byte)this.activeId, (byte)side.getId()});
                    this.activeId = -1;
                    break block5;
                }
                break block5;
            }
            if (button == 1) {
                int id = 0;
                for (DistributorSide side : this.distributor.getSides()) {
                    if (!side.isEnabled(this.distributor)) continue;
                    int settingCount = 0;
                    for (DistributorSetting setting : DistributorSetting.settings) {
                        int[] settingbox;
                        if (!setting.isEnabled(this.distributor) || !side.isSet(setting.getId()) || !this.inRect((int)x, (int)y, settingbox = this.getActiveSettingBoxRect(id, settingCount++))) continue;
                        this.distributor.getSides().get(side.getId()).reset(setting.getId());
                        this.distributor.sendPacket(1, new byte[]{(byte)setting.getId(), (byte)side.getId()});
                        this.activeId = -1;
                        break;
                    }
                    ++id;
                }
            }
        }
        return super.m_6375_(x, y, button);
    }
}

