/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.containers.ContainerCargo;
import vswe.stevescarts.helpers.CargoItemSelection;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.init.ModBlocks;

public class GuiCargo
extends AbstractContainerScreen<ContainerCargo> {
    private static ResourceLocation[] texturesLeft = new ResourceLocation[]{ResourceHelper.getResource("/gui/cargoVersion0Part1.png"), ResourceHelper.getResource("/gui/cargoVersion1Part1.png")};
    private static ResourceLocation[] texturesRight = new ResourceLocation[]{ResourceHelper.getResource("/gui/cargoVersion0Part2.png"), ResourceHelper.getResource("/gui/cargoVersion1Part2.png")};
    private final ContainerCargo containerCargo;
    private final TileEntityCargo manager;

    public GuiCargo(ContainerCargo containerCargo, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerCargo, playerInventory, iTextComponent);
        this.containerCargo = containerCargo;
        this.f_97726_ = 305;
        this.f_97727_ = 222;
        this.manager = containerCargo.tileEntityCargo;
    }

    protected void m_7286_(@NotNull PoseStack poseStack, float mouseX, int mouseY, int partial) {
        int version = this.containerCargo.getLayoutType() == 0 ? 0 : 1;
        ResourceHelper.bindResource(texturesLeft[version]);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 256, this.f_97727_);
        ResourceHelper.bindResource(texturesRight[version]);
        this.m_93228_(poseStack, this.f_97735_ + 256, this.f_97736_, 0, 0, this.f_97726_ - 256, this.f_97727_);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        for (int i = 0; i < 4; ++i) {
            this.drawArrow(poseStack, i, left, top);
            int color = this.containerCargo.getColor()[i] - 1;
            if (color == 4) continue;
            this.drawColors(poseStack, i, color, left, top);
        }
        ItemRenderer renderitem = Minecraft.m_91087_().m_91291_();
        int[] coords = this.getMiddleCoords();
        renderitem.m_115123_(new ItemStack((ItemLike)this.getBlock(), 1), left + coords[0], top + coords[1]);
        for (int j = 0; j < 4; ++j) {
            this.drawItems(j, renderitem, left, top);
        }
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int p_230451_2_, int p_230451_3_) {
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float p_230430_4_) {
        int i;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, p_230430_4_);
        this.m_7025_(poseStack, mouseX, mouseY);
        int[] coords = this.getMiddleCoords();
        this.f_96547_.m_92883_(poseStack, this.getManagerName(), (float)(this.f_97735_ + coords[0] - 34), (float)(this.f_97736_ + 4), 0x404040);
        this.f_96547_.m_92883_(poseStack, Localization.GUI.MANAGER.TITLE.translate(new String[0]), (float)(this.f_97735_ + coords[0] + coords[2]), (float)(this.f_97736_ + 4), 0x404040);
        for (i = 0; i < 4; ++i) {
            coords = this.getTextCoords(i);
            String str = this.getMaxSizeText(i);
            this.f_96547_.m_92883_(poseStack, str, (float)(this.f_97735_ + coords[0]), (float)(this.f_97736_ + coords[1]), 0x404040);
        }
        for (i = 0; i < 4; ++i) {
            try {
                this.drawExtraOverlay(poseStack, i, mouseX, mouseY);
                this.drawMouseOver(poseStack, Localization.GUI.MANAGER.CHANGE_TRANSFER_DIRECTION.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.containerCargo.toCart()[i] ? Localization.GUI.MANAGER.DIRECTION_TO_CART.translate(new String[0]) : Localization.GUI.MANAGER.DIRECTION_FROM_CART.translate(new String[0])), mouseX, mouseY, this.getArrowCoords(i));
                this.drawMouseOver(poseStack, Localization.GUI.MANAGER.CHANGE_TURN_BACK_SETTING.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.containerCargo.getColor()[i] == 5 ? Localization.GUI.MANAGER.TURN_BACK_NOT_SELECTED.translate(new String[0]) : (this.containerCargo.doReturn()[this.containerCargo.getColor()[i] - 1] ? Localization.GUI.MANAGER.TURN_BACK_DO.translate(new String[0]) : Localization.GUI.MANAGER.TURN_BACK_DO_NOT.translate(new String[0]))), mouseX, mouseY, this.getReturnCoords(i));
                this.drawMouseOver(poseStack, Localization.GUI.MANAGER.CHANGE_TRANSFER_SIZE.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getMaxSizeOverlay(i), mouseX, mouseY, this.getTextCoords(i));
                this.drawMouseOver(poseStack, Localization.GUI.MANAGER.CHANGE_SIDE.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SIDE.translate(new String[0]) + ": " + (new String[]{Localization.GUI.MANAGER.SIDE_RED.translate(new String[0]), Localization.GUI.MANAGER.SIDE_BLUE.translate(new String[0]), Localization.GUI.MANAGER.SIDE_YELLOW.translate(new String[0]), Localization.GUI.MANAGER.SIDE_GREEN.translate(new String[0]), Localization.GUI.MANAGER.SIDE_DISABLED.translate(new String[0])})[this.containerCargo.getColor()[i] - 1], mouseX, mouseY, this.getColorpickerCoords(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.drawMouseOver(poseStack, this.getLayoutString() + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getLayoutOption(this.containerCargo.getLayoutType()), mouseX, mouseY, this.getMiddleCoords());
    }

    protected void drawColors(PoseStack matrixStack, int id, int color, int left, int top) {
        try {
            int[] coords = this.getReturnCoords(id);
            this.m_93228_(matrixStack, left + coords[0], top + coords[1], this.getColorSourceX() + (this.containerCargo.doReturn()[this.containerCargo.getColor()[id] - 1] ? 8 : 0), 80 + 8 * color, 8, 8);
            coords = this.getBoxCoords(id);
            this.m_93228_(matrixStack, left + coords[0] - 2, top + coords[1] - 2, this.getColorSourceX(), 20 * color, 20, 20);
            if (this.containerCargo.getLayoutType() == 2) {
                int[] coords1 = this.getInvCoords(id);
                this.m_93228_(matrixStack, left + coords1[0] - 2, top + coords1[1] - 2, 125, 56 * color, 92, 56);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int[] getReturnCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 14 + x * 70;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 8, 8};
    }

    private void drawArrow(PoseStack matrixStack, int id, int left, int top) {
        int sourceX = this.getArrowSourceX();
        int sourceY = 28;
        sourceY += 56 * id;
        if (!this.containerCargo.toCart()[id]) {
            sourceX += 28;
        }
        int targetX = this.getArrowCoords(id)[0];
        int targetY = this.getArrowCoords(id)[1];
        int sizeX = 28;
        int sizeY = 28;
        this.m_93228_(matrixStack, left + targetX, top + targetY, sourceX, sourceY, sizeX, sizeY);
        if (id == this.manager.getLastSetting() && this.containerCargo.getColor()[id] != 5) {
            sourceY -= 28;
            int scaledProgress = this.manager.moveProgressScaled(42);
            int offsetX = 0;
            int offsetY = 0;
            if (this.containerCargo.toCart()[id]) {
                sizeX = 14;
                if (id % 2 == 0) {
                    offsetX = 14;
                }
                if ((sizeY = scaledProgress) > 19) {
                    sizeY = 19;
                }
                if (id < 2) {
                    offsetY = 28 - sizeY;
                }
            } else {
                sizeY = 14;
                if (id >= 2) {
                    offsetY = 14;
                }
                if ((sizeX = scaledProgress) > 19) {
                    sizeX = 19;
                }
                if (id % 2 == 1) {
                    offsetX = 28 - sizeX;
                }
            }
            this.m_93228_(matrixStack, left + targetX + offsetX, top + targetY + offsetY, sourceX + offsetX, sourceY + offsetY, sizeX, sizeY);
            offsetX = 0;
            offsetY = 0;
            sizeX = 28;
            sizeY = 28;
            if (scaledProgress > 19) {
                scaledProgress -= 19;
                if (this.containerCargo.toCart()[id]) {
                    sizeX = scaledProgress;
                    if (sizeX > 23) {
                        sizeX = 23;
                    }
                    offsetX = id % 2 == 0 ? 22 - sizeX : 6;
                } else {
                    sizeY = scaledProgress;
                    if (sizeY > 23) {
                        sizeY = 23;
                    }
                    offsetY = id >= 2 ? 22 - sizeY : 6;
                }
                this.m_93228_(matrixStack, left + targetX + offsetX, top + targetY + offsetY, sourceX + offsetX, sourceY + offsetY, sizeX, sizeY);
            }
        }
    }

    protected int[] getMiddleCoords() {
        return new int[]{this.getCenterTargetX() + 45, 61, 20, 20};
    }

    protected int[] getTextCoords(int id) {
        int[] coords = this.getBoxCoords(id);
        int xCoord = coords[0];
        int yCoord = coords[1];
        yCoord = id >= 2 ? (yCoord -= 12) : (yCoord += 20);
        return new int[]{xCoord, yCoord, 20, 10};
    }

    protected int[] getArrowCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 25 + x * 28;
        int yCoord = 17 + y * 76;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 28, 28};
    }

    public void drawMouseOver(PoseStack matrixStack, String str, int x, int y, int[] rect) {
        if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            this.m_96602_(matrixStack, (Component)Component.m_237113_((String)str), x, y);
        }
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    protected int[] getColorpickerCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 3 + x * 92;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 8, 8};
    }

    protected String getMaxSizeOverlay(int id) {
        int amount = this.getCargo().getAmount(id);
        int type = this.getCargo().getAmountType(id);
        if (type == 0) {
            return Localization.GUI.CARGO.TRANSFER_ALL.translate(new String[0]);
        }
        if (type == 1) {
            return Localization.GUI.CARGO.TRANSFER_ITEMS.translate(String.valueOf(amount), String.valueOf(amount));
        }
        return Localization.GUI.CARGO.TRANSFER_STACKS.translate(String.valueOf(amount), String.valueOf(amount));
    }

    protected String getMaxSizeText(int id) {
        Object s;
        int type = this.getCargo().getAmountType(id);
        if (type == 0) {
            s = Localization.GUI.CARGO.TRANSFER_ALL_SHORT.translate(new String[0]);
        } else {
            int amount = this.getCargo().getAmount(id);
            s = String.valueOf(amount);
            s = type == 1 ? (String)s + " " + Localization.GUI.CARGO.TRANSFER_ITEMS_SHORT.translate(new String[0]) : (String)s + " " + Localization.GUI.CARGO.TRANSFER_STACKS_SHORT.translate(new String[0]);
        }
        return s;
    }

    protected int getArrowSourceX() {
        return 49;
    }

    protected int getColorSourceX() {
        return 105;
    }

    protected int getCenterTargetX() {
        return 98;
    }

    protected void drawItems(int id, ItemRenderer renderitem, int left, int top) {
        ItemStack cartIcon = this.containerCargo.getTarget()[id] < 0 || this.containerCargo.getTarget()[id] >= TileEntityCargo.itemSelections.size() || TileEntityCargo.itemSelections.get(this.containerCargo.getTarget()[id]).getIcon().m_41619_() ? new ItemStack((ItemLike)Items.f_42449_, 1) : TileEntityCargo.itemSelections.get(this.containerCargo.getTarget()[id]).getIcon();
        int[] coords = this.getBoxCoords(id);
        renderitem.m_115123_(cartIcon, left + coords[0], top + coords[1]);
    }

    protected int[] getBoxCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 4 + x * 82;
        int yCoord = 17 + y * 88;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 20, 20};
    }

    protected int offsetObjectY(int layout, int x, int y) {
        if (layout != 0) {
            return -5 + y * 10;
        }
        return 0;
    }

    protected boolean sendOnClick(int id, int x, int y, byte data) {
        if (this.inRect(x, y, this.getBoxCoords(id))) {
            this.manager.sendPacket(1, data);
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        int x = (int)mouseX;
        int y = (int)mouseY;
        if (this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.getMiddleCoords())) {
            this.manager.sendPacket(5, (byte)(button == 0 ? 1 : -1));
        } else {
            for (int i = 0; i < 4; ++i) {
                byte data = (byte)i;
                data = (byte)(data | (byte)(button << 2));
                if (this.inRect(x, y, this.getArrowCoords(i))) {
                    this.manager.sendPacket(0, (byte)i);
                    break;
                }
                if (this.inRect(x, y, this.getTextCoords(i))) {
                    this.manager.sendPacket(2, data);
                    break;
                }
                if (this.inRect(x, y, this.getColorpickerCoords(i))) {
                    this.manager.sendPacket(3, data);
                    break;
                }
                if (this.inRect(x, y, this.getReturnCoords(i))) {
                    this.manager.sendPacket(4, (byte)i);
                    break;
                }
                if (this.sendOnClick(i, x, y, data)) break;
            }
        }
        return true;
    }

    protected void drawExtraOverlay(PoseStack matrixStack, int id, int x, int y) {
        if (this.containerCargo.getTarget()[id] >= 0) {
            int n = this.containerCargo.getTarget()[id];
            this.getCargo();
            if (n < TileEntityCargo.itemSelections.size()) {
                this.getCargo();
                CargoItemSelection item = TileEntityCargo.itemSelections.get(this.containerCargo.getTarget()[id]);
                if (item.getName() != null) {
                    this.drawMouseOver(matrixStack, Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + item.getName(), x, y, this.getBoxCoords(id));
                } else {
                    this.drawMouseOver(matrixStack, Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + Localization.GUI.CARGO.UNKNOWN_AREA.translate(new String[0]), x, y, this.getBoxCoords(id));
                }
                return;
            }
        }
        this.drawMouseOver(matrixStack, Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + Localization.GUI.CARGO.UNKNOWN_AREA.translate(new String[0]), x, y, this.getBoxCoords(id));
    }

    protected Block getBlock() {
        return (Block)ModBlocks.CARGO_MANAGER.get();
    }

    protected String getManagerName() {
        return Localization.GUI.CARGO.TITLE.translate(new String[0]);
    }

    private int[] getInvCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = 8 + x * 198;
        int yCoord = 11 + y * 64;
        return new int[]{xCoord, yCoord};
    }

    private TileEntityCargo getCargo() {
        return this.manager;
    }

    protected String getLayoutString() {
        return Localization.GUI.CARGO.CHANGE_SLOT_LAYOUT.translate(new String[0]);
    }

    protected String getLayoutOption(int id) {
        switch (id) {
            default: {
                return Localization.GUI.CARGO.LAYOUT_SHARED.translate(new String[0]);
            }
            case 1: {
                return Localization.GUI.CARGO.LAYOUT_SIDE.translate(new String[0]);
            }
            case 2: 
        }
        return Localization.GUI.CARGO.LAYOUT_COLOR.translate(new String[0]);
    }
}

