/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerUpgrade;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.upgrades.AssemblerUpgrade;
import vswe.stevescarts.upgrades.InventoryEffect;

public class TileEntityUpgrade
extends TileEntityBase
implements WorldlyContainer,
ITankHolder,
MenuProvider {
    public SCTank tank = new SCTank(this, 0, 0);
    private TileEntityCartAssembler master;
    private int type;
    private boolean initialized;
    private CompoundTag comp;
    private NonNullList<ItemStack> inventoryStacks;
    private int[] slotsForSide;
    private boolean isCreativeBroken;

    public TileEntityUpgrade(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.UPGRADE_TILE.get(), blockPos, blockState);
    }

    public TileEntityUpgrade(AssemblerUpgrade assemblerUpgrade, BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.UPGRADE_TILE.get(), blockPos, blockState);
        this.type = assemblerUpgrade.getId();
        this.setType(assemblerUpgrade.getId());
    }

    public void setMaster(TileEntityCartAssembler master, Direction side) {
        this.master = master;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof BlockUpgrade) {
            if (side != null) {
                this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BlockUpgrade.CONNECTED, (Comparable)Boolean.valueOf(master != null));
            }
            this.m_6596_();
        }
    }

    public Direction getSide() {
        if (this.f_58857_ == null) {
            return Direction.NORTH;
        }
        return (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockUpgrade.FACING);
    }

    public TileEntityCartAssembler getMaster() {
        return this.master;
    }

    public void setType(int type) {
        this.type = type;
        if (!this.initialized) {
            this.initialized = true;
            AssemblerUpgrade upgrade = this.getUpgrade();
            if (upgrade != null) {
                this.comp = new CompoundTag();
                this.slotsForSide = new int[upgrade.getInventorySize()];
                upgrade.init(this);
                if (upgrade.getInventorySize() > 0) {
                    this.inventoryStacks = NonNullList.m_122780_((int)upgrade.getInventorySize(), (Object)ItemStack.f_41583_);
                    for (int i = 0; i < this.slotsForSide.length; ++i) {
                        this.slotsForSide[i] = i;
                    }
                }
            } else {
                this.inventoryStacks = null;
            }
        }
    }

    public CompoundTag getCompound() {
        return this.comp;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public AssemblerUpgrade getUpgrade() {
        return AssemblerUpgrade.getUpgrade(this.type);
    }

    public boolean hasInventory() {
        return this.inventoryStacks != null;
    }

    public void m_142466_(@NotNull CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.setType(compoundNBT.m_128445_("Type"));
        ContainerHelper.m_18980_((CompoundTag)compoundNBT, this.inventoryStacks);
        this.m_6596_();
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.load(this, compoundNBT);
        }
    }

    public void m_183515_(@NotNull CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        if (this.inventoryStacks != null) {
            ContainerHelper.m_18973_((CompoundTag)compoundNBT, this.inventoryStacks);
        }
        compoundNBT.m_128344_("Type", (byte)this.type);
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.save(this, compoundNBT);
        }
    }

    @Override
    public void tick() {
        if (this.getUpgrade() != null && this.getMaster() != null) {
            this.getUpgrade().update(this);
        }
    }

    public int m_6643_() {
        if (this.inventoryStacks != null) {
            return this.inventoryStacks.size();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.m_6643_();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventoryStacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return ItemStack.f_41583_;
            }
            return this.master.m_8020_(i);
        }
        if (i < 0 || i >= this.m_6643_()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.inventoryStacks.get(i);
    }

    @NotNull
    public ItemStack m_7407_(int id, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.inventoryStacks, (int)id, (int)amount);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int id) {
        ItemStack itemStack = (ItemStack)this.inventoryStacks.get(id);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.inventoryStacks.set(id, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int i, @NotNull ItemStack itemstack) {
        if (this.inventoryStacks == null) {
            if (this.master != null) {
                this.master.m_6836_(i, itemstack);
            }
        } else {
            if (i < 0 || i >= this.m_6643_()) {
                return;
            }
            this.inventoryStacks.set(i, (Object)itemstack);
            if (!itemstack.m_41619_() && itemstack.m_41613_() > this.m_6893_()) {
                itemstack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        }
    }

    public void m_6596_() {
        InventoryEffect inv;
        super.m_6596_();
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            inv.onInventoryChanged(this);
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    @Override
    @NotNull
    public ItemStack getInputContainer(int tankid) {
        return this.m_8020_(0);
    }

    @Override
    public void setInputContainer(int tankid, ItemStack stack) {
        this.m_6836_(0, stack);
    }

    @Override
    public void addToOutputContainer(int tankid, @NotNull ItemStack item) {
        TransferHandler.TransferItem(item, (Container)this, 1, 1, new ContainerUpgrade(0, null, this, new SimpleContainerData(0)), Slot.class, null, -1);
    }

    @Override
    public void onFluidUpdated(int tankid) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(int tankid, AbstractContainerScreen<?> gui, TextureAtlasSprite sprite, int targetX, int targetY, int width, int height) {
        GuiComponent.m_93200_((PoseStack)new PoseStack(), (int)(gui.getGuiLeft() + targetX), (int)(gui.getGuiTop() + targetY), (int)0, (int)width, (int)height, (TextureAtlasSprite)sprite);
    }

    public void setCreativeBroken() {
        this.isCreativeBroken = true;
    }

    public boolean isCreativeBroken() {
        return this.isCreativeBroken;
    }

    public int @NotNull [] m_7071_(@NotNull Direction direction) {
        return new int[0];
    }

    public boolean m_7155_(int id, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int p_180461_1_, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return false;
    }

    public void m_6211_() {
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.getUpgrade().getName());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ContainerUpgrade(id, playerInventory, this, new SimpleContainerData(0));
    }
}

