/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketCargpManager;
import vswe.stevescarts.polylib.NBTHelper;

public abstract class TileEntityManager
extends TileEntityBase
implements Container {
    private final TransferManager standardTransferHandler;
    private NonNullList<ItemStack> cargoItemStacks;
    public int layoutType;
    public int moveTime = 0;
    public boolean[] toCart = new boolean[]{true, true, true, true};
    public boolean[] doReturn = new boolean[]{false, false, false, false};
    public int[] amount = new int[]{0, 0, 0, 0};
    public int[] color = new int[]{1, 2, 3, 4};

    public TileEntityManager(BlockEntityType<?> p_i48289_1_, BlockPos blockPos, BlockState blockState) {
        super(p_i48289_1_, blockPos, blockState);
        this.cargoItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.standardTransferHandler = new TransferManager();
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        return (ItemStack)this.cargoItemStacks.get(i);
    }

    public void m_6836_(int i, @NotNull ItemStack itemstack) {
        this.cargoItemStacks.set(i, (Object)itemstack);
        if (!itemstack.m_41619_() && itemstack.m_41613_() > this.m_6893_()) {
            itemstack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6211_() {
        this.cargoItemStacks.clear();
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        ListTag nbttaglist = compoundTag.m_128437_("Items", NBTHelper.COMPOUND.getId());
        this.cargoItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag nbttagcompound2 = nbttaglist.m_128728_(i);
            byte byte0 = nbttagcompound2.m_128445_("Slot");
            if (byte0 < 0 || byte0 >= this.cargoItemStacks.size()) continue;
            this.cargoItemStacks.set((int)byte0, (Object)ItemStack.m_41712_((CompoundTag)nbttagcompound2));
        }
        this.moveTime = compoundTag.m_128445_("movetime");
        this.setLowestSetting(compoundTag.m_128445_("lowestNumber"));
        this.layoutType = compoundTag.m_128445_("layout");
        byte temp = compoundTag.m_128445_("tocart");
        byte temp2 = compoundTag.m_128445_("doReturn");
        for (int j = 0; j < 4; ++j) {
            this.amount[j] = compoundTag.m_128445_("amount" + j);
            this.color[j] = compoundTag.m_128445_("color" + j);
            if (this.color[j] == 0) {
                this.color[j] = j + 1;
            }
            this.toCart[j] = (temp & 1 << j) != 0;
            this.doReturn[j] = (temp2 & 1 << j) != 0;
        }
    }

    public void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128344_("movetime", (byte)this.moveTime);
        compoundTag.m_128344_("lowestNumber", (byte)this.getLowestSetting());
        compoundTag.m_128344_("layout", (byte)this.layoutType);
        byte temp = 0;
        byte temp2 = 0;
        for (int i = 0; i < 4; ++i) {
            compoundTag.m_128344_("amount" + i, (byte)this.amount[i]);
            compoundTag.m_128344_("color" + i, (byte)this.color[i]);
            if (this.toCart[i]) {
                temp = (byte)(temp | (byte)(1 << i));
            }
            if (!this.doReturn[i]) continue;
            temp2 = (byte)(temp2 | (byte)(1 << i));
        }
        compoundTag.m_128344_("tocart", temp);
        compoundTag.m_128344_("doReturn", temp2);
        ListTag nbttaglist = new ListTag();
        for (int j = 0; j < this.cargoItemStacks.size(); ++j) {
            if (((ItemStack)this.cargoItemStacks.get(j)).m_41619_()) continue;
            CompoundTag nbttagcompound2 = new CompoundTag();
            nbttagcompound2.m_128344_("Slot", (byte)j);
            ((ItemStack)this.cargoItemStacks.get(j)).m_41739_(nbttagcompound2);
            nbttaglist.add((Object)nbttagcompound2);
        }
        compoundTag.m_128365_("Items", (Tag)nbttaglist);
    }

    public EntityMinecartModular getCart() {
        return this.standardTransferHandler.getCart();
    }

    public void setCart(EntityMinecartModular cart) {
        this.standardTransferHandler.setCart(cart);
    }

    public int getSetting() {
        return this.standardTransferHandler.getSetting();
    }

    public void setSetting(int val) {
        this.standardTransferHandler.setSetting(val);
    }

    public int getSide() {
        return this.standardTransferHandler.getSide();
    }

    public void setSide(int val) {
        this.standardTransferHandler.setSide(val);
    }

    public int getLastSetting() {
        return this.standardTransferHandler.getLastSetting();
    }

    public void setLastSetting(int val) {
        this.standardTransferHandler.setLastSetting(val);
    }

    public int getLowestSetting() {
        return this.standardTransferHandler.getLowestSetting();
    }

    public void setLowestSetting(int val) {
        this.standardTransferHandler.setLowestSetting(val);
    }

    public int getWorkload() {
        return this.standardTransferHandler.getWorkload();
    }

    public void setWorkload(int val) {
        this.standardTransferHandler.setWorkload(val);
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.updateLayout();
            return;
        }
        if (this.getCart() == null || this.getCart().m_213877_() || this.getSide() < 0 || this.getSide() > 3 || !this.getCart().isDisabled()) {
            this.standardTransferHandler.reset();
            return;
        }
        ++this.moveTime;
        if (this.moveTime >= 24 || this.getSetting() == -1 && this.color[0] - 1 != this.getSide()) {
            this.moveTime = 0;
            if (!this.exchangeItems(this.standardTransferHandler)) {
                this.getCart().releaseCart();
                if (this.doReturn[this.getSide()]) {
                    this.getCart().turnback();
                }
                this.standardTransferHandler.reset();
            }
        }
    }

    public boolean exchangeItems(TransferManager transfer) {
        transfer.setSetting(transfer.getLowestSetting());
        while (transfer.getSetting() < 4) {
            if (this.color[transfer.getSetting()] - 1 == transfer.getSide()) {
                transfer.setLowestSetting(transfer.getSetting());
                if (transfer.getLastSetting() != transfer.getSetting()) {
                    transfer.setWorkload(0);
                    transfer.setLastSetting(transfer.getSetting());
                    return true;
                }
                if (!(this.toCart[transfer.getSetting()] ? transfer.getToCartEnabled() : transfer.getFromCartEnabled()) || !this.isTargetValid(transfer)) {
                    transfer.setLowestSetting(transfer.getSetting() + 1);
                    return true;
                }
                if (this.doTransfer(transfer)) {
                    return true;
                }
            }
            transfer.setSetting(transfer.getSetting() + 1);
        }
        return false;
    }

    public void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    public void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketHandler.sendToServer(new PacketCargpManager(this.m_58899_(), id, data));
    }

    public void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            byte railID = data[0];
            boolean bl = this.toCart[railID] = !this.toCart[railID];
            if (this.color[railID] - 1 == this.getSide()) {
                this.reset();
            }
        } else if (id == 4) {
            byte railID = data[0];
            if (this.color[railID] != 5) {
                this.doReturn[this.color[railID] - 1] = !this.doReturn[this.color[railID] - 1];
            }
        } else if (id == 5) {
            byte difference = data[0];
            this.layoutType += difference;
            if (this.layoutType > 2) {
                this.layoutType = 0;
            } else if (this.layoutType < 0) {
                this.layoutType = 2;
            }
            this.reset();
        } else {
            byte railsAndDifferenceCombined = data[0];
            int railID2 = railsAndDifferenceCombined & 3;
            int k = (railsAndDifferenceCombined & 4) >> 2;
            int difference2 = k == 0 ? 1 : -1;
            if (id == 2) {
                int n;
                int[] amount = this.amount;
                int n2 = n = railID2;
                amount[n2] = amount[n2] + difference2;
                if (this.amount[railID2] >= this.getAmountCount()) {
                    this.amount[railID2] = 0;
                } else if (this.amount[railID2] < 0) {
                    this.amount[railID2] = this.getAmountCount() - 1;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else if (id == 3) {
                int n2;
                if (this.color[railID2] != 5) {
                    boolean willStillExist = false;
                    for (int side = 0; side < 4; ++side) {
                        if (side == railID2 || this.color[railID2] != this.color[side]) continue;
                        willStillExist = true;
                        break;
                    }
                    if (!willStillExist) {
                        this.doReturn[this.color[railID2] - 1] = false;
                    }
                }
                int[] color = this.color;
                int n = n2 = railID2;
                color[n] = color[n] + difference2;
                if (this.color[railID2] > 5) {
                    this.color[railID2] = 1;
                } else if (this.color[railID2] < 1) {
                    this.color[railID2] = 5;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else {
                this.receiveClickData(id, railID2, difference2);
            }
        }
    }

    public int moveProgressScaled(int i) {
        return this.moveTime * i / 24;
    }

    @Nonnull
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (!((ItemStack)this.cargoItemStacks.get(par1)).m_41619_()) {
            ItemStack var2 = (ItemStack)this.cargoItemStacks.get(par1);
            this.cargoItemStacks.set(par1, (Object)ItemStack.f_41583_);
            return var2;
        }
        return ItemStack.f_41583_;
    }

    protected void updateLayout() {
    }

    protected void receiveClickData(int packetid, int id, int dif) {
    }

    protected abstract boolean isTargetValid(TransferManager var1);

    protected abstract boolean doTransfer(TransferManager var1);

    public abstract int getAmountCount();

    protected void reset() {
        this.moveTime = 0;
        this.setWorkload(0);
    }

    protected int getAmountId(int id) {
        return this.amount[id];
    }

    public int m_6643_() {
        return this.cargoItemStacks.size();
    }

    @NotNull
    public ItemStack m_7407_(int id, int amount) {
        return ContainerHelper.m_18969_(this.cargoItemStacks, (int)id, (int)amount);
    }

    @NotNull
    public ItemStack m_8016_(int id) {
        return ItemStack.f_41583_;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.cargoItemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }
}

