/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.Disassemble;
import vswe.stevescarts.upgrades.Transposer;

public class BlockRailAdvDetector
extends BaseRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;

    public BlockRailAdvDetector() {
        this(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.7f).m_60918_(SoundType.f_56743_));
    }

    private BlockRailAdvDetector(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, f_152149_});
    }

    @NotNull
    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void onMinecartPass(BlockState state, Level world, BlockPos pos, AbstractMinecart entityMinecart) {
        if (world.f_46443_ || !(entityMinecart instanceof EntityMinecartModular)) {
            return;
        }
        EntityMinecartModular cart = (EntityMinecartModular)entityMinecart;
        if (!this.isCartReadyForAction(cart, pos)) {
            return;
        }
        int side = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                TileEntityUpgrade upgrade;
                BlockEntity tileentity;
                if (Math.abs(i) == Math.abs(j)) continue;
                BlockPos offset = pos.m_7918_(i, 0, j);
                Block block = world.m_8055_(offset).m_60734_();
                if (block == ModBlocks.CARGO_MANAGER.get() || block == ModBlocks.LIQUID_MANAGER.get()) {
                    TileEntityManager manager;
                    tileentity = world.m_7702_(offset);
                    if (tileentity instanceof TileEntityManager && (manager = (TileEntityManager)tileentity).getCart() == null) {
                        manager.setCart(cart);
                        manager.setSide(side);
                    }
                    return;
                }
                if (block == ModBlocks.MODULE_TOGGLER.get()) {
                    tileentity = world.m_7702_(offset);
                    if (tileentity instanceof TileEntityActivator) {
                        TileEntityActivator activator = (TileEntityActivator)tileentity;
                        boolean isOrange = false;
                        if (cart.temppushX == 0.0 == (cart.temppushZ == 0.0)) continue;
                        if (i == 0) {
                            isOrange = j == -1 ? cart.temppushX < 0.0 : cart.temppushX > 0.0;
                        } else if (j == 0) {
                            isOrange = i == -1 ? cart.temppushZ > 0.0 : cart.temppushZ < 0.0;
                        }
                        boolean isBlueBerry = false;
                        activator.handleCart(cart, isOrange);
                        cart.releaseCart();
                    }
                    return;
                }
                if (block instanceof BlockUpgrade && (upgrade = (TileEntityUpgrade)(tileentity = world.m_7702_(offset))) != null && upgrade.getUpgrade() != null) {
                    for (BaseEffect effect : upgrade.getUpgrade().getEffects()) {
                        if (!(effect instanceof Transposer)) continue;
                        Transposer transposer = (Transposer)effect;
                        if (upgrade.getMaster() == null) continue;
                        for (TileEntityUpgrade tile : upgrade.getMaster().getUpgradeTiles()) {
                            if (tile.getUpgrade() == null) continue;
                            for (BaseEffect effect2 : tile.getUpgrade().getEffects()) {
                                if (!(effect2 instanceof Disassemble)) continue;
                                Disassemble disassembler = (Disassemble)effect2;
                                if (!tile.m_8020_(0).m_41619_()) continue;
                                tile.m_6836_(0, ModuleData.createModularCart(cart));
                                for (int p = 0; p < cart.m_6643_(); ++p) {
                                    ItemStack item = cart.m_7407_(p, 64);
                                    if (item.m_41619_()) continue;
                                    upgrade.getMaster().puke(item);
                                }
                                cart.m_142687_(Entity.RemovalReason.DISCARDED);
                                return;
                            }
                        }
                    }
                }
                ++side;
            }
        }
    }

    private boolean isCartReadyForAction(EntityMinecartModular cart, BlockPos pos) {
        return cart.disabledPos != null && cart.disabledPos.equals((Object)pos) && cart.isDisabled();
    }
}

