/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.polylib.Pair;

public class BlockCartAssembler
extends BlockContainerBase {
    public BlockCartAssembler() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(2.0f));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, Level world, @NotNull BlockPos blockPos, @NotNull Player playerEntity, @NotNull InteractionHand hand, @NotNull BlockHitResult rayTraceResult) {
        if (!world.f_46443_ && !playerEntity.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)((MenuProvider)world.m_7702_(blockPos)), (BlockPos)blockPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void updateMultiBlock(Level world, BlockPos pos) {
        BlockEntity master = world.m_7702_(pos);
        if (master instanceof TileEntityCartAssembler) {
            ((TileEntityCartAssembler)master).clearUpgrades();
        }
        this.checkForUpgrades(world, pos);
        if (master instanceof TileEntityCartAssembler) {
            ((TileEntityCartAssembler)master).onUpgradeUpdate();
        }
    }

    private void checkForUpgrades(Level world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            this.checkForUpgrade(world, pos.m_121945_(facing));
        }
    }

    private TileEntityCartAssembler checkForUpgrade(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            ArrayList<Pair<TileEntityCartAssembler, Direction>> masters = this.getMasters(world, pos);
            if (masters.size() == 1) {
                Pair<TileEntityCartAssembler, Direction> pair = masters.get(0);
                TileEntityCartAssembler master = pair.first();
                master.addUpgrade(upgrade);
                upgrade.setMaster(master, pair.second().m_122424_());
                return master;
            }
            world.m_151543_(pos);
            for (Pair<TileEntityCartAssembler, Direction> master2 : masters) {
                master2.first().removeUpgrade(upgrade);
            }
            upgrade.setMaster(null, null);
        }
        return null;
    }

    private ArrayList<Pair<TileEntityCartAssembler, Direction>> getMasters(Level world, BlockPos pos) {
        ArrayList<Pair<TileEntityCartAssembler, Direction>> masters = new ArrayList<Pair<TileEntityCartAssembler, Direction>>();
        for (Direction facing : Direction.values()) {
            TileEntityCartAssembler temp = this.getMaster(world, pos.m_121945_(facing));
            if (temp == null) continue;
            masters.add(Pair.of(temp, facing));
        }
        return masters;
    }

    private TileEntityCartAssembler getValidMaster(Level world, BlockPos pos) {
        TileEntityCartAssembler master = null;
        for (Direction facing : Direction.values()) {
            TileEntityCartAssembler temp = this.getMaster(world, pos.m_121945_(facing));
            if (temp == null) continue;
            if (master != null) {
                return null;
            }
            master = temp;
        }
        return master;
    }

    private TileEntityCartAssembler getMaster(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && tile instanceof TileEntityCartAssembler) {
            TileEntityCartAssembler master = (TileEntityCartAssembler)tile;
            if (!master.isDead) {
                return master;
            }
        }
        return null;
    }

    public void addUpgrade(Level world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, master.m_58899_());
        }
    }

    public void removeUpgrade(Level world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, master.m_58899_());
        }
    }

    public void m_6861_(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos blockPos, @NotNull Block block, @NotNull BlockPos blockPos1, boolean p_220069_6_) {
        super.m_6861_(blockState, world, blockPos, block, blockPos, p_220069_6_);
        this.updateMultiBlock(world, blockPos);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityCartAssembler(blockPos, blockState);
    }
}

