/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tracks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import vswe.stevescarts.arcade.tracks.ArcadeTracks;
import vswe.stevescarts.arcade.tracks.Cart;
import vswe.stevescarts.arcade.tracks.TrackOrientation;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.modules.realtimers.ModuleArcade;

public class Track {
    private final int x;
    private final int y;
    private int v;
    private GuiMinecart.RENDER_ROTATION rotation;
    private TrackOrientation orientation;
    private TrackOrientation orientationBackup;

    public Track(int x, int y, TrackOrientation orientation) {
        this.x = x;
        this.y = y;
        this.setOrientation(orientation);
    }

    private void setV(int v) {
        this.v = v;
    }

    private void setRotation(GuiMinecart.RENDER_ROTATION rotation) {
        this.rotation = rotation;
    }

    public void setOrientation(TrackOrientation orientation) {
        this.orientation = orientation;
        this.setV(orientation.getV());
        this.setRotation(orientation.getRotation());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getU() {
        return 0;
    }

    public int getV() {
        return this.v;
    }

    public GuiMinecart.RENDER_ROTATION getRotation() {
        return this.rotation;
    }

    public TrackOrientation getOrientation() {
        return this.orientation;
    }

    public void onClick(ArcadeTracks game) {
        this.flip();
    }

    public void onEditorClick(ArcadeTracks game) {
        if (this.orientation.getOpposite() != null && game.getEditorDetectorTrack() != null) {
            game.getEditorDetectorTrack().addTarget(this.getX(), this.getY());
        }
    }

    public void flip() {
        if (this.orientation.getOpposite() != null) {
            this.setOrientation(this.orientation.getOpposite());
        }
    }

    public void saveBackup() {
        this.orientationBackup = this.orientation;
    }

    public void loadBackup() {
        this.setOrientation(this.orientationBackup);
    }

    public Track copy() {
        return new Track(this.x, this.y, this.orientation);
    }

    public void travel(ArcadeTracks game, Cart cart) {
    }

    public void drawOverlay(PoseStack matrixStack, ModuleArcade module, GuiMinecart gui, int x, int y, boolean isRunning) {
    }

    public static void addTrack(ArrayList<Track> tracks, int x1, int y1, int x2, int y2) {
        if (x1 != x2 && y1 != y2) {
            TrackOrientation corner = Track.getCorner(x1 >= x2, y1 < y2);
            int x2h = x2;
            x2h = x1 < x2h ? --x2h : ++x2h;
            int y1v = y1;
            y1v = y1 < y2 ? ++y1v : --y1v;
            Track.addHorizontalTrack(tracks, x1, x2h, y1);
            tracks.add(new Track(x2, y1, corner));
            Track.addVerticalTrack(tracks, x2, y1v, y2);
        } else if (x1 != x2) {
            Track.addHorizontalTrack(tracks, x1, x2, y1);
        } else {
            Track.addVerticalTrack(tracks, x1, y1, y2);
        }
    }

    private static TrackOrientation getCorner(boolean right, boolean down) {
        if (right) {
            if (down) {
                return TrackOrientation.CORNER_DOWN_RIGHT;
            }
            return TrackOrientation.CORNER_UP_RIGHT;
        }
        if (down) {
            return TrackOrientation.CORNER_DOWN_LEFT;
        }
        return TrackOrientation.CORNER_UP_LEFT;
    }

    private static void addHorizontalTrack(ArrayList<Track> tracks, int x1, int x2, int y) {
        if (x1 > x2) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        for (int x3 = x1; x3 <= x2; ++x3) {
            tracks.add(new Track(x3, y, TrackOrientation.STRAIGHT_HORIZONTAL));
        }
    }

    private static void addVerticalTrack(ArrayList<Track> tracks, int x, int y1, int y2) {
        if (y1 > y2) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        for (int y3 = y1; y3 <= y2; ++y3) {
            tracks.add(new Track(x, y3, TrackOrientation.STRAIGHT_VERTICAL));
        }
    }

    public void setExtraInfo(byte[] data) {
    }

    public byte[] getExtraInfo() {
        return new byte[0];
    }
}

