/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tetris;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.tetris.ArcadeTetris;
import vswe.stevescarts.arcade.tetris.TetrisBlock;
import vswe.stevescarts.arcade.tetris.TetrisPiecePart;
import vswe.stevescarts.client.guis.GuiMinecart;

public class TetrisPiece {
    private TetrisPiecePart[] parts;
    private int x;
    private int y;
    private SoundEvent sound;
    private float volume;
    private int rotationOffset;

    private TetrisPiece(TetrisPiecePart[] parts) {
        this.parts = parts;
        this.x = 5;
        this.y = -2;
    }

    public static TetrisPiece createPiece(int type) {
        SoundEvent sound = null;
        float volume = 0.5f;
        int rotationOffset = 0;
        TetrisPiecePart[] parts = null;
        switch (type) {
            case 0: {
                parts = TetrisPiece.createEndermanParts();
                sound = SoundEvents.f_11849_;
                break;
            }
            case 1: {
                parts = TetrisPiece.createSlimeParts();
                sound = SoundEvents.f_12387_;
                rotationOffset = 1;
                break;
            }
            case 2: {
                parts = TetrisPiece.createWitherParts();
                sound = SoundEvents.f_12557_;
                volume = 0.25f;
                break;
            }
            case 3: {
                parts = TetrisPiece.createWitchParts();
                sound = SoundEvents.f_11791_;
                break;
            }
            case 4: {
                parts = TetrisPiece.createPigParts();
                sound = SoundEvents.f_12233_;
                break;
            }
            case 5: {
                parts = TetrisPiece.createSteveParts();
                sound = SoundEvents.f_12323_;
                break;
            }
            case 6: {
                parts = TetrisPiece.createSheepParts();
                sound = SoundEvents.f_12341_;
                break;
            }
            default: {
                return null;
            }
        }
        TetrisPiece piece = new TetrisPiece(parts);
        piece.sound = sound;
        piece.rotationOffset = rotationOffset;
        piece.volume = volume;
        return piece;
    }

    private static TetrisPiecePart[] createEndermanParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(0, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(0, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(0, 20), 0, 1), new TetrisPiecePart(new TetrisBlock(0, 30), 0, 2)};
        return parts;
    }

    private static TetrisPiecePart[] createSlimeParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(10, 0), 0, 0), new TetrisPiecePart(new TetrisBlock(20, 0), 1, 0), new TetrisPiecePart(new TetrisBlock(10, 10), 0, 1), new TetrisPiecePart(new TetrisBlock(20, 10), 1, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createWitherParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(30, 0), -1, 0), new TetrisPiecePart(new TetrisBlock(40, 0), 0, 0), new TetrisPiecePart(new TetrisBlock(50, 0), 1, 0), new TetrisPiecePart(new TetrisBlock(40, 10), 0, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createWitchParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(70, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(70, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(70, 20), 0, 1), new TetrisPiecePart(new TetrisBlock(60, 20), -1, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createPigParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(80, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(80, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(80, 20), 0, 1), new TetrisPiecePart(new TetrisBlock(90, 20), 1, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createSteveParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(100, 0), -1, -1), new TetrisPiecePart(new TetrisBlock(110, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(110, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(120, 10), 1, 0)};
        return parts;
    }

    private static TetrisPiecePart[] createSheepParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(130, 10), -1, 1), new TetrisPiecePart(new TetrisBlock(140, 10), 0, 1), new TetrisPiecePart(new TetrisBlock(140, 0), 0, 0), new TetrisPiecePart(new TetrisBlock(150, 0), 1, 0)};
        return parts;
    }

    public void render(PoseStack matrixStack, ArcadeTetris game, GuiMinecart gui) {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].render(matrixStack, game, gui, this.x, this.y);
        }
    }

    public void rotate(TetrisBlock[][] board) {
        int i;
        for (i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].canRotate(board, this.x, this.y, this.rotationOffset)) continue;
            return;
        }
        for (i = 0; i < this.parts.length; ++i) {
            this.parts[i].rotate(this.rotationOffset);
        }
    }

    public MOVE_RESULT move(ArcadeTetris game, TetrisBlock[][] board, int offX, int offY, boolean placeOnFail) {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].canMoveTo(board, this.x + offX, this.y + offY)) continue;
            boolean isGameOver = false;
            if (placeOnFail) {
                for (int j = 0; j < this.parts.length; ++j) {
                    if (this.parts[j].canPlaceInBoard(this.y)) {
                        this.parts[j].placeInBoard(board, this.x, this.y);
                        continue;
                    }
                    isGameOver = true;
                }
                if (((Boolean)SCConfig.useArcadeMobSounds.get()).booleanValue() && this.sound != null) {
                    ArcadeGame.playSound(this.sound, this.volume, (game.getModule().getCart().f_19796_.m_188501_() - game.getModule().getCart().f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
            }
            return isGameOver ? MOVE_RESULT.GAME_OVER : MOVE_RESULT.FAIL;
        }
        this.x += offX;
        this.y += offY;
        return MOVE_RESULT.SUCCESS;
    }

    public static enum MOVE_RESULT {
        SUCCESS,
        FAIL,
        GAME_OVER;

    }
}

