/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.forge;

import java.util.Optional;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import me.codexadrian.spirit.Corrupted;
import me.codexadrian.spirit.SpiritConfig;
import me.codexadrian.spirit.blocks.blockentity.PedestalBlockEntity;
import me.codexadrian.spirit.blocks.blockentity.SoulCageBlockEntity;
import me.codexadrian.spirit.blocks.blockentity.SoulPedestalBlockEntity;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPCompat
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("spirit", "spirit_probe");
            }

            public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData probeHitData) {
                PedestalBlockEntity blockEntity;
                BlockEntity item;
                BlockEntity blockEntity2;
                IProgressStyle soulStyle = probeInfo.defaultProgressStyle().filledColor(-8731453).alternateFilledColor(-8731453).suffix("spirit.the_one_probe.soul_cage.bar_suffix");
                if (blockState.m_60713_(SpiritBlocks.SOUL_CAGE.get()) && (blockEntity2 = level.m_7702_(probeHitData.getPos())) instanceof SoulCageBlockEntity) {
                    SoulCageBlockEntity blockEntity3 = (SoulCageBlockEntity)blockEntity2;
                    if (blockEntity3.m_7983_()) {
                        probeInfo.horizontal().text("block.spirit.soul_cage.empty_hover_text");
                    } else if (blockEntity3.type != null) {
                        probeInfo.horizontal().padding(2, 1).entity(blockEntity3.getOrCreateEntity()).padding(2, 1).vertical().padding(5, 8).horizontal().text(blockEntity3.type.m_20676_()).text("spirit.the_one_probe.soul_cage.tier_suffix").text(SoulUtils.getTierDisplay(blockEntity3.m_8020_(0), level));
                    }
                } else if (blockState.m_60713_(SpiritBlocks.SOUL_PEDESTAL.get()) && (blockEntity2 = level.m_7702_(probeHitData.getPos())) instanceof SoulPedestalBlockEntity) {
                    SoulPedestalBlockEntity blockEntity4 = (SoulPedestalBlockEntity)blockEntity2;
                    if (blockEntity4.type != null) {
                        probeInfo.horizontal().padding(2, 1).entity(blockEntity4.getOrCreateEntity()).padding(2, 1).vertical().padding(5, 8).horizontal().text(blockEntity4.type.m_20676_());
                    }
                } else if (blockState.m_60713_(SpiritBlocks.CRYSTAL_PEDESTAL.get()) && (blockEntity2 = level.m_7702_(probeHitData.getPos())) instanceof PedestalBlockEntity) {
                    PedestalBlockEntity blockEntity5 = (PedestalBlockEntity)blockEntity2;
                    if (!blockEntity5.m_7983_()) {
                        item = blockEntity5.m_8020_(0);
                        if (item.m_150930_(SpiritItems.SOUL_CRYSTAL.get())) {
                            String entityName = SoulUtils.getSoulCrystalType((ItemStack)item);
                            if (entityName != null) {
                                Optional entityType = EntityType.m_20632_((String)entityName);
                                if (entityType.isPresent()) {
                                    probeInfo.horizontal().item((ItemStack)item).vertical().itemLabel((ItemStack)item).horizontal().text(((EntityType)entityType.get()).m_20676_()).text("").text(SoulUtils.getTierDisplay(blockEntity5.m_8020_(0), level));
                                } else {
                                    probeInfo.horizontal().item((ItemStack)item).vertical().padding(5, 4).itemLabel((ItemStack)item);
                                }
                            } else {
                                probeInfo.horizontal().item((ItemStack)item).vertical().padding(5, 4).itemLabel((ItemStack)item);
                            }
                            probeInfo.progress(SoulUtils.getSoulsInCrystal((ItemStack)item), SoulUtils.getMaxSouls((ItemStack)item, level), soulStyle);
                        } else if (item.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get())) {
                            probeInfo.horizontal().item((ItemStack)item).vertical().padding(5, 4).itemLabel((ItemStack)item);
                            probeInfo.progress(SoulUtils.getSoulsInCrystal((ItemStack)item), SpiritConfig.getCrudeSoulCrystalCap(), soulStyle);
                        }
                    }
                } else if (blockState.m_60713_(SpiritBlocks.PEDESTAL.get()) && (item = level.m_7702_(probeHitData.getPos())) instanceof PedestalBlockEntity && !(blockEntity = (PedestalBlockEntity)item).m_7983_()) {
                    item = blockEntity.m_8020_(0);
                    probeInfo.horizontal().item((ItemStack)item).vertical().padding(5, 4).itemLabel((ItemStack)item);
                }
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "spirit:corrupted_info";
            }

            public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, Entity entity, IProbeHitEntityData iProbeHitEntityData) {
                Corrupted corrupted;
                if (entity instanceof Corrupted && (corrupted = (Corrupted)entity).isCorrupted()) {
                    probeInfo.text("effect.spirit.corrupted");
                }
            }
        });
        return null;
    }
}

