/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;

public class ShulkerBoxItem
extends StorageBlockItem
implements IStashStorageItem {
    public ShulkerBoxItem(Block block) {
        this(block, new Item.Properties().m_41487_(1));
    }

    public ShulkerBoxItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new ShulkerBoxItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (flagIn == TooltipFlag.Default.ADVANCED) {
            stack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).ifPresent(w -> w.getContentsUuid().ifPresent(uuid -> tooltip.add((Component)Component.m_237113_((String)("UUID: " + uuid)).m_130940_(ChatFormatting.DARK_GRAY))));
        }
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.m_237115_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        AtomicReference<Object> ret = new AtomicReference<Object>(null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (Screen.m_96638_() || mc.f_91074_ != null && !mc.f_91074_.f_36096_.m_142621_().m_41619_()) {
                ret.set(new StorageContentsTooltip(stack));
            }
        });
        return Optional.ofNullable(ret.get());
    }

    public boolean m_142095_() {
        return false;
    }

    public void m_142023_(ItemEntity itemEntity) {
        Level level = itemEntity.f_19853_;
        if (level.f_46443_) {
            return;
        }
        ItemStack itemstack = itemEntity.m_32055_();
        itemstack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).ifPresent(storageWrapper -> {
            InventoryHelper.dropItems((ItemStackHandler)storageWrapper.getInventoryHandler(), (Level)level, (double)itemEntity.m_20185_(), (double)itemEntity.m_20186_(), (double)itemEntity.m_20189_());
            InventoryHelper.dropItems((ItemStackHandler)storageWrapper.getUpgradeHandler(), (Level)level, (double)itemEntity.m_20185_(), (double)itemEntity.m_20186_(), (double)itemEntity.m_20189_());
        });
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private IStorageWrapper wrapper = null;

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                if (stack.m_41613_() == 1 && cap == CapabilityStorageWrapper.getCapabilityInstance()) {
                    this.initWrapper();
                    return LazyOptional.of(() -> this.wrapper).cast();
                }
                return LazyOptional.empty();
            }

            private void initWrapper() {
                if (this.wrapper == null) {
                    UUID uuid = ShulkerBoxItem.this.getContentsUuid(stack).orElse(null);
                    StackStorageWrapper storageWrapper = new StackStorageWrapper(stack){

                        @Override
                        protected boolean isAllowedInStorage(ItemStack stack) {
                            Block block = Block.m_49814_((Item)stack.m_41720_());
                            return !(block instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) && !(block instanceof ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.m_41720_());
                        }
                    };
                    if (uuid != null) {
                        CompoundTag compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).m_128469_("storageWrapper");
                        storageWrapper.load(compoundtag);
                        ((StorageWrapper)storageWrapper).setContentsUuid(uuid);
                    }
                    this.wrapper = storageWrapper;
                }
            }
        };
    }

    private Optional<UUID> getContentsUuid(ItemStack stack) {
        return NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid");
    }

    public Optional<TooltipComponent> getInventoryTooltip(ItemStack stack) {
        return Optional.of(new StorageContentsTooltip(stack));
    }

    public ItemStack stash(ItemStack storageStack, ItemStack stack) {
        return storageStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(wrapper -> {
            if (wrapper.getContentsUuid().isEmpty()) {
                wrapper.setContentsUuid(UUID.randomUUID());
            }
            return wrapper.getInventoryForUpgradeProcessing().insertItem(stack, false);
        }).orElse(stack);
    }

    public IStashStorageItem.StashResult getItemStashable(ItemStack storageStack, ItemStack stack) {
        return storageStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(wrapper -> {
            if (wrapper.getInventoryForUpgradeProcessing().insertItem(stack, true).m_41613_() == stack.m_41613_()) {
                return IStashStorageItem.StashResult.NO_SPACE;
            }
            if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.m_41720_()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
                return IStashStorageItem.StashResult.MATCH_AND_SPACE;
            }
            return IStashStorageItem.StashResult.SPACE;
        }).orElse(IStashStorageItem.StashResult.NO_SPACE);
    }

    public void setNumberOfInventorySlots(ItemStack shulkerBoxStack, int numberOfInventorySlots) {
        NBTHelper.putInt((CompoundTag)shulkerBoxStack.m_41784_(), (String)"numberOfInventorySlots", (int)numberOfInventorySlots);
    }

    public int getNumberOfInventorySlots(ItemStack shulkerBoxStack) {
        int defaultNumberOfInventorySlots = shulkerBoxStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(StorageWrapper::getDefaultNumberOfInventorySlots).orElse(1);
        return NBTHelper.getInt((ItemStack)shulkerBoxStack, (String)"numberOfInventorySlots").map(inventorySlots -> Math.max(inventorySlots, defaultNumberOfInventorySlots)).orElse(defaultNumberOfInventorySlots);
    }

    public int getNumberOfUpgradeSlots(ItemStack shulkerBoxStack) {
        int defaultNumberOfUpgradeSlots = shulkerBoxStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(StorageWrapper::getDefaultNumberOfUpgradeSlots).orElse(1);
        return NBTHelper.getInt((ItemStack)shulkerBoxStack, (String)"numberOfUpgradeSlots").map(numberOfUpgradeSlots -> Math.max(numberOfUpgradeSlots, defaultNumberOfUpgradeSlots)).orElse(defaultNumberOfUpgradeSlots);
    }

    public void setNumberOfUpgradeSlots(ItemStack shulkerBoxStack, int numberOfUpgradeSlots) {
        NBTHelper.putInt((CompoundTag)shulkerBoxStack.m_41784_(), (String)"numberOfUpgradeSlots", (int)numberOfUpgradeSlots);
    }

    public boolean m_142207_(ItemStack storageStack, Slot slot, ClickAction action, Player player) {
        if (storageStack.m_41613_() > 1 || !slot.m_8010_(player) || slot.m_7993_().m_41619_() || action != ClickAction.SECONDARY) {
            return super.m_142207_(storageStack, slot, action, player);
        }
        ItemStack stackToStash = slot.m_7993_();
        ItemStack stashResult = this.stash(storageStack, stackToStash);
        if (stashResult.m_41613_() != stackToStash.m_41613_()) {
            slot.m_5852_(stashResult);
            slot.m_142406_(player, stashResult);
            return true;
        }
        return super.m_142207_(storageStack, slot, action, player);
    }

    public boolean m_142305_(ItemStack storageStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess carriedAccess) {
        if (storageStack.m_41613_() > 1 || !slot.m_5857_(storageStack) || action != ClickAction.SECONDARY) {
            return super.m_142305_(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        ItemStack result = this.stash(storageStack, otherStack);
        if (result.m_41613_() != otherStack.m_41613_()) {
            carriedAccess.m_142104_(result);
            slot.m_5852_(storageStack);
            return true;
        }
        return super.m_142305_(storageStack, otherStack, slot, action, player, carriedAccess);
    }
}

