/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;

public abstract class StorageBlockEntity
extends BlockEntity
implements IControllableStorage,
ILinkable,
ILockable,
Nameable,
ITierDisplay,
IUpgradeDisplay {
    public static final String STORAGE_WRAPPER_TAG = "storageWrapper";
    private final StorageWrapper storageWrapper = new StorageWrapper(() -> () -> ((StorageBlockEntity)this).m_6596_(), () -> WorldHelper.notifyBlockUpdate((BlockEntity)this), () -> {
        this.m_6596_();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }, this instanceof BarrelBlockEntity ? 4 : 1){

        public Optional<UUID> getContentsUuid() {
            if (this.contentsUuid == null) {
                this.contentsUuid = UUID.randomUUID();
                this.save();
            }
            return Optional.of(this.contentsUuid);
        }

        public ItemStack getWrappedStorageStack() {
            BlockPos pos = StorageBlockEntity.this.m_58899_();
            return StorageBlockEntity.this.m_58900_().m_60734_().getCloneItemStack(StorageBlockEntity.this.m_58900_(), (HitResult)new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), Direction.DOWN, pos, true), (BlockGetter)StorageBlockEntity.this.m_58904_(), pos, null);
        }

        @Override
        protected void onUpgradeRefresh() {
            Block block;
            if (!StorageBlockEntity.this.isDroppingContents && StorageBlockEntity.this.f_58857_ != null && !((StorageBlockEntity)StorageBlockEntity.this).f_58857_.f_46443_ && (block = StorageBlockEntity.this.m_58900_().m_60734_()) instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                storageBlock.setTicking(StorageBlockEntity.this.f_58857_, StorageBlockEntity.this.m_58899_(), StorageBlockEntity.this.m_58900_(), !StorageBlockEntity.this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).isEmpty());
            }
        }

        @Override
        public int getDefaultNumberOfInventorySlots() {
            Block block = StorageBlockEntity.this.m_58900_().m_60734_();
            if (block instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                return storageBlock.getNumberOfInventorySlots();
            }
            return 0;
        }

        @Override
        protected boolean isAllowedInStorage(ItemStack stack) {
            return StorageBlockEntity.this.isAllowedInStorage(stack);
        }

        @Override
        public int getDefaultNumberOfUpgradeSlots() {
            Block block = StorageBlockEntity.this.m_58900_().m_60734_();
            if (block instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                return storageBlock.getNumberOfUpgradeSlots();
            }
            return 0;
        }

        public int getBaseStackSizeMultiplier() {
            int n;
            Block block = StorageBlockEntity.this.m_58900_().m_60734_();
            if (block instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                n = storageBlock.getBaseStackSizeMultiplier();
            } else {
                n = super.getBaseStackSizeMultiplier();
            }
            return n;
        }

        @Override
        protected boolean emptyInventorySlotsAcceptItems() {
            return !StorageBlockEntity.this.locked || StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked();
        }

        @Override
        public ITrackedContentsItemHandler getInventoryForInputOutput() {
            if (StorageBlockEntity.this.locked && StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
                if (StorageBlockEntity.this.contentsFilteredItemHandler == null) {
                    StorageBlockEntity.this.contentsFilteredItemHandler = new ContentsFilteredItemHandler(() -> super.getInventoryForInputOutput(), () -> StorageBlockEntity.this.getStorageWrapper().getInventoryHandler().getSlotTracker(), () -> (MemorySettingsCategory)StorageBlockEntity.this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
                }
                return StorageBlockEntity.this.contentsFilteredItemHandler;
            }
            return super.getInventoryForInputOutput();
        }
    };
    @Nullable
    protected Component displayName = null;
    private boolean updateBlockRender = false;
    @Nullable
    private BlockPos controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean isBeingUpgraded = false;
    private boolean isDroppingContents = false;
    private boolean chunkBeingUnloaded = false;
    @Nullable
    private LazyOptional<IItemHandler> itemHandlerCap;
    @Nullable
    private LazyOptional<IItemHandler> noSideItemHandlerCap;
    private boolean locked = false;
    private boolean showLock = true;
    private boolean showTier = true;
    private boolean showUpgrades = false;
    @Nullable
    private ContentsFilteredItemHandler contentsFilteredItemHandler = null;

    protected abstract ContainerOpenersCounter getOpenersCounter();

    protected StorageBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends StorageBlockEntity> blockEntityType) {
        super(blockEntityType, pos, state);
        this.storageWrapper.setUpgradeCachesInvalidatedHandler(this::onUpgradeCachesInvalidated);
    }

    protected void onUpgradeCachesInvalidated() {
        this.invalidateStorageCap();
    }

    public boolean isOpen() {
        return this.getOpenersCounter().m_155450_() > 0;
    }

    public Component m_7770_() {
        return this.displayName;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveStorageWrapper(tag);
        this.saveSynchronizedData(tag);
        this.saveControllerPos(tag);
        if (this.isLinkedToController) {
            tag.m_128379_("isLinkedToController", this.isLinkedToController);
        }
    }

    private void saveStorageWrapper(CompoundTag tag) {
        tag.m_128365_(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.save(new CompoundTag()));
    }

    private void saveStorageWrapperClientData(CompoundTag tag) {
        tag.m_128365_(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.saveData(new CompoundTag()));
    }

    protected void saveSynchronizedData(CompoundTag tag) {
        if (this.displayName != null) {
            tag.m_128359_("displayName", Component.Serializer.m_130703_((Component)this.displayName));
        }
        if (this.updateBlockRender) {
            tag.m_128379_("updateBlockRender", true);
        }
        if (this.locked) {
            tag.m_128379_("locked", this.locked);
        }
        if (!this.showLock) {
            tag.m_128379_("showLock", this.showLock);
        }
        if (!this.showTier) {
            tag.m_128379_("showTier", this.showTier);
        }
        if (this.showUpgrades) {
            tag.m_128379_("showUpgrades", this.showUpgrades);
        }
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_() && this.f_58857_ != null) {
            this.getOpenersCounter().m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_() && this.f_58857_ != null) {
            this.getOpenersCounter().m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_ && this.f_58857_ != null) {
            this.getOpenersCounter().m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        Block block;
        if (this.f_58857_ == null || !((block = state.m_60734_()) instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)block;
        Vec3i vec3i = storageBlock.getFacing(state).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadStorageWrapper(tag);
        this.loadSynchronizedData(tag);
        this.loadControllerPos(tag);
        this.isLinkedToController = NBTHelper.getBoolean((CompoundTag)tag, (String)"isLinkedToController").orElse(false);
    }

    private void loadStorageWrapper(CompoundTag tag) {
        NBTHelper.getCompound((CompoundTag)tag, (String)STORAGE_WRAPPER_TAG).ifPresent(this.storageWrapper::load);
    }

    public void onLoad() {
        super.onLoad();
        this.storageWrapper.onInit();
        this.registerWithControllerOnLoad();
    }

    public void loadSynchronizedData(CompoundTag tag) {
        this.displayName = NBTHelper.getComponent((CompoundTag)tag, (String)"displayName").orElse(null);
        this.locked = NBTHelper.getBoolean((CompoundTag)tag, (String)"locked").orElse(false);
        this.showLock = NBTHelper.getBoolean((CompoundTag)tag, (String)"showLock").orElse(true);
        this.showTier = NBTHelper.getBoolean((CompoundTag)tag, (String)"showTier").orElse(true);
        this.showUpgrades = NBTHelper.getBoolean((CompoundTag)tag, (String)"showUpgrades").orElse(false);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            if (tag.m_128471_("updateBlockRender")) {
                WorldHelper.notifyBlockUpdate((BlockEntity)this);
            }
        } else {
            this.updateBlockRender = true;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void m_7651_() {
        if (!this.isBeingUpgraded && !this.chunkBeingUnloaded && this.f_58857_ != null) {
            this.removeFromController();
        }
        super.m_7651_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag == null) {
            return;
        }
        this.loadStorageWrapper(tag);
        this.loadSynchronizedData(tag);
    }

    public void setUpdateBlockRender() {
        this.updateBlockRender = true;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveStorageWrapperClientData(tag);
        this.saveSynchronizedData(tag);
        return tag;
    }

    public static void serverTick(Level level, BlockPos blockPos, StorageBlockEntity storageBlockEntity) {
        storageBlockEntity.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }

    public StorageWrapper getStorageWrapper() {
        return this.storageWrapper;
    }

    public Component m_7755_() {
        return this.m_5446_();
    }

    public Component m_5446_() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.m_58900_().m_60734_().m_49954_();
    }

    protected boolean isAllowedInStorage(ItemStack stack) {
        return true;
    }

    public void increaseStorageSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        int currentInventorySlots = this.getStorageWrapper().getInventoryHandler().getSlots();
        this.getStorageWrapper().increaseSize(additionalInventorySlots, additionalUpgradeSlots);
        if (additionalInventorySlots > 0) {
            this.changeSlots(currentInventorySlots + additionalInventorySlots);
        }
    }

    public void dropContents() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.isDroppingContents = true;
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getInventoryHandler(), (Level)this.f_58857_, (BlockPos)this.f_58858_);
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getUpgradeHandler(), (Level)this.f_58857_, (BlockPos)this.f_58858_);
        this.isDroppingContents = false;
    }

    public void setCustomName(Component customName) {
        this.displayName = customName;
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                if (this.noSideItemHandlerCap == null) {
                    this.noSideItemHandlerCap = LazyOptional.of(() -> this.getStorageWrapper().getInventoryForInputOutput());
                }
                return this.noSideItemHandlerCap.cast();
            }
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = LazyOptional.of(() -> new CachedFailedInsertInventoryHandler(() -> this.getStorageWrapper().getInventoryForInputOutput(), () -> this.f_58857_ != null ? this.f_58857_.m_46467_() : 0L));
            }
            return this.itemHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.invalidateStorageCap();
    }

    private void invalidateStorageCap() {
        if (this.itemHandlerCap != null) {
            LazyOptional<IItemHandler> tempItemHandlerCap = this.itemHandlerCap;
            this.itemHandlerCap = null;
            tempItemHandlerCap.invalidate();
        }
        if (this.noSideItemHandlerCap != null) {
            LazyOptional<IItemHandler> tempNoSideItemHandlerCap = this.noSideItemHandlerCap;
            this.noSideItemHandlerCap = null;
            tempNoSideItemHandlerCap.invalidate();
        }
    }

    public boolean shouldDropContents() {
        return true;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.m_6596_();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.m_6596_();
    }

    public BlockPos getStorageBlockPos() {
        return this.m_58899_();
    }

    public Level getStorageBlockLevel() {
        return Objects.requireNonNull(this.m_58904_());
    }

    public void linkToController(BlockPos controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.m_6596_();
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.m_6596_();
    }

    public boolean canConnectStorages() {
        return !this.isLinkedToController;
    }

    public Set<BlockPos> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public boolean canBeConnected() {
        return this.isLinked() || super.canBeConnected();
    }

    public void setBeingUpgraded() {
        this.isBeingUpgraded = true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void toggleLock() {
        if (this.locked) {
            this.unlock();
        } else {
            this.lock();
        }
    }

    public boolean memorizesItemsWhenLocked() {
        return false;
    }

    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return true;
    }

    private void lock() {
        this.locked = true;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).selectSlots(0, this.getStorageWrapper().getInventoryHandler().getSlots());
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateStorageCap();
        }
        this.m_6596_();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    private void unlock() {
        this.locked = false;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).unselectAllSlots();
            ItemDisplaySettingsCategory itemDisplaySettings = (ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class);
            InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                if (stack.m_41619_()) {
                    itemDisplaySettings.itemChanged(slot.intValue());
                }
            });
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateStorageCap();
        }
        this.m_6596_();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowLock() {
        return this.showLock;
    }

    @Override
    public void toggleLockVisibility() {
        this.showLock = !this.showLock;
        this.m_6596_();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowTier() {
        return this.showTier;
    }

    @Override
    public void toggleTierVisiblity() {
        this.showTier = !this.showTier;
        this.m_6596_();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowUpgrades() {
        return this.showUpgrades;
    }

    @Override
    public void toggleUpgradesVisiblity() {
        this.showUpgrades = !this.showUpgrades;
        this.m_6596_();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public void onNeighborChange(BlockPos neighborPos) {
        Direction direction = Direction.m_122378_((int)Integer.signum(neighborPos.m_123341_() - this.f_58858_.m_123341_()), (int)Integer.signum(neighborPos.m_123342_() - this.f_58858_.m_123342_()), (int)Integer.signum(neighborPos.m_123343_() - this.f_58858_.m_123343_()));
        if (direction == null) {
            return;
        }
        this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(INeighborChangeListenerUpgrade.class).forEach(upgrade -> upgrade.onNeighborChange(this.f_58857_, this.f_58858_, direction));
    }

    public float getSlotFillPercentage(int slot) {
        ItemStack stackInSlot = this.storageWrapper.getInventoryHandler().getStackInSlot(slot);
        return (float)stackInSlot.m_41613_() / (float)this.storageWrapper.getInventoryHandler().getStackLimit(slot, stackInSlot);
    }

    private static class ContentsFilteredItemHandler
    implements ITrackedContentsItemHandler {
        private final Supplier<ITrackedContentsItemHandler> itemHandlerGetter;
        private final Supplier<ISlotTracker> slotTrackerGetter;
        private final Supplier<MemorySettingsCategory> memorySettingsGetter;

        private ContentsFilteredItemHandler(Supplier<ITrackedContentsItemHandler> itemHandlerGetter, Supplier<ISlotTracker> slotTrackerGetter, Supplier<MemorySettingsCategory> memorySettingsGetter) {
            this.itemHandlerGetter = itemHandlerGetter;
            this.slotTrackerGetter = slotTrackerGetter;
            this.memorySettingsGetter = memorySettingsGetter;
        }

        public int getSlots() {
            return this.itemHandlerGetter.get().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.itemHandlerGetter.get().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.matchesContents(stack)) {
                return this.itemHandlerGetter.get().insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandlerGetter.get().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandlerGetter.get().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.matchesContents(stack) && this.itemHandlerGetter.get().isItemValid(slot, stack);
        }

        private boolean matchesContents(ItemStack stack) {
            return this.slotTrackerGetter.get().getItems().contains(stack.m_41720_()) || this.memorySettingsGetter.get().matchesFilter(stack);
        }

        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            if (this.matchesContents(stack)) {
                return this.itemHandlerGetter.get().insertItem(stack, simulate);
            }
            return stack;
        }

        public Set<ItemStackKey> getTrackedStacks() {
            return this.itemHandlerGetter.get().getTrackedStacks();
        }

        public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
            this.itemHandlerGetter.get().registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
        }

        public void unregisterStackKeyListeners() {
            this.itemHandlerGetter.get().unregisterStackKeyListeners();
        }

        public boolean hasEmptySlots() {
            return this.itemHandlerGetter.get().hasEmptySlots();
        }

        public int getInternalSlotLimit(int slot) {
            return this.itemHandlerGetter.get().getInternalSlotLimit(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.itemHandlerGetter.get().setStackInSlot(slot, stack);
        }
    }
}

