/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.block.IBlockProvider;

public final class NameUtils {
    private static final Pattern PATTERN = Pattern.compile("([a-z0-9._-]+:)?[a-z0-9/._-]+");

    private NameUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isValid(CharSequence name) {
        return PATTERN.matcher(name).matches();
    }

    public static ResourceLocation checkNotNull(@Nullable ResourceLocation name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name is null, make sure the object has been registered correctly");
        return name;
    }

    public static ResourceLocation forgeId(String path) {
        return new ResourceLocation("forge", path);
    }

    public static ResourceLocation fromBlock(Block block) {
        return NameUtils.checkNotNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public static ResourceLocation fromBlock(IBlockProvider block) {
        Preconditions.checkNotNull((Object)block.asBlock(), (Object)"asBlock() is null, has object not been fully constructed?");
        return NameUtils.fromBlock(block.asBlock());
    }

    public static ResourceLocation fromBlock(BlockState state) {
        return NameUtils.fromBlock(state.m_60734_());
    }

    public static ResourceLocation fromEnchantment(Enchantment enchantment) {
        return NameUtils.checkNotNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment));
    }

    public static ResourceLocation fromEntity(Entity entity) {
        return NameUtils.fromEntityType(entity.m_6095_());
    }

    public static ResourceLocation fromEntityType(EntityType<?> type) {
        return NameUtils.checkNotNull(ForgeRegistries.ENTITY_TYPES.getKey(type));
    }

    public static ResourceLocation fromFluid(Fluid fluid) {
        return NameUtils.checkNotNull(ForgeRegistries.FLUIDS.getKey((Object)fluid));
    }

    public static ResourceLocation fromFluid(FluidStack fluid) {
        return NameUtils.fromFluid(fluid.getFluid());
    }

    public static ResourceLocation fromItem(ItemLike item) {
        Preconditions.checkNotNull((Object)item.m_5456_(), (Object)"asItem() is null, has object not been fully constructed?");
        return NameUtils.checkNotNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
    }

    public static ResourceLocation fromItem(ItemStack stack) {
        return NameUtils.fromItem((ItemLike)stack.m_41720_());
    }

    public static ResourceLocation fromRecipeSerializer(RecipeSerializer<? extends Recipe<?>> serializer) {
        return NameUtils.checkNotNull(ForgeRegistries.RECIPE_SERIALIZERS.getKey(serializer));
    }
}

