/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public final class StackList
extends ArrayList<ItemStack> {
    private StackList() {
    }

    public static StackList of(ItemStack ... stacks) {
        StackList newList = new StackList();
        Collections.addAll(newList, stacks);
        return newList;
    }

    public static StackList from(Container inventory) {
        StackList newList = new StackList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            newList.add(inventory.m_8020_(i));
        }
        return newList;
    }

    public static StackList from(Iterable<Tag> tagList) {
        StackList newList = new StackList();
        for (Tag nbt : tagList) {
            if (!(nbt instanceof CompoundTag)) continue;
            newList.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt)));
        }
        return newList;
    }

    public ItemStack firstOfType(Class<?> itemClass) {
        return this.firstMatch(StackList.itemClassMatcher(itemClass));
    }

    public ItemStack firstMatch(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).findFirst().orElse(ItemStack.f_41583_);
    }

    public ItemStack uniqueOfType(Class<?> itemClass) {
        return this.uniqueMatch(StackList.itemClassMatcher(itemClass));
    }

    public ItemStack uniqueMatch(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.size() == 1 ? (ItemStack)list.get(0) : ItemStack.f_41583_));
    }

    public Collection<ItemStack> allOfType(Class<?> itemClass) {
        return this.allMatches(StackList.itemClassMatcher(itemClass));
    }

    public Collection<ItemStack> allMatches(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).collect(Collectors.toList());
    }

    public int countOfType(Class<?> itemClass) {
        return this.countOfMatches(StackList.itemClassMatcher(itemClass));
    }

    public int countOfMatches(Predicate<ItemStack> predicate) {
        return (int)this.stream().filter(predicate).count();
    }

    private static Predicate<ItemStack> itemClassMatcher(Class<?> itemClass) {
        return stack -> itemClass.isInstance(stack.m_41720_());
    }

    @Override
    public boolean add(ItemStack itemStack) {
        return !itemStack.m_41619_() && super.add(itemStack);
    }

    @Override
    public boolean addAll(Collection<? extends ItemStack> c) {
        boolean added = false;
        for (ItemStack itemStack : c) {
            if (itemStack.m_41619_()) continue;
            added |= super.add(itemStack);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends ItemStack> c) {
        boolean added = false;
        for (ItemStack itemStack : c) {
            if (itemStack.m_41619_()) continue;
            super.add(index, itemStack);
            added = true;
        }
        return added;
    }

    @Override
    public void add(int index, ItemStack element) {
        if (!element.m_41619_()) {
            super.add(index, element);
        }
    }
}

