/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class GearShearsItem
extends ShearsItem
implements ICoreTool {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.ENCHANTMENT_VALUE, (Object)ItemStats.HARVEST_SPEED);

    public GearShearsItem() {
        super(GearHelper.getBaseItemProperties().m_41503_(100));
    }

    @Override
    public GearType getGearType() {
        return GearType.SHEARS;
    }

    @Override
    public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        float speed = this.getStat(stack, ItemStats.HARVEST_SPEED);
        if (!state.m_60713_(Blocks.f_50033_) && !state.m_204336_(BlockTags.f_13035_)) {
            return state.m_204336_(BlockTags.f_13089_) ? speed - 1.0f : 1.0f;
        }
        return 2.5f * speed;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        if (GearHelper.isBroken(stack)) {
            return InteractionResult.PASS;
        }
        return super.m_6880_(stack, playerIn, entity, hand);
    }

    @Override
    public int getDamageOnBlockBreak(ItemStack gear, Level world, BlockState state, BlockPos pos) {
        if (!state.m_204336_(BlockTags.f_13076_)) {
            return 1;
        }
        return ICoreTool.super.getDamageOnBlockBreak(gear, world, state, pos);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, GearHelper.calcDamageClamped(stack, damage));
        if (GearHelper.isBroken(stack)) {
            GearData.recalculateStats(stack, null);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public Rarity m_41460_(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        Player player = context.m_43723_();
        if (player != null && GearShearsItem.getHoneyLevel(state) >= 5) {
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11697_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            BeehiveBlock.m_49600_((Level)world, (BlockPos)pos);
            context.m_43722_().m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(context.m_43724_()));
            BeehiveBlock block = (BeehiveBlock)state.m_60734_();
            if (!CampfireBlock.m_51248_((Level)world, (BlockPos)pos)) {
                if (block.m_49654_(world, pos)) {
                    block.m_49649_(world, pos);
                }
                block.m_49594_(world, state, pos, player, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
            } else {
                block.m_49590_(world, state, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return GearHelper.onItemUse(context);
    }

    private static int getHoneyLevel(BlockState state) {
        if (state.m_60734_() instanceof BeehiveBlock && state.m_61138_((Property)BeehiveBlock.f_49564_)) {
            return (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_);
        }
        return 0;
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

