/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.entity.projectile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PlayMessages;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.init.SgEntities;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class GearArrowEntity
extends Arrow {
    private static final Cache<UUID, ItemStack> STACK_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private ItemStack arrowStack = ItemStack.f_41583_;

    public GearArrowEntity(EntityType<? extends Arrow> type, Level worldIn) {
        super(type, worldIn);
    }

    public GearArrowEntity(Level worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public GearArrowEntity(Level worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    public GearArrowEntity(PlayMessages.SpawnEntity message, Level world) {
        this((EntityType<? extends Arrow>)((EntityType)SgEntities.ARROW.get()), world);
    }

    private static boolean isSameArrowStack(UUID uuid, ItemStack other) {
        return other.m_41773_() > 0 && GearHelper.isGear(other) && GearData.getUUID(other).equals(uuid);
    }

    public void setArrowStack(ItemStack stack) {
        try {
            this.arrowStack = (ItemStack)STACK_CACHE.get((Object)GearData.getUUID(stack), () -> GearArrowEntity.getArrowClone(stack));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static ItemStack getArrowClone(ItemStack stack) {
        ItemStack ret = stack.m_41777_();
        ret.m_41721_(ret.m_41776_() - 1);
        return ret;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        Entity shooter = this.m_37282_();
        if (shooter instanceof Player && !((Player)shooter).m_150110_().f_35937_) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public void m_37251_(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        float speedMulti = GearData.getStat(this.arrowStack, ItemStats.PROJECTILE_SPEED);
        float accuracy = GearData.getStat(this.arrowStack, ItemStats.PROJECTILE_ACCURACY);
        super.m_37251_(shooter, x, y, z, velocity * speedMulti, accuracy > 0.0f ? inaccuracy / accuracy : inaccuracy);
    }

    public void m_6123_(Player entityIn) {
        if (!this.f_19853_.f_46443_ && (this.f_36703_ || this.m_36797_()) && this.f_36706_ <= 0) {
            boolean flag;
            boolean bl = flag = this.f_36705_ == AbstractArrow.Pickup.ALLOWED || this.f_36705_ == AbstractArrow.Pickup.CREATIVE_ONLY && entityIn.m_150110_().f_35937_ || this.m_36797_() && this.m_37282_().m_20148_() == entityIn.m_20148_();
            if (!(this.f_36705_ != AbstractArrow.Pickup.ALLOWED || GearHelper.isGear(this.arrowStack) && this.addArrowToPlayerInventory(entityIn))) {
                flag = false;
            }
            if (flag) {
                entityIn.m_7938_((Entity)this, 1);
                this.m_146870_();
            }
        }
    }

    private boolean addArrowToPlayerInventory(Player player) {
        UUID uuid = GearData.getUUID(this.arrowStack);
        for (ItemStack stack : player.m_150109_().f_35976_) {
            if (!GearArrowEntity.isSameArrowStack(uuid, stack)) continue;
            stack.m_41721_(stack.m_41773_() - 1);
            return true;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!GearArrowEntity.isSameArrowStack(uuid, stack)) continue;
            stack.m_41721_(stack.m_41773_() - 1);
            return true;
        }
        return player.m_36356_(this.arrowStack);
    }
}

