/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.Collection;
import java.util.List;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.item.CompoundPartItem;

public final class ColorUtils {
    private ColorUtils() {
    }

    public static int getBlendedColor(ICoreItem item, IPartData part, Collection<? extends IMaterialInstance> materials, int layer) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (IMaterialInstance iMaterialInstance : materials) {
            IMaterialDisplay model = iMaterialInstance.getDisplayProperties();
            int color = model.getLayerColor(item.getGearType(), part, iMaterialInstance, layer);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = (materials.size() - i) * (materials.size() - i);
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    public static int getBlendedColor(CompoundPartItem item, Collection<? extends IMaterialInstance> materials, int layer) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (IMaterialInstance iMaterialInstance : materials) {
            IMaterialDisplay model = iMaterialInstance.getDisplayProperties();
            List<MaterialLayer> layers = model.getLayerList(item.getGearType(), item.getPartType(), iMaterialInstance).getLayers();
            if (layers.size() <= layer) continue;
            int color = model.getLayerColor(item.getGearType(), item.getPartType(), iMaterialInstance, layer);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = item.getColorWeight(i, materials.size());
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    public static int getBlendedColor(CompoundMaterialItem item, Collection<? extends IMaterialInstance> materials, int layer) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (IMaterialInstance iMaterialInstance : materials) {
            IMaterialDisplay model = iMaterialInstance.getDisplayProperties();
            List<MaterialLayer> layers = model.getLayerList(GearType.ALL, PartType.MAIN, iMaterialInstance).getLayers();
            if (layers.size() <= layer) continue;
            int color = layers.get(layer).getColor();
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = item.getColorWeight(i, materials.size());
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    private static int blendColors(int[] componentSums, float maxColorSum, int colorCount) {
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            return finalColor;
        }
        return 0xFFFFFF;
    }
}

