/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.gear.IProxy;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.DebugOverlay;
import net.silentchaos512.gear.client.event.ExtraBlockBreakHandler;
import net.silentchaos512.gear.client.event.GearHudOverlay;
import net.silentchaos512.gear.client.event.TooltipHandler;
import net.silentchaos512.gear.client.material.GearDisplayManager;
import net.silentchaos512.gear.client.util.ModItemModelProperties;
import net.silentchaos512.gear.compat.curios.CurioGearItemCapability;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.compat.gamestages.GameStagesCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.init.NerfedGear;
import net.silentchaos512.gear.init.SgBlockEntities;
import net.silentchaos512.gear.init.SgBlocks;
import net.silentchaos512.gear.init.SgCommands;
import net.silentchaos512.gear.init.SgEnchantments;
import net.silentchaos512.gear.init.SgEntities;
import net.silentchaos512.gear.init.SgItems;
import net.silentchaos512.gear.init.SgLoot;
import net.silentchaos512.gear.init.SgMenuTypes;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.init.SgVillages;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.network.Network;
import net.silentchaos512.lib.event.Greetings;
import net.silentchaos512.lib.event.InitialSpawnItems;
import net.silentchaos512.lib.util.LibHooks;

class SideProxy
implements IProxy {
    @Nullable
    private static MinecraftServer server;

    SideProxy() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SgBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        SgBlocks.BLOCKS.register(modEventBus);
        SgMenuTypes.MENU_TYPES.register(modEventBus);
        SgEnchantments.ENCHANTMENTS.register(modEventBus);
        SgEntities.ENTITIES.register(modEventBus);
        SgItems.ITEMS.register(modEventBus);
        SgLoot.LOOT_CONDITIONS.register(modEventBus);
        SgLoot.LOOT_FUNCTIONS.register(modEventBus);
        SgLoot.LOOT_MODIFIERS.register(modEventBus);
        SgVillages.POINTS_OF_INTEREST.register(modEventBus);
        SgVillages.PROFESSIONS.register(modEventBus);
        SgRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        SgRecipes.RECIPE_TYPES.register(modEventBus);
        if (this.checkClientInstance()) {
            Config.init();
            Network.init();
        }
        modEventBus.addListener(SideProxy::commonSetup);
        modEventBus.addListener(SideProxy::registerCapabilities);
        modEventBus.addListener(SideProxy::imcEnqueue);
        modEventBus.addListener(SideProxy::imcProcess);
        MinecraftForge.EVENT_BUS.addListener(SgCommands::registerAll);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::onAddReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStopping);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        InitialSpawnItems.add((ResourceLocation)SilentGear.getId("starter_blueprints"), p -> {
            if (((Boolean)Config.Common.spawnWithStarterBlueprints.get()).booleanValue()) {
                return Collections.singleton(((BlueprintPackageItem)((Object)((Object)SgItems.BLUEPRINT_PACKAGE.get()))).getStack());
            }
            return Collections.emptyList();
        });
        SideProxy.registerCompostables();
        NerfedGear.init();
        Greetings.addMessage(SideProxy::detectDataLoadingFailure);
    }

    private static void registerCompostables() {
        LibHooks.registerCompostable((float)0.3f, SgItems.FLAX_SEEDS);
        LibHooks.registerCompostable((float)0.3f, SgItems.FLUFFY_SEEDS);
        LibHooks.registerCompostable((float)0.5f, (ItemLike)CraftingItems.FLAX_FIBER);
        LibHooks.registerCompostable((float)0.5f, (ItemLike)CraftingItems.FLUFFY_PUFF);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        if (ModList.get().isLoaded("curios")) {
            event.register(CurioGearItemCapability.class);
        }
    }

    private static void imcEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.imcEnqueue(event);
        }
    }

    private static void imcProcess(InterModProcessEvent event) {
    }

    private static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)TraitManager.INSTANCE);
        event.addListener((PreparableReloadListener)PartManager.INSTANCE);
        event.addListener((PreparableReloadListener)MaterialManager.INSTANCE);
        if (ModList.get().isLoaded("gamestages")) {
            event.addListener(GameStagesCompat.INSTANCE);
        }
    }

    private static void serverStarted(ServerStartedEvent event) {
        server = event.getServer();
        SilentGear.LOGGER.info(TraitManager.MARKER, "Traits loaded: {}", (Object)TraitManager.getValues().size());
        SilentGear.LOGGER.info(PartManager.MARKER, "Parts loaded: {}", (Object)PartManager.getValues().size());
        SilentGear.LOGGER.info(PartManager.MARKER, "- Compound: {}", (Object)PartManager.getValues().stream().filter(part -> part instanceof CompoundPart).count());
        SilentGear.LOGGER.info(PartManager.MARKER, "- Simple: {}", (Object)PartManager.getValues().stream().filter(part -> !(part instanceof CompoundPart)).count());
        SilentGear.LOGGER.info(MaterialManager.MARKER, "Materials loaded: {}", (Object)MaterialManager.getValues().size());
        SilentGear.LOGGER.info(MaterialManager.MARKER, "- Standard: {}", (Object)MaterialManager.getValues().stream().filter(mat -> mat.getSerializer() == MaterialSerializers.STANDARD).count());
    }

    private static void serverStopping(ServerStoppingEvent event) {
        server = null;
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return null;
    }

    @Override
    @Nullable
    public Level getClientLevel() {
        return null;
    }

    @Override
    public boolean checkClientInstance() {
        return true;
    }

    @Override
    public boolean checkClientConnection() {
        return true;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return server;
    }

    @Nullable
    public static Component detectDataLoadingFailure(Player player) {
        if (MaterialManager.getValues().isEmpty() || PartManager.getValues().isEmpty() || TraitManager.getValues().isEmpty()) {
            String msg = "Materials, parts, and/or traits have not loaded! This may be caused by a broken mod, even those not related to Silent Gear. Search your log for \"Failed to reload data packs\" to find the error.";
            SilentGear.LOGGER.error(msg);
            return Component.m_237113_((String)msg);
        }
        return null;
    }

    static class Server
    extends SideProxy {
        Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Client::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Client::postSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ColorHandlers::onItemColors);
            MinecraftForge.EVENT_BUS.register((Object)ExtraBlockBreakHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)new GearHudOverlay());
            MinecraftForge.EVENT_BUS.register((Object)TooltipHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            if (SilentGear.isDevBuild()) {
                MinecraftForge.EVENT_BUS.register((Object)new DebugOverlay());
            }
            if (Minecraft.m_91087_() != null) {
                ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
                if (resourceManager instanceof ReloadableResourceManager) {
                    ((ReloadableResourceManager)resourceManager).m_7217_((PreparableReloadListener)GearDisplayManager.INSTANCE);
                }
            } else {
                SilentGear.LOGGER.warn("MC instance is null? Must be running data generators! Not registering model loaders...");
            }
        }

        private static void clientSetup(FMLClientSetupEvent event) {
            SgBlockEntities.registerRenderers(event);
            SgMenuTypes.registerScreens(event);
            ModItemModelProperties.register(event);
        }

        private static void postSetup(FMLLoadCompleteEvent event) {
        }

        private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        }

        @Override
        @Nullable
        public Player getClientPlayer() {
            return Minecraft.m_91087_().f_91074_;
        }

        @Override
        @Nullable
        public Level getClientLevel() {
            Minecraft mc = Minecraft.m_91087_();
            return mc != null ? mc.f_91073_ : null;
        }

        @Override
        public boolean checkClientInstance() {
            return Minecraft.m_91087_() != null;
        }

        @Override
        public boolean checkClientConnection() {
            Minecraft mc = Minecraft.m_91087_();
            return mc != null && mc.m_91403_() != null;
        }
    }
}

