/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.util.forge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import li.cil.scannable.util.ConfigManager;
import li.cil.scannable.util.config.ConfigType;
import li.cil.scannable.util.config.Type;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public final class ConfigManagerImpl
extends ConfigManager {
    private static final Map<IConfigSpec<ForgeConfigSpec>, ConfigManager.ConfigDefinition> CONFIGS = new HashMap<IConfigSpec<ForgeConfigSpec>, ConfigManager.ConfigDefinition>();

    public static <T> void add(Supplier<T> factory) {
        ArrayList values = new ArrayList();
        Pair config = new ForgeConfigSpec.Builder().configure(builder -> {
            Object instance = factory.get();
            ConfigManagerImpl.fillSpec(instance, new BuilderImpl((ForgeConfigSpec.Builder)builder), values);
            return instance;
        });
        CONFIGS.put((IConfigSpec<ForgeConfigSpec>)((IConfigSpec)config.getValue()), ConfigManagerImpl.createDefinition(config.getKey(), values));
    }

    public static void initialize() {
        CONFIGS.forEach((spec, config) -> {
            Type typeAnnotation = config.instance().getClass().getAnnotation(Type.class);
            ConfigType configType = typeAnnotation != null ? typeAnnotation.value() : ConfigType.COMMON;
            ModConfig.Type platformType = switch (configType) {
                default -> throw new IncompatibleClassChangeError();
                case ConfigType.COMMON -> ModConfig.Type.COMMON;
                case ConfigType.CLIENT -> ModConfig.Type.CLIENT;
                case ConfigType.SERVER -> ModConfig.Type.SERVER;
            };
            ModLoadingContext.get().registerConfig(platformType, spec);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigManagerImpl::handleModConfigEvent);
    }

    private static void handleModConfigEvent(ModConfigEvent event) {
        ConfigManager.ConfigDefinition config = CONFIGS.get(event.getConfig().getSpec());
        if (config != null) {
            config.apply();
        }
    }

    private record BuilderImpl(ForgeConfigSpec.Builder builder) implements ConfigManager.Builder
    {
        @Override
        public <T> ConfigManager.ConfigValue<T> define(String path, T defaultValue) {
            return new ConfigValueImpl(this.builder.define(path, defaultValue));
        }

        @Override
        public <T extends Comparable<? super T>> ConfigManager.ConfigValue<T> defineInRange(String path, T defaultValue, T min, T max, Class<T> type) {
            return new ConfigValueImpl(this.builder.defineInRange(path, defaultValue, min, max, type));
        }

        @Override
        public ConfigManager.Builder comment(String ... comment) {
            this.builder.comment(comment);
            return this;
        }

        @Override
        public ConfigManager.Builder translation(@Nullable String translationKey) {
            this.builder.translation(translationKey);
            return this;
        }

        @Override
        public ConfigManager.Builder worldRestart() {
            this.builder.worldRestart();
            return this;
        }
    }

    private record ConfigValueImpl<T>(ForgeConfigSpec.ConfigValue<T> value) implements ConfigManager.ConfigValue<T>
    {
        @Override
        public T get() {
            return (T)this.value().get();
        }
    }
}

