/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.scanning.ScanResultProviders;
import li.cil.scannable.client.scanning.filter.BlockCacheScanFilter;
import li.cil.scannable.client.scanning.filter.BlockScanFilter;
import li.cil.scannable.client.scanning.filter.BlockTagScanFilter;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.scanning.CommonOresBlockScannerModule;
import li.cil.scannable.common.scanning.filter.IgnoredBlocks;
import li.cil.scannable.common.scanning.forge.RareOresBlockScannerModuleImpl;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;

public enum RareOresBlockScannerModule implements BlockScannerModule
{
    INSTANCE;

    private Predicate<BlockState> filter;

    public static void clearCache() {
        RareOresBlockScannerModule.INSTANCE.filter = null;
    }

    @Override
    public int getEnergyCost(ItemStack module) {
        return CommonConfig.energyCostModuleOreRare;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)ScanResultProviders.BLOCKS.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.25f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<BlockState> getFilter(ItemStack module) {
        this.validateFilter();
        return this.filter;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<Predicate<BlockState>> filters = new ArrayList<Predicate<BlockState>>();
        for (ResourceLocation location : CommonConfig.rareOreBlocks) {
            Registry.f_122824_.m_6612_(location).ifPresent(block -> filters.add(new BlockScanFilter((Block)block)));
        }
        Registry.f_122824_.m_203613_().forEach(tag -> {
            if (CommonConfig.rareOreBlockTags.contains(tag.f_203868_())) {
                filters.add(new BlockTagScanFilter((TagKey<Block>)tag));
            }
        });
        TagKey<Block> topLevelOreTag = RareOresBlockScannerModule.getTopLevelOreTag();
        filters.add(state -> !IgnoredBlocks.contains(state) && state.m_204336_(topLevelOreTag) && !CommonOresBlockScannerModule.INSTANCE.getFilter(ItemStack.f_41583_).test((BlockState)state));
        this.filter = new BlockCacheScanFilter((Collection<Predicate<BlockState>>)filters);
    }

    @ExpectPlatform
    @Contract(value="_ -> !null")
    @ExpectPlatform.Transformed
    private static TagKey<Block> getTopLevelOreTag() {
        return RareOresBlockScannerModuleImpl.getTopLevelOreTag();
    }
}

