/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.forge.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.energy.forge.ScannerEnergyStorage;
import li.cil.scannable.common.inventory.ScannerContainer;
import li.cil.scannable.common.item.ScannerItem;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ScannerWrapper
implements ICapabilityProvider {
    private static final ResourceLocation KEY = new ResourceLocation("scannable", "scanner");
    private final IItemHandler itemHandler;
    private final IEnergyStorage energyStorage;
    private final LazyOptional<IItemHandler> itemHandlerHolder;
    private final LazyOptional<IEnergyStorage> energyStorageHolder;

    public ScannerWrapper(ItemStack container) {
        this.itemHandler = new InvWrapper((Container)ScannerContainer.of(container));
        this.energyStorage = ScannerEnergyStorage.of(container);
        this.itemHandlerHolder = LazyOptional.of(() -> this.itemHandler);
        this.energyStorageHolder = LazyOptional.of(() -> this.energyStorage);
    }

    @SubscribeEvent
    public static void attachScannerModuleCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_41720_() instanceof ScannerItem) {
            event.addCapability(KEY, (ICapabilityProvider)new ScannerWrapper((ItemStack)event.getObject()));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional itemHandlerCapability = ForgeCapabilities.ITEM_HANDLER.orEmpty(capability, this.itemHandlerHolder);
        if (itemHandlerCapability.isPresent()) {
            return itemHandlerCapability;
        }
        LazyOptional energyCapability = ForgeCapabilities.ENERGY.orEmpty(capability, this.energyStorageHolder);
        if (CommonConfig.useEnergy && energyCapability.isPresent()) {
            return energyCapability;
        }
        return LazyOptional.empty();
    }
}

