/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public class BlazingInfuserTileEntity
extends TickingTileEntity {
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int SLOT_CATALYST = 2;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BlazingModule.BLAZING_ROD.get()}).in(), 0, 46, 7).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BlazingModule.BLAZING_ROD.get()}).out(), 1, 100, 7).slot(SlotDefinition.specific(stack -> BlazingInfuserTileEntity.getCatalystImprovement(stack) != null).in(), 2, 46, 25).playerSlots(10, 70));
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BlazingConfiguration.INFUSER_MAXENERGY.get()).intValue(), (long)((Integer)BlazingConfiguration.INFUSER_ENERGY_INPUT_PERTICK.get()).intValue());
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid((slot, stack) -> switch (slot) {
        case 0, 1 -> {
            if (stack.m_41720_() == BlazingModule.BLAZING_ROD.get()) {
                yield true;
            }
            yield false;
        }
        case 2 -> {
            if (BlazingInfuserTileEntity.getCatalystImprovement(stack) != null) {
                yield true;
            }
            yield false;
        }
        default -> false;
    }).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Blazing Infuser").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_INFUSER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private int counter = 10;

    public BlazingInfuserTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlazingModule.TYPE_BLAZING_INFUSER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/blazinginfuser")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(BlazingInfuserTileEntity::new));
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter < 0) {
            this.counter = 10;
            ItemStack stack = this.items.getStackInSlot(0);
            if (stack.m_41720_() == BlazingModule.BLAZING_ROD.get()) {
                int steps = BlazingRod.getInfusionStepsLeft(stack);
                if (steps <= 0) {
                    if (this.items.getStackInSlot(1).m_41619_()) {
                        this.items.setStackInSlot(1, stack);
                        this.items.setStackInSlot(0, ItemStack.f_41583_);
                    }
                } else {
                    ItemStack catalyst = this.items.getStackInSlot(2);
                    if (!catalyst.m_41619_() && this.energyStorage.getEnergy() >= (long)((Integer)BlazingConfiguration.INFUSER_USE_PER_TICK.get()).intValue()) {
                        this.energyStorage.consumeEnergy((long)((Integer)BlazingConfiguration.INFUSER_USE_PER_TICK.get()).intValue());
                        BlazingRod.setInfusionStepsLeft(stack, --steps);
                        this.items.extractItem(2, 1, false);
                        this.infuse(stack, catalyst);
                        if (steps <= 0 && this.items.getStackInSlot(1).m_41619_()) {
                            this.items.setStackInSlot(1, stack);
                            this.items.setStackInSlot(0, ItemStack.f_41583_);
                        }
                    }
                }
            }
        }
        this.markDirtyQuick();
    }

    @Nullable
    private static Pair<Float, Float> getCatalystImprovement(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42451_) {
            return Pair.of((Object)Float.valueOf(40.0f), (Object)Float.valueOf(0.0f));
        }
        if (stack.m_41720_() == Items.f_42525_) {
            return Pair.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(30.0f));
        }
        if (stack.m_41720_() == Items.f_42692_) {
            return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(40.0f));
        }
        if (stack.m_41720_() == VariousModule.DIMENSIONALSHARD.get()) {
            return Pair.of((Object)Float.valueOf(60.0f), (Object)Float.valueOf(60.0f));
        }
        if (stack.m_41720_() == Items.f_42686_) {
            return Pair.of((Object)Float.valueOf(120.0f), (Object)Float.valueOf(120.0f));
        }
        if (stack.m_41720_() == Items.f_42586_) {
            return Pair.of((Object)Float.valueOf(80.0f), (Object)Float.valueOf(80.0f));
        }
        return null;
    }

    private void infuse(ItemStack stack, ItemStack catalyst) {
        Pair<Float, Float> pair = BlazingInfuserTileEntity.getCatalystImprovement(catalyst);
        if (pair != null) {
            this.improveQuality(stack, ((Float)pair.getLeft()).floatValue());
            this.improveDuration(stack, ((Float)pair.getRight()).floatValue());
        }
    }

    private void improveDuration(ItemStack stack, float factor) {
        float duration = BlazingRod.getPowerDuration(stack);
        duration += duration * factor / 6400.0f;
        BlazingRod.setPowerDuration(stack, duration);
    }

    private void improveQuality(ItemStack stack, float factor) {
        float quality = BlazingRod.getPowerQuality(stack);
        quality += quality * factor / 6400.0f;
        BlazingRod.setPowerQuality(stack, quality);
    }
}

