/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.grid;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import mcjty.rftoolsbase.api.control.code.Opcode;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterDescription;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.Connection;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Opcodes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class GridInstance {
    private final String id;
    private final Connection primaryConnection;
    private final Connection secondaryConnection;
    private final List<Parameter> parameters;

    private GridInstance(Builder builder) {
        this.id = builder.id;
        this.primaryConnection = builder.primaryConnection;
        this.secondaryConnection = builder.secondaryConnection;
        this.parameters = builder.parameters;
    }

    public String getId() {
        return this.id;
    }

    public Connection getPrimaryConnection() {
        return this.primaryConnection;
    }

    public Connection getSecondaryConnection() {
        return this.secondaryConnection;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public JsonElement getJsonElement() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("id", (JsonElement)new JsonPrimitive(this.getId()));
        if (this.primaryConnection != null) {
            jsonObject.add("primary", (JsonElement)new JsonPrimitive(this.primaryConnection.getId()));
        }
        if (this.secondaryConnection != null) {
            jsonObject.add("secondary", (JsonElement)new JsonPrimitive(this.secondaryConnection.getId()));
        }
        JsonArray array = new JsonArray();
        for (Parameter parameter : this.getParameters()) {
            array.add(ParameterTools.getJsonElement(parameter));
        }
        jsonObject.add("parameters", (JsonElement)array);
        return jsonObject;
    }

    public static GridInstance readFromJson(JsonElement element) {
        Opcode opcode;
        JsonObject gridObject = element.getAsJsonObject();
        String id = gridObject.get("id").getAsString();
        Builder builder = GridInstance.builder(id);
        if (gridObject.has("primary")) {
            String primary = gridObject.get("primary").getAsString();
            builder.primaryConnection(Connection.getConnection(primary));
        }
        if (gridObject.has("secondary")) {
            String secondary = gridObject.get("secondary").getAsString();
            builder.secondaryConnection(Connection.getConnection(secondary));
        }
        if ((opcode = Opcodes.OPCODES.get(id)) == null) {
            return null;
        }
        List parameters = opcode.getParameters();
        JsonArray parameterArray = gridObject.get("parameters").getAsJsonArray();
        for (int i = 0; i < parameterArray.size(); ++i) {
            JsonObject parObject = parameterArray.get(i).getAsJsonObject();
            Parameter parameter = ParameterTools.readFromJson(parObject);
            if (parameter.getParameterType() != ((ParameterDescription)parameters.get(i)).getType()) {
                builder.parameter(Parameter.builder().type(((ParameterDescription)parameters.get(i)).getType()).value(ParameterValue.constant(null)).build());
                continue;
            }
            builder.parameter(parameter);
        }
        return builder.build();
    }

    public CompoundTag writeToNBT(int x, int y) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", x);
        tag.m_128405_("y", y);
        tag.m_128359_("id", this.getId());
        if (this.primaryConnection != null) {
            tag.m_128359_("prim", this.primaryConnection.getId());
        }
        if (this.secondaryConnection != null) {
            tag.m_128359_("sec", this.secondaryConnection.getId());
        }
        ListTag parList = new ListTag();
        for (Parameter parameter : this.getParameters()) {
            CompoundTag nbt = ParameterTools.writeToNBT(parameter);
            parList.add((Object)nbt);
        }
        tag.m_128365_("pars", (Tag)parList);
        return tag;
    }

    public static GridInstance readFromNBT(CompoundTag tag) {
        Opcode opcode;
        String opcodeid = tag.m_128461_("id");
        Builder builder = GridInstance.builder(opcodeid);
        if (tag.m_128441_("prim")) {
            builder.primaryConnection(Connection.getConnection(tag.m_128461_("prim")));
        }
        if (tag.m_128441_("sec")) {
            builder.secondaryConnection(Connection.getConnection(tag.m_128461_("sec")));
        }
        if ((opcode = Opcodes.OPCODES.get(opcodeid)) == null) {
            return null;
        }
        List parameters = opcode.getParameters();
        ListTag parList = tag.m_128437_("pars", 10);
        for (int i = 0; i < parList.size(); ++i) {
            CompoundTag parTag = (CompoundTag)parList.get(i);
            Parameter parameter = ParameterTools.readFromNBT(parTag);
            if (parameter.getParameterType() != ((ParameterDescription)parameters.get(i)).getType()) {
                builder.parameter(Parameter.builder().type(((ParameterDescription)parameters.get(i)).getType()).value(ParameterValue.constant(null)).build());
                continue;
            }
            builder.parameter(parameter);
        }
        return builder.build();
    }

    public static class Builder {
        private final String id;
        private Connection primaryConnection;
        private Connection secondaryConnection;
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        public Builder(String id) {
            this.id = id;
        }

        public Builder primaryConnection(Connection primaryConnection) {
            this.primaryConnection = primaryConnection;
            return this;
        }

        public Builder secondaryConnection(Connection secondaryConnection) {
            this.secondaryConnection = secondaryConnection;
            return this;
        }

        public Builder parameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public GridInstance build() {
            return new GridInstance(this);
        }
    }
}

