/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.mixin.structures.PoolElementStructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MonumentPieces;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MonumentStructure
extends Structure {
    public static final Codec<MonumentStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MonumentStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("monument_type").forGetter(config -> config.monumentType), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(config -> config.biomeRadius), (App)Codec.INT.optionalFieldOf("fixed_y_spawn").forGetter(config -> config.fixedYSpawn), (App)Codec.FLOAT.optionalFieldOf("center_terrain_height_weight").forGetter(config -> config.centerTerrainHeightWeight)).apply((Applicative)instance, MonumentStructure::new));
    public final String monumentType;
    public final Optional<Integer> biomeRadius;
    public final Optional<Integer> fixedYSpawn;
    public final Optional<Float> centerTerrainHeightWeight;

    public MonumentStructure(Structure.StructureSettings config, String monumentType, Optional<Integer> biomeRadius, Optional<Integer> fixedYSpawn, Optional<Float> centerTerrainHeightWeight) {
        super(config);
        this.monumentType = monumentType.toLowerCase(Locale.ROOT);
        this.biomeRadius = biomeRadius;
        this.fixedYSpawn = fixedYSpawn;
        this.centerTerrainHeightWeight = centerTerrainHeightWeight;
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        ChunkPos chunkPos = context.f_226628_();
        if (this.biomeRadius.isPresent() && !(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = this.biomeRadius.get();
            for (int curChunkX = chunkPos.f_45578_ - validBiomeRange; curChunkX <= chunkPos.f_45578_ + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - validBiomeRange; curChunkZ <= chunkPos.f_45579_ + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)curChunkX), QuartPos.m_175400_((int)blockPos.m_123342_()), QuartPos.m_175404_((int)curChunkZ), context.f_226624_().m_224579_());
                    if (context.f_226630_().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int finalheight;
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        BlockPos centerPoint = chunkPos.m_151394_(0);
        if (this.fixedYSpawn.isPresent()) {
            finalheight = this.fixedYSpawn.get();
        } else {
            int centerHight;
            float centerWeight = this.centerTerrainHeightWeight.orElse(Float.valueOf(1.0f)).floatValue();
            int highestLandPos = centerHight = context.f_226622_().m_223235_(centerPoint.m_123341_(), centerPoint.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            highestLandPos = Math.min(highestLandPos, context.f_226622_().m_223235_(centerPoint.m_123341_() + 29, centerPoint.m_123343_() + 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()));
            highestLandPos = Math.min(highestLandPos, context.f_226622_().m_223235_(centerPoint.m_123341_() - 29, centerPoint.m_123343_() + 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()));
            highestLandPos = Math.min(highestLandPos, context.f_226622_().m_223235_(centerPoint.m_123341_() + 29, centerPoint.m_123343_() - 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()));
            highestLandPos = Math.min(highestLandPos, context.f_226622_().m_223235_(centerPoint.m_123341_() - 29, centerPoint.m_123343_() - 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()));
            finalheight = (int)((float)(highestLandPos - centerHight) / centerWeight) + centerHight;
        }
        if (finalheight <= context.f_226622_().m_142062_()) {
            return Optional.empty();
        }
        if (!this.extraSpawningChecks(context, chunkPos.m_151394_(finalheight))) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(chunkPos.m_151394_(finalheight), structurePiecesBuilder -> {
            List<StructurePiece> list = MonumentPieces.createMonumentBuilding(context.f_226621_(), context.f_226625_(), (RandomSource)random, centerPoint.m_123341_(), finalheight, centerPoint.m_123343_(), this.monumentType);
            Rotation rotation = Rotation.m_221990_((RandomSource)random);
            BlockPos mainOffset = new BlockPos(-29, 0, -29).m_7954_(rotation);
            for (StructurePiece structurePiece : list) {
                if (!(structurePiece instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)structurePiece;
                ((PoolElementStructurePieceAccessor)poolPiece).setRotation(poolPiece.m_6830_().m_55952_(rotation));
                BlockPos piecePos = poolPiece.m_72646_();
                BlockPos offsetPos = piecePos.m_121996_((Vec3i)centerPoint);
                BlockPos rotatedOffset = offsetPos.m_7954_(rotation);
                GeneralUtils.movePieceProperly((StructurePiece)poolPiece, rotatedOffset.m_123341_() - offsetPos.m_123341_(), 0, rotatedOffset.m_123343_() - offsetPos.m_123343_());
                GeneralUtils.movePieceProperly((StructurePiece)poolPiece, mainOffset.m_123341_(), 0, mainOffset.m_123343_());
                StructurePoolElement patt8162$temp = poolPiece.m_209918_();
                if (!(patt8162$temp instanceof SinglePoolElement)) continue;
                SinglePoolElement singlePoolElement = (SinglePoolElement)patt8162$temp;
                StructureTemplate structuretemplate = ((SinglePoolElementAccessor)singlePoolElement).callGetTemplate(context.f_226625_());
                ((StructurePieceAccessor)poolPiece).setBoundingBox(structuretemplate.m_74633_(new StructurePlaceSettings().m_74379_(rotation), poolPiece.m_72646_()));
            }
            list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        }));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)RSStructures.MONUMENT_STRUCTURE.get();
    }
}

