/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.server.ServerStoppedEvent;
import reliquary.api.IPedestalItemWrapper;

public class PedestalRegistry {
    private static final PedestalRegistry INSTANCE = new PedestalRegistry();
    private static final Map<LocationKey, BlockPos> positions = new HashMap<LocationKey, BlockPos>();
    private final Map<Class<? extends Item>, Supplier<? extends IPedestalItemWrapper>> itemWrappers = new HashMap<Class<? extends Item>, Supplier<? extends IPedestalItemWrapper>>();
    private final Map<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>> blockWrappers = new HashMap<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>>();

    public static void registerItemWrapper(Class<? extends Item> itemClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.itemWrappers.put(itemClass, wrapperClass);
    }

    public static void registerItemBlockWrapper(Class<? extends Block> blockClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.blockWrappers.put(blockClass, wrapperClass);
    }

    public static Optional<IPedestalItemWrapper> getItemWrapper(ItemStack item) {
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.itemWrappers.keySet()) {
            if (!clazz.isInstance(item.m_41720_())) continue;
            return Optional.of(PedestalRegistry.INSTANCE.itemWrappers.get(clazz).get());
        }
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.blockWrappers.keySet()) {
            BlockItem blockItem;
            Item item2 = item.m_41720_();
            if (!(item2 instanceof BlockItem) || !clazz.isInstance((blockItem = (BlockItem)item2).m_40614_())) continue;
            return Optional.of(PedestalRegistry.INSTANCE.blockWrappers.get(clazz).get());
        }
        return Optional.empty();
    }

    public static void registerPosition(ResourceLocation dimension, BlockPos pos) {
        LocationKey key = new LocationKey(dimension, pos.m_121878_());
        positions.putIfAbsent(key, pos);
    }

    public static void unregisterPosition(ResourceLocation dimension, BlockPos pos) {
        positions.remove(new LocationKey(dimension, pos.m_121878_()));
    }

    private static void clearPositions() {
        positions.clear();
    }

    public static List<BlockPos> getPositionsInRange(ResourceLocation dimension, BlockPos startPos, int range) {
        return PedestalRegistry.getPositionsInRange(dimension, startPos, range, range, range);
    }

    private static List<BlockPos> getPositionsInRange(ResourceLocation dimension, BlockPos startPos, int xRange, int yRange, int zRange) {
        ArrayList<BlockPos> positionsInRange = new ArrayList<BlockPos>();
        for (Map.Entry<LocationKey, BlockPos> position : positions.entrySet()) {
            BlockPos pos;
            if (!position.getKey().getDimension().equals((Object)dimension) || (pos = position.getValue()).m_123341_() < startPos.m_123341_() - xRange || pos.m_123341_() > startPos.m_123341_() + xRange || pos.m_123342_() < startPos.m_123342_() - yRange || pos.m_123342_() > startPos.m_123342_() + yRange || pos.m_123343_() < startPos.m_123343_() - zRange || pos.m_123343_() > startPos.m_123343_() + zRange) continue;
            positionsInRange.add(pos);
        }
        return positionsInRange;
    }

    public static void serverStopping(ServerStoppedEvent event) {
        PedestalRegistry.clearPositions();
    }

    private record LocationKey(ResourceLocation dimension, long location) {
        @Override
        public int hashCode() {
            return Objects.hash(this.dimension, this.location);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LocationKey)) {
                return false;
            }
            LocationKey key2 = (LocationKey)o;
            return this.getDimension().equals((Object)key2.getDimension()) && this.getLocation() == key2.getLocation();
        }

        ResourceLocation getDimension() {
            return this.dimension;
        }

        public long getLocation() {
            return this.location;
        }
    }
}

