/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PacketFXThrownPotionImpact {
    private final int color;
    private final double posX;
    private final double posY;
    private final double posZ;

    public PacketFXThrownPotionImpact(int color, double x, double y, double z) {
        this.color = color;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    static void encode(PacketFXThrownPotionImpact msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.color);
        packetBuffer.writeDouble(msg.posX);
        packetBuffer.writeDouble(msg.posY);
        packetBuffer.writeDouble(msg.posZ);
    }

    static PacketFXThrownPotionImpact decode(FriendlyByteBuf packetBuffer) {
        return new PacketFXThrownPotionImpact(packetBuffer.readInt(), packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
    }

    static void onMessage(PacketFXThrownPotionImpact msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketFXThrownPotionImpact.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(PacketFXThrownPotionImpact message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        int color = message.color;
        RandomSource rand = mc.f_91073_.f_46441_;
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color & 0xFF) / 256.0f;
        for (int i = 0; i < 100; ++i) {
            double var39 = rand.m_188500_() * 4.0;
            double angle = rand.m_188500_() * Math.PI * 2.0;
            double xSpeed = Math.cos(angle) * var39;
            double ySpeed = 0.01 + rand.m_188500_() * 0.5;
            double zSpeed = Math.sin(angle) * var39;
            Particle particle = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123806_, message.posX + xSpeed * 0.1, message.posY + 0.3, message.posZ + zSpeed * 0.1, xSpeed, ySpeed, zSpeed);
            if (particle == null) continue;
            float var32 = 0.75f + rand.m_188501_() * 0.25f;
            particle.m_107253_(red * var32, green * var32, blue * var32);
            particle.m_107268_((float)var39);
        }
    }
}

