/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import reliquary.blocks.FertileLilyPadBlock;
import reliquary.entities.EntityXRFakePlayer;
import reliquary.init.ModCapabilities;
import reliquary.items.ToggleableItem;
import reliquary.items.util.HarvestRodCache;
import reliquary.items.util.HarvestRodItemStackHandler;
import reliquary.items.util.IHarvestRodCache;
import reliquary.items.util.IScrollableItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.ItemHelper;
import reliquary.util.NBTHelper;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.XRFakePlayerFactory;

public class HarvestRodItem
extends ToggleableItem
implements IScrollableItem {
    private static final String MODE_NBT_TAG = "mode";
    private static final String PLANTABLE_INDEX_NBT_TAG = "plantable_index";
    private static final int AOE_START_COOLDOWN = 10;

    public HarvestRodItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).m_130940_(ChatFormatting.DARK_GREEN);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack rod, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", this.getBoneMealCount(rod, true));
        for (int slot = 1; slot < this.getCountPlantable(rod, true); ++slot) {
            ItemStack plantable = this.getPlantableInSlot(rod, slot, true);
            tooltipBuilder.charge((Item)this, ".tooltip3", plantable.m_41720_().m_7626_(plantable).getString(), this.getPlantableQuantity(rod, slot, true));
        }
        if (this.isEnabled(rod)) {
            tooltipBuilder.absorbActive(new ItemStack((ItemLike)Items.f_42499_).m_41786_().getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    private int getBonemealLimit() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealLimit.get();
    }

    private int getBonemealWorth() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealWorth.get();
    }

    public int getBonemealCost() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealCost.get();
    }

    public int getLuckRolls() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealLuckRolls.get();
    }

    public int getLuckPercent() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealLuckPercentChance.get();
    }

    private int getBreakRadius() {
        return (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilitySerializable<CompoundTag>(){
            final HarvestRodItemStackHandler itemHandler = new HarvestRodItemStackHandler();
            final IHarvestRodCache harvestRodCache = new HarvestRodCache();

            public CompoundTag serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(CompoundTag tagCompound) {
                this.itemHandler.deserializeNBT(tagCompound);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this.itemHandler));
                }
                if (capability == ModCapabilities.HARVEST_ROD_CACHE) {
                    return ModCapabilities.HARVEST_ROD_CACHE.orEmpty(capability, LazyOptional.of(() -> this.harvestRodCache));
                }
                return LazyOptional.empty();
            }
        };
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || world.m_46467_() % 10L != 0L || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isEnabled(stack)) {
            int currentCharge = this.getBoneMealCount(stack);
            this.consumeAndCharge(player, this.getBonemealLimit() - currentCharge, this.getBonemealWorth(), Items.f_42499_, 16, (int chargeToAdd) -> this.setBoneMealCount(stack, currentCharge + chargeToAdd));
            this.consumePlantables(stack, player);
        }
    }

    private void consumePlantables(ItemStack harvestRod, Player player) {
        int leftToInsert = 16;
        for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
            ItemStack currentStack = (ItemStack)player.m_150109_().f_35974_.get(slot);
            if (!this.isPlantable(currentStack)) continue;
            int countInserted = this.incrementPlantable(harvestRod, currentStack, leftToInsert);
            currentStack.m_41774_(countInserted);
            player.m_150109_().f_35974_.set(slot, (Object)(currentStack.m_41619_() ? ItemStack.f_41583_ : currentStack));
            if ((leftToInsert -= countInserted) == 0) break;
        }
    }

    private boolean isPlantable(ItemStack currentStack) {
        BlockItem blockItem;
        Item item = currentStack.m_41720_();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof IPlantable;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.f_19853_.f_46443_) {
            return false;
        }
        boolean brokenBlock = false;
        Block block = player.f_19853_.m_8055_(pos).m_60734_();
        if (block instanceof IPlantable || block == Blocks.f_50186_ || block == Blocks.f_50133_) {
            for (int xOff = -this.getBreakRadius(); xOff <= this.getBreakRadius(); ++xOff) {
                for (int yOff = -this.getBreakRadius(); yOff <= this.getBreakRadius(); ++yOff) {
                    for (int zOff = -this.getBreakRadius(); zOff <= this.getBreakRadius(); ++zOff) {
                        brokenBlock |= this.doHarvestBlockBreak(block, stack, pos, player, xOff, yOff, zOff);
                    }
                }
            }
        }
        return brokenBlock;
    }

    private boolean doHarvestBlockBreak(Block initialBlock, ItemStack stack, BlockPos pos, Player player, int xOff, int yOff, int zOff) {
        pos = pos.m_7918_(xOff, yOff, zOff);
        BlockState blockState = player.f_19853_.m_8055_(pos);
        Block block = blockState.m_60734_();
        if ((initialBlock == Blocks.f_50186_ || initialBlock == Blocks.f_50133_) && block != Blocks.f_50186_ && block != Blocks.f_50133_) {
            return false;
        }
        if (!(block instanceof IPlantable) && block != Blocks.f_50186_ && block != Blocks.f_50133_) {
            return false;
        }
        if (block instanceof FertileLilyPadBlock) {
            return false;
        }
        if (player.f_19853_.f_46443_) {
            for (int particles = 0; particles <= 8; ++particles) {
                player.f_19853_.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)blockState));
            }
        } else {
            Level particles = player.f_19853_;
            if (particles instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)particles;
                List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
                for (ItemStack itemStack : drops) {
                    float f = 0.7f;
                    double d = (double)(serverLevel.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(serverLevel.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(serverLevel.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
                    ItemEntity entityitem = new ItemEntity(player.f_19853_, (double)pos.m_123341_() + d, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemStack);
                    entityitem.m_32010_(10);
                    player.f_19853_.m_7967_((Entity)entityitem);
                }
                player.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                player.m_36246_(Stats.f_12949_.m_12902_((Object)blockState.m_60734_()));
                player.m_36399_(0.01f);
            }
        }
        return true;
    }

    private void boneMealBlock(ItemStack stack, Player player, Level world, BlockPos pos) {
        ItemStack fakeItemStack = new ItemStack((ItemLike)Items.f_42499_);
        boolean usedRod = false;
        for (int repeatedUses = 0; repeatedUses <= this.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && world.f_46441_.m_188503_(100) > this.getLuckPercent() || !BoneMealItem.applyBonemeal((ItemStack)fakeItemStack, (Level)world, (BlockPos)pos, (Player)player)) continue;
            if (!usedRod) {
                usedRod = true;
            }
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.NEUTRAL, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
        }
        if (usedRod && !player.m_7500_()) {
            this.setBoneMealCount(stack, this.getBoneMealCount(stack) - this.getBonemealCost());
        }
    }

    public int getBoneMealCount(ItemStack stack) {
        return this.getBoneMealCount(stack, false);
    }

    public int getBoneMealCount(ItemStack stack, boolean isClient) {
        if (isClient) {
            return NBTHelper.getContainedStackCount(stack, 0);
        }
        return this.getFromHandler(stack, HarvestRodItemStackHandler::getBoneMealCount).orElse(0);
    }

    private <T> Optional<T> getFromHandler(ItemStack harvestRod, Function<HarvestRodItemStackHandler, T> get) {
        return InventoryHelper.getFromHandler(harvestRod, get, HarvestRodItemStackHandler.class);
    }

    private void runOnHandler(ItemStack harvestRod, Consumer<HarvestRodItemStackHandler> run) {
        InventoryHelper.runOnItemHandler(harvestRod, run, HarvestRodItemStackHandler.class);
    }

    public void setBoneMealCount(ItemStack harvestRod, int boneMealCount) {
        this.runOnHandler(harvestRod, h -> {
            h.setBoneMealCount(boneMealCount);
            this.updateContainedItemNBT(harvestRod, (short)0, ItemStack.f_41583_, boneMealCount);
        });
    }

    private int incrementPlantable(ItemStack harvestRod, ItemStack plantable, int maxCount) {
        return this.getFromHandler(harvestRod, h -> {
            ItemStack plantableCopy = plantable.m_41777_();
            plantableCopy.m_41764_(Math.min(maxCount, plantableCopy.m_41613_()));
            return h.insertPlantable(plantableCopy).map(plantableSlotInserted -> {
                this.updateContainedItemNBT(harvestRod, (short)plantableSlotInserted.getSlot(), plantableCopy, this.getPlantableQuantity(harvestRod, plantableSlotInserted.getSlot()));
                return plantableSlotInserted.getCountInserted();
            }).orElse(0);
        }).orElse(0);
    }

    private void updateContainedItemNBT(ItemStack harvestRod, short slot, ItemStack stack, int count) {
        NBTHelper.updateContainedStack(harvestRod, slot, stack, count);
    }

    private void decrementPlantable(ItemStack harvestRod, byte slot) {
        this.getFromHandler(harvestRod, h -> h.getStackInSlot(slot).m_41613_()).flatMap(amount -> this.setPlantableQuantityAndGetPlantableStack(harvestRod, slot, amount - 1)).ifPresent(plantable -> this.updateContainedItemNBT(harvestRod, slot, (ItemStack)plantable, plantable.m_41613_()));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            return super.m_7203_(world, player, hand);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    void toggleEnabled(ItemStack stack) {
        super.toggleEnabled(stack);
        this.updateContainedStacks(stack);
    }

    public int m_8105_(ItemStack stack) {
        return 300;
    }

    public void m_5551_(ItemStack harvestRod, Level world, LivingEntity entity, int timeLeft) {
        if (entity.f_19853_.f_46443_ || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        BlockHitResult result = HarvestRodItem.m_41435_((Level)player.f_19853_, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            harvestRod.getCapability(ModCapabilities.HARVEST_ROD_CACHE, null).ifPresent(IHarvestRodCache::reset);
            BlockPos pos = result.m_82425_();
            switch (this.getMode(harvestRod)) {
                case BONE_MEAL: {
                    if (this.getBoneMealCount(harvestRod) < this.getBonemealCost() && !player.m_7500_()) break;
                    this.boneMealBlock(harvestRod, player, world, pos);
                    break;
                }
                case PLANTABLE: {
                    if (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) <= 0 && !player.m_7500_()) break;
                    this.plantItem(harvestRod, player, pos, player.m_7655_());
                    break;
                }
                case HOE: {
                    this.hoeLand(world, pos);
                    break;
                }
            }
        } else {
            this.removeStackFromCurrent(harvestRod, player);
        }
    }

    private void hoeLand(Level world, BlockPos pos) {
        ItemStack fakeHoe = new ItemStack((ItemLike)Items.f_42424_);
        EntityXRFakePlayer fakePlayer = XRFakePlayerFactory.get((ServerLevel)world);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, fakeHoe);
        if (Items.f_42424_.m_6225_(ItemHelper.getItemUseContext(pos, (Player)fakePlayer)) == InteractionResult.SUCCESS) {
            world.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void removeStackFromCurrent(ItemStack stack, Player player) {
        if (this.getMode(stack) == Mode.BONE_MEAL && this.getBoneMealCount(stack) > 0) {
            ItemStack boneMealStack = new ItemStack((ItemLike)Items.f_42499_);
            int numberToAdd = Math.min(boneMealStack.m_41741_(), this.getBoneMealCount(stack));
            int numberAdded = InventoryHelper.getItemHandlerFrom(player).map(handler -> InventoryHelper.tryToAddToInventory(boneMealStack, handler, numberToAdd)).orElse(0);
            this.setBoneMealCount(stack, this.getBoneMealCount(stack) - numberAdded);
        } else if (this.getMode(stack) == Mode.PLANTABLE) {
            byte plantableSlot = this.getCurrentPlantableSlot(stack);
            ItemStack plantableStack = this.getCurrentPlantable(stack);
            int plantableQuantity = this.getPlantableQuantity(stack, plantableSlot);
            int numberToAdd = Math.min(plantableStack.m_41741_(), plantableQuantity);
            int numberAdded = InventoryHelper.getItemHandlerFrom(player).map(handler -> InventoryHelper.tryToAddToInventory(plantableStack, handler, numberToAdd)).orElse(0);
            int updatedPlantableQuantity = this.getPlantableQuantity(stack, plantableSlot) - numberAdded;
            this.setPlantableQuantity(stack, plantableSlot, updatedPlantableQuantity);
        }
    }

    private void shiftModeOnEmptyPlantable(ItemStack harvestRod, byte plantableSlot) {
        if (plantableSlot > 0) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(plantableSlot - 1));
        }
        this.cycleMode(harvestRod, true);
    }

    private void plantItem(ItemStack harvestRod, Player player, BlockPos pos, InteractionHand hand) {
        byte plantableSlot = this.getCurrentPlantableSlot(harvestRod);
        ItemStack fakePlantableStack = this.getCurrentPlantable(harvestRod).m_41777_();
        fakePlantableStack.m_41764_(1);
        EntityXRFakePlayer fakePlayer = XRFakePlayerFactory.get((ServerLevel)player.f_19853_);
        fakePlayer.m_21008_(hand, fakePlantableStack);
        if (fakePlantableStack.m_41661_(ItemHelper.getItemUseContext(pos, (Player)fakePlayer)).m_19077_()) {
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
            if (!player.m_7500_()) {
                this.decrementPlantable(harvestRod, plantableSlot);
            }
        }
    }

    private ItemStack getCurrentPlantable(ItemStack harvestRod) {
        return this.getCurrentPlantable(harvestRod, false);
    }

    public ItemStack getCurrentPlantable(ItemStack harvestRod, boolean isClient) {
        byte currentSlot = this.getCurrentPlantableSlot(harvestRod);
        if (isClient) {
            return NBTHelper.getContainedStack(harvestRod, currentSlot);
        }
        return this.getPlantableInSlot(harvestRod, currentSlot);
    }

    public ItemStack getPlantableInSlot(ItemStack harvestRod, int slot) {
        return this.getPlantableInSlot(harvestRod, slot, false);
    }

    private ItemStack getPlantableInSlot(ItemStack harvestRod, int slot, boolean isClient) {
        if (isClient) {
            return NBTHelper.getContainedStack(harvestRod, slot);
        }
        return this.getFromHandler(harvestRod, h -> h.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public void onUsingTick(ItemStack harvestRod, LivingEntity entity, int count) {
        BlockHitResult result;
        if (entity.f_19853_.f_46443_ || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isCoolDownOver(harvestRod, count) && (result = HarvestRodItem.m_41435_((Level)player.f_19853_, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY)).m_6662_() == HitResult.Type.BLOCK) {
            Level world = player.f_19853_;
            harvestRod.getCapability(ModCapabilities.HARVEST_ROD_CACHE, null).ifPresent(cache -> this.doAction(harvestRod, player, world, (IHarvestRodCache)cache, result.m_82425_()));
        }
    }

    private void doAction(ItemStack harvestRod, Player player, Level world, IHarvestRodCache cache, BlockPos pos) {
        switch (this.getMode(harvestRod)) {
            case BONE_MEAL: {
                if (this.getBoneMealCount(harvestRod) < this.getBonemealCost() && !player.m_7500_()) break;
                this.getNextBlockToBoneMeal(world, cache, pos, (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get()).ifPresent(blockToBoneMeal -> this.boneMealBlock(harvestRod, player, world, (BlockPos)blockToBoneMeal));
                break;
            }
            case PLANTABLE: {
                if (this.getCountPlantable(harvestRod) > 0) {
                    this.clearPlantableIfNoLongerValid(harvestRod, this.getCurrentPlantableSlot(harvestRod));
                }
                if (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) < 1 && !player.m_7500_()) break;
                this.getNextBlockToPlantOn(world, cache, pos, (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get(), (IPlantable)((BlockItem)this.getCurrentPlantable(harvestRod).m_41720_()).m_40614_()).ifPresent(blockToPlantOn -> this.plantItem(harvestRod, player, (BlockPos)blockToPlantOn, player.m_7655_()));
                break;
            }
            case HOE: {
                this.getNextBlockToHoe(world, cache, pos, (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get()).ifPresent(blockToHoe -> this.hoeLand(world, (BlockPos)blockToHoe));
                break;
            }
        }
    }

    public void clearPlantableIfNoLongerValid(ItemStack harvestRod, byte slot) {
        if (this.getPlantableInSlot(harvestRod, slot).m_41619_()) {
            this.setPlantableQuantityAndGetPlantableStack(harvestRod, slot, 0);
        }
    }

    private Optional<BlockPos> getNextBlockToHoe(Level world, IHarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueue(cache, pos, range, currentPos -> {
                BlockState blockState = world.m_8055_(currentPos);
                Block block = blockState.m_60734_();
                return world.m_46859_(currentPos.m_7494_()) && (block == Blocks.f_50440_ || block == Blocks.f_152481_ || block == Blocks.f_50493_ || block == Blocks.f_50546_);
            });
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueue(IHarvestRodCache cache, BlockPos pos, int range, Predicate<BlockPos> isValidBlock) {
        cache.setStartBlockPos(pos);
        cache.clearBlockQueue();
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(currentPos -> {
            if (isValidBlock.test((BlockPos)currentPos)) {
                cache.addBlockToQueue(currentPos.m_7949_());
            }
        });
    }

    private Optional<BlockPos> getNextBlockToPlantOn(Level world, IHarvestRodCache cache, BlockPos pos, int range, IPlantable plantable) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueueToPlant(world, cache, pos, range, plantable);
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueueToPlant(Level world, IHarvestRodCache cache, BlockPos pos, int range, IPlantable plantable) {
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable == Blocks.f_50189_ || plantable == Blocks.f_50190_) {
            checkerboard = true;
            boolean xEven = pos.m_123341_() % 2 == 0;
            boolean zEven = pos.m_123343_() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        boolean finalCheckerboard = checkerboard;
        boolean finalBothOddOrEven = bothOddOrEven;
        this.fillQueue(cache, pos, range, currentPos -> {
            BlockState blockState = world.m_8055_(currentPos);
            return (!finalCheckerboard || finalBothOddOrEven == (currentPos.m_123341_() % 2 == 0 == (currentPos.m_123343_() % 2 == 0))) && blockState.m_60734_().canSustainPlant(blockState, (BlockGetter)world, pos, Direction.UP, plantable) && world.m_46859_(currentPos.m_7494_());
        });
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    private boolean isCoolDownOver(ItemStack stack, int count) {
        return this.m_8105_(stack) - count >= 10 && (this.m_8105_(stack) - count) % (Integer)Settings.COMMON.items.harvestRod.aoeCooldown.get() == 0;
    }

    private Optional<BlockPos> getNextBlockToBoneMeal(Level world, IHarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueue(cache, pos, range, currentPos -> {
                BonemealableBlock bonemealableBlock;
                BlockState blockState = world.m_8055_(currentPos);
                Block patt22109$temp = blockState.m_60734_();
                return patt22109$temp instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)patt22109$temp).m_7370_((BlockGetter)world, currentPos, blockState, world.f_46443_);
            });
        }
        return cache.getNextBlockInQueue();
    }

    private void cycleMode(ItemStack harvestRod, boolean next) {
        Mode currentMode = this.getMode(harvestRod);
        int plantableCount = this.getCountPlantable(harvestRod);
        if (next) {
            this.setNextMode(harvestRod, currentMode, plantableCount);
        } else {
            this.setPreviousMode(harvestRod, currentMode, plantableCount);
        }
    }

    private void setPreviousMode(ItemStack harvestRod, Mode currentMode, int plantableCount) {
        if (currentMode == Mode.PLANTABLE && this.getCurrentPlantableSlot(harvestRod) > 1) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(this.getCurrentPlantableSlot(harvestRod) - 1));
            return;
        }
        Mode previousMode = currentMode.previous();
        if (previousMode == Mode.PLANTABLE) {
            if (plantableCount == 0) {
                previousMode = previousMode.previous();
            } else {
                this.setCurrentPlantableSlot(harvestRod, (byte)plantableCount);
            }
        }
        this.setMode(harvestRod, previousMode);
    }

    private void setNextMode(ItemStack harvestRod, Mode currentMode, int plantableCount) {
        if (currentMode == Mode.PLANTABLE && plantableCount > this.getCurrentPlantableSlot(harvestRod)) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(this.getCurrentPlantableSlot(harvestRod) + 1));
            return;
        }
        Mode nextMode = currentMode.next();
        if (nextMode == Mode.PLANTABLE) {
            if (plantableCount == 0) {
                nextMode = nextMode.next();
            } else {
                this.setCurrentPlantableSlot(harvestRod, (byte)1);
            }
        }
        this.setMode(harvestRod, nextMode);
    }

    public int getCountPlantable(ItemStack harvestRod) {
        return this.getCountPlantable(harvestRod, false);
    }

    private int getCountPlantable(ItemStack harvestRod, boolean isClient) {
        if (isClient) {
            return NBTHelper.getCountContainedStacks(harvestRod);
        }
        return this.getFromHandler(harvestRod, HarvestRodItemStackHandler::getCountPlantable).orElse(0);
    }

    public byte getCurrentPlantableSlot(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128445_(PLANTABLE_INDEX_NBT_TAG) : (byte)-1;
    }

    private void setCurrentPlantableSlot(ItemStack stack, byte index) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128344_(PLANTABLE_INDEX_NBT_TAG, index);
            this.updateContainedStacks(stack);
        }
    }

    private void setMode(ItemStack stack, Mode mode) {
        NBTHelper.putString(MODE_NBT_TAG, stack, mode.m_7912_());
        this.updateContainedStacks(stack);
    }

    public void updateContainedStacks(ItemStack stack) {
        NBTHelper.removeContainedStacks(stack);
        NBTHelper.updateContainedStack(stack, (short)0, ItemStack.f_41583_, this.getBoneMealCount(stack));
        for (short slot = 1; slot < this.getCountPlantable(stack) + 1; slot = (short)(slot + 1)) {
            NBTHelper.updateContainedStack(stack, slot, this.getPlantableInSlot(stack, slot), this.getPlantableQuantity(stack, slot));
        }
    }

    public Mode getMode(ItemStack stack) {
        return NBTHelper.getEnumConstant(stack, MODE_NBT_TAG, Mode::valueOf).orElse(Mode.BONE_MEAL);
    }

    public int getPlantableQuantity(ItemStack harvestRod, int parentSlot) {
        return this.getPlantableQuantity(harvestRod, parentSlot, false);
    }

    public int getPlantableQuantity(ItemStack harvestRod, int slot, boolean isClient) {
        if (isClient) {
            return NBTHelper.getContainedStackCount(harvestRod, slot);
        }
        return this.getFromHandler(harvestRod, h -> h.getTotalAmount(slot)).orElse(0);
    }

    public Optional<ItemStack> setPlantableQuantityAndGetPlantableStack(ItemStack harvestRod, byte plantableSlot, int quantity) {
        this.runOnHandler(harvestRod, h -> h.setTotalCount(plantableSlot, quantity));
        if (quantity == 0) {
            this.shiftModeOnEmptyPlantable(harvestRod, plantableSlot);
            return Optional.empty();
        }
        return this.getFromHandler(harvestRod, h -> h.getStackInSlot(plantableSlot));
    }

    private void setPlantableQuantity(ItemStack harvestRod, byte plantableSlot, int quantity) {
        this.setPlantableQuantityAndGetPlantableStack(harvestRod, plantableSlot, quantity).ifPresent(plantableStack -> this.updateContainedItemNBT(harvestRod, plantableSlot, (ItemStack)plantableStack, plantableStack.m_41613_()));
    }

    public static enum Mode implements StringRepresentable
    {
        BONE_MEAL,
        PLANTABLE,
        HOE;

        private static final Mode[] VALUES;

        public String m_7912_() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.m_7912_(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

