/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.alkahestry;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import reliquary.compat.jei.alkahestry.AlkahestryRecipeCategory;
import reliquary.crafting.AlkahestryCraftingRecipe;
import reliquary.init.ModItems;
import reliquary.items.AlkahestryTomeItem;
import reliquary.reference.Reference;
import reliquary.reference.Settings;

public class AlkahestryCraftingRecipeCategory
extends AlkahestryRecipeCategory<AlkahestryCraftingRecipe> {
    public static final RecipeType<AlkahestryCraftingRecipe> TYPE = RecipeType.create((String)"reliquary", (String)"alkahestry_crafting", AlkahestryCraftingRecipe.class);
    private final IDrawable background;
    private final Component localizedName;

    public AlkahestryCraftingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png"), 0, 0, 95, 76);
        this.localizedName = Component.m_237115_((String)"jei.reliquary.recipe.alkahest_crafting");
    }

    public RecipeType<AlkahestryCraftingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlkahestryCraftingRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredientsInputs = recipe.m_7527_();
        ItemStack input = ((Ingredient)ingredientsInputs.get(0)).m_43908_()[0];
        ItemStack tome = ((Ingredient)ingredientsInputs.get(1)).m_43908_()[0];
        ItemStack output = recipe.m_8043_();
        ItemStack tomeOutput = AlkahestryTomeItem.setCharge(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), (Integer)Settings.COMMON.items.alkahestryTome.chargeLimit.get() - recipe.getChargeNeeded());
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStack(input);
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addItemStack(tome);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 10).addItemStack(output);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 19, 60).addItemStack(tomeOutput);
    }

    public void draw(AlkahestryCraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        String chargeString = "-" + recipe.getChargeNeeded();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92895_(chargeString);
        fontRenderer.m_92883_(poseStack, chargeString, (float)(((double)this.background.getWidth() - (double)stringWidth) / 2.0), 40.0f, -8355712);
    }
}

