/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.init;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.init.ModItems;
import reliquary.items.BulletItem;
import reliquary.items.MobCharmFragmentItem;
import reliquary.items.MobCharmItem;
import reliquary.items.VoidTearItem;
import reliquary.items.util.IPotionItem;
import reliquary.util.NBTHelper;

@OnlyIn(value=Dist.CLIENT)
public class ModItemColors {
    private ModItemColors() {
    }

    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ModItemColors.registerMobCharmItemColors(event);
        ModItemColors.registerBulletItemColors(event);
        ModItemColors.registerPotionItemColors(event);
        ModItemColors.registerVoidTearItemColors(event);
    }

    private static void registerVoidTearItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            ItemStack containedStack;
            if (Screen.m_96638_() && !(containedStack = VoidTearItem.getTearContents(stack, true)).m_41619_()) {
                return Minecraft.m_91087_().getItemColors().m_92676_(containedStack, tintIndex);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.VOID_TEAR.get()});
    }

    private static void registerPotionItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> ModItemColors.getColor(stack), new ItemLike[]{(ItemLike)ModItems.POTION_ESSENCE.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                if (NBTHelper.getInt("renderColor", stack) > 0) {
                    return NBTHelper.getInt("renderColor", stack);
                }
                List<MobEffectInstance> effects = ((IPotionItem)stack.m_41720_()).getEffects(stack);
                if (effects.isEmpty()) {
                    return -1;
                }
                return PotionUtils.m_43564_(effects);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.POTION.get(), (ItemLike)ModItems.SPLASH_POTION.get(), (ItemLike)ModItems.LINGERING_POTION.get()});
        event.register((stack, tintIndex) -> tintIndex == 0 ? PotionUtils.m_43564_(((IPotionItem)stack.m_41720_()).getEffects(stack)) : -1, new ItemLike[]{(ItemLike)ModItems.TIPPED_ARROW.get()});
    }

    private static void registerBulletItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return -1;
            }
            if (tintIndex == 1) {
                return ((BulletItem)stack.m_41720_()).getColor();
            }
            if (tintIndex == 2) {
                return PotionUtils.m_43564_(((IPotionItem)stack.m_41720_()).getEffects(stack));
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.EMPTY_MAGAZINE.get(), (ItemLike)ModItems.NEUTRAL_MAGAZINE.get(), (ItemLike)ModItems.EXORCISM_MAGAZINE.get(), (ItemLike)ModItems.BLAZE_MAGAZINE.get(), (ItemLike)ModItems.ENDER_MAGAZINE.get(), (ItemLike)ModItems.CONCUSSIVE_MAGAZINE.get(), (ItemLike)ModItems.BUSTER_MAGAZINE.get(), (ItemLike)ModItems.SEEKER_MAGAZINE.get(), (ItemLike)ModItems.SAND_MAGAZINE.get(), (ItemLike)ModItems.STORM_MAGAZINE.get(), (ItemLike)ModItems.EMPTY_BULLET.get(), (ItemLike)ModItems.NEUTRAL_BULLET.get(), (ItemLike)ModItems.EXORCISM_BULLET.get(), (ItemLike)ModItems.BLAZE_BULLET.get(), (ItemLike)ModItems.ENDER_BULLET.get(), (ItemLike)ModItems.CONCUSSIVE_BULLET.get(), (ItemLike)ModItems.BUSTER_BULLET.get(), (ItemLike)ModItems.SEEKER_BULLET.get(), (ItemLike)ModItems.SAND_BULLET.get(), (ItemLike)ModItems.STORM_BULLET.get()});
    }

    private static void registerMobCharmItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex < 1 || tintIndex > 2) {
                return -1;
            }
            ResourceLocation entityName = MobCharmItem.getEntityEggRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 1 ? egg.m_43211_(0) : egg.m_43211_(1)).orElse(-1);
        }, new ItemLike[]{(ItemLike)ModItems.MOB_CHARM.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex < 0 || tintIndex > 1) {
                return -1;
            }
            ResourceLocation entityName = MobCharmFragmentItem.getEntityEggRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 0 ? egg.m_43211_(0) : egg.m_43211_(1)).orElse(-1);
        }, new ItemLike[]{(ItemLike)ModItems.MOB_CHARM_FRAGMENT.get()});
    }

    private static Optional<SpawnEggItem> getEgg(ResourceLocation entityName) {
        return Optional.ofNullable(ForgeSpawnEggItem.fromEntityType((EntityType)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityName))));
    }

    private static int getColor(ItemStack stack) {
        return PotionUtils.m_43564_(((IPotionItem)stack.m_41720_()).getEffects(stack));
    }
}

