/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class SetFluidFilterSlotMessage {
    private final int containerSlot;
    private final FluidStack stack;

    public SetFluidFilterSlotMessage(int containerSlot, FluidStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public static SetFluidFilterSlotMessage decode(FriendlyByteBuf buf) {
        return new SetFluidFilterSlotMessage(buf.readInt(), FluidStack.readFromPacket((FriendlyByteBuf)buf));
    }

    public static void encode(SetFluidFilterSlotMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.containerSlot);
        message.stack.writeToPacket(buf);
    }

    public static void handle(SetFluidFilterSlotMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player;
        if (!message.stack.isEmpty() && (player = ctx.get().getSender()) != null) {
            ctx.get().enqueueWork(() -> SetFluidFilterSlotMessage.lambda$handle$0((Player)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static void handle(SetFluidFilterSlotMessage message, AbstractContainerMenu container) {
        Slot slot = container.m_38853_(message.containerSlot);
        if (slot instanceof FluidFilterSlot) {
            IGrid grid;
            Runnable postAction = () -> {};
            if (container instanceof GridContainerMenu && (grid = ((GridContainerMenu)container).getGrid()) instanceof GridNetworkNode && slot.getSlotIndex() < ((GridNetworkNode)grid).getAllowedTagList().getAllowedFluidTags().size()) {
                HashSet list = new HashSet(((GridNetworkNode)grid).getAllowedTagList().getAllowedFluidTags().get(slot.getSlotIndex()));
                postAction = () -> {
                    ((GridNetworkNode)grid).getAllowedTagList().setAllowedFluidTags(slot.getSlotIndex(), list);
                    ((GridNetworkNode)grid).markDirty();
                };
            }
            FluidFilterSlot fluidSlot = (FluidFilterSlot)slot;
            fluidSlot.getFluidInventory().setFluid(slot.getSlotIndex(), message.stack);
            postAction.run();
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, SetFluidFilterSlotMessage message) {
        AbstractContainerMenu container = player.f_36096_;
        if (container != null && message.containerSlot >= 0 && message.containerSlot < container.f_38839_.size()) {
            SetFluidFilterSlotMessage.handle(message, container);
        }
    }
}

