/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.StorageMonitorBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.RedstoneMode;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class StorageMonitorNetworkNode
extends NetworkNode
implements IComparable,
IType {
    public static final int DEPOSIT_ALL_MAX_DELAY = 500;
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "storage_monitor");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private final BaseItemHandler itemFilter = new BaseItemHandler(1).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading) {
            LevelUtils.updateBlock(this.level, this.pos);
        }
    });
    private final FluidInventory fluidFilter = new FluidInventory(1, 1000).addListener((handler, slot, reading) -> {
        if (!reading) {
            LevelUtils.updateBlock(this.level, this.pos);
        }
    });
    private final Map<String, Pair<ItemStack, Long>> deposits = new HashMap<String, Pair<ItemStack, Long>>();
    private int compare = 1;
    private int type = 0;
    private int oldAmount = -1;

    public StorageMonitorNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public void update() {
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        int newAmount = this.getAmount();
        if (this.oldAmount == -1) {
            this.oldAmount = newAmount;
        } else if (this.oldAmount != newAmount) {
            this.oldAmount = newAmount;
            LevelUtils.updateBlock(this.level, this.pos);
        }
    }

    public InteractionResult depositAll(Player player) {
        if (this.getType() != 0) {
            return InteractionResult.FAIL;
        }
        if (this.network == null) {
            return InteractionResult.FAIL;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return InteractionResult.FAIL;
        }
        Pair<ItemStack, Long> deposit = this.deposits.get(player.m_36316_().getName());
        if (deposit == null) {
            return InteractionResult.FAIL;
        }
        ItemStack inserted = (ItemStack)deposit.getKey();
        long insertedAt = (Long)deposit.getValue();
        if (System.currentTimeMillis() - insertedAt < 500L) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack toInsert = player.m_150109_().m_8020_(i);
                if (!API.instance().getComparer().isEqual(inserted, toInsert, this.compare)) continue;
                player.m_150109_().m_6836_(i, this.network.insertItemTracked(toInsert, toInsert.m_41613_()));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult deposit(Player player, ItemStack toInsert) {
        if (this.network == null) {
            return InteractionResult.FAIL;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return InteractionResult.FAIL;
        }
        if (this.getType() == 0) {
            this.depositItems(player, toInsert);
        } else if (this.getType() == 1) {
            this.depositFluids(player, toInsert);
        }
        return InteractionResult.SUCCESS;
    }

    private void depositItems(Player player, ItemStack toInsert) {
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        if (!filter.m_41619_() && API.instance().getComparer().isEqual(filter, toInsert, this.compare)) {
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, this.network.insertItemTracked(toInsert, toInsert.m_41613_()));
            this.deposits.put(player.m_36316_().getName(), (Pair<ItemStack, Long>)Pair.of((Object)toInsert, (Object)System.currentTimeMillis()));
        }
    }

    private void depositFluids(Player player, ItemStack toInsert) {
        FluidStack filter = this.fluidFilter.getFluid(0);
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(toInsert, true);
        if (filter.isEmpty() || !API.instance().getComparer().isEqual(filter, (FluidStack)result.getRight(), this.compare)) {
            return;
        }
        if (!((FluidStack)result.getValue()).isEmpty() && this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.SIMULATE).isEmpty()) {
            this.network.getFluidStorageTracker().changed(player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(toInsert, false);
            this.network.insertFluidTracked((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount());
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
            ItemStack container = (ItemStack)result.getLeft();
            if (!player.m_150109_().m_36054_(container.m_41777_())) {
                Containers.m_18992_((Level)player.m_20193_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)container);
            }
        }
    }

    public void extract(Player player, Direction side) {
        if (this.network == null || this.getDirection() != side) {
            return;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        if (this.getType() == 0) {
            this.extractItems(player);
        } else if (this.getType() == 1) {
            this.extractFluids(player);
        }
    }

    private void extractItems(Player player) {
        ItemStack result;
        int toExtract;
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        int n = toExtract = player.m_6047_() ? 1 : filter.m_41741_();
        if (!(filter.m_41619_() || (result = this.network.extractItem(filter, toExtract, this.compare, Action.PERFORM)).m_41619_() || player.m_150109_().m_36054_(result.m_41777_()))) {
            Containers.m_18992_((Level)this.level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)result);
        }
    }

    private void extractFluids(Player player) {
        FluidStack filter = this.fluidFilter.getFluid(0);
        if (filter.isEmpty()) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getList().get(filter);
        if (stack == null || stack.getAmount() < 1000) {
            return;
        }
        boolean shift = player.m_6047_();
        if (shift) {
            NetworkUtils.extractBucketFromPlayerInventoryOrNetwork(player, this.network, bucket -> bucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).ifPresent(fluidHandler -> {
                this.network.getFluidStorageTracker().changed(player, stack.copy());
                fluidHandler.fill(this.network.extractFluid(stack, 1000, Action.PERFORM), IFluidHandler.FluidAction.EXECUTE);
                if (!player.m_150109_().m_36054_(fluidHandler.getContainer().m_41777_())) {
                    Containers.m_18992_((Level)player.m_20193_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)fluidHandler.getContainer());
                }
            }));
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getStorageMonitor().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        LevelUtils.updateBlock(this.level, this.pos);
        this.markDirty();
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, 0, tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilter.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems(this.itemFilter, 0, tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilter.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public int getAmount() {
        if (this.network == null) {
            return 0;
        }
        if (this.getType() == 0) {
            ItemStack toCheck = this.itemFilter.getStackInSlot(0);
            if (toCheck.m_41619_()) {
                return 0;
            }
            if (this.compare == 1) {
                ItemStack stored = this.network.getItemStorageCache().getList().get(toCheck, this.compare);
                return stored != null ? stored.m_41613_() : 0;
            }
            return this.network.getItemStorageCache().getList().getStacks(toCheck).stream().mapToInt(entry -> ((ItemStack)entry.getStack()).m_41613_()).sum();
        }
        if (this.getType() == 1) {
            FluidStack toCheck = this.fluidFilter.getFluid(0);
            if (toCheck.isEmpty()) {
                return 0;
            }
            FluidStack stored = this.network.getFluidStorageCache().getList().get(toCheck, this.compare);
            return stored != null ? stored.getAmount() : 0;
        }
        return 0;
    }

    @Override
    public int getType() {
        return this.level.f_46443_ ? StorageMonitorBlockEntity.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        LevelUtils.updateBlock(this.level, this.pos);
        this.markDirty();
    }

    public BaseItemHandler getItemFilters() {
        return this.itemFilter;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilter;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }
}

