/*
 * Decompiled with CFR 0.152.
 */
package tfar.quickstack.client.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import tfar.quickstack.DropOff;
import tfar.quickstack.client.ClientUtils;
import tfar.quickstack.client.gui.DropOffGuiButton;
import tfar.quickstack.config.DropOffConfig;
import tfar.quickstack.networking.C2SFavoriteItemPacket;
import tfar.quickstack.networking.PacketHandler;
import tfar.quickstack.util.ItemStackUtils;

@Mod.EventBusSubscriber(modid="quickstack", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class GuiEventHandler {
    private static final Set<Class<?>> bad_classes = new HashSet();

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent.Init.Post event) {
        if (!GuiEventHandler.canDisplay(event.getScreen()) || !((Boolean)DropOffConfig.Client.showInventoryButton.get()).booleanValue()) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)event.getScreen();
        boolean isCreative = Minecraft.m_91087_().f_91074_.m_150110_().f_35937_;
        int xPos = containerScreen.getGuiLeft() + 80 + (isCreative ? (Integer)DropOffConfig.Client.creativeInventoryButtonXOffset.get() : (Integer)DropOffConfig.Client.survivalInventoryButtonXOffset.get());
        int yPos = containerScreen.getGuiTop() + 80 + (isCreative ? (Integer)DropOffConfig.Client.creativeInventoryButtonYOffset.get() : (Integer)DropOffConfig.Client.survivalInventoryButtonYOffset.get());
        if (((Boolean)DropOffConfig.Client.enableDump.get()).booleanValue()) {
            DropOffGuiButton dump = new DropOffGuiButton(xPos, yPos, GuiEventHandler::actionPerformed, true);
            event.addListener((GuiEventListener)dump);
        }
        DropOffGuiButton deposit = new DropOffGuiButton(xPos + 12, yPos, GuiEventHandler::actionPerformed, false);
        event.addListener((GuiEventListener)deposit);
    }

    private static void actionPerformed(@Nonnull Button button) {
        ClientUtils.sendNoSpectator(((DropOffGuiButton)button).dump);
    }

    @SubscribeEvent
    public static <T extends AbstractContainerMenu> void onItemClick(ScreenEvent.MouseButtonPressed.Pre event) {
        InventoryScreen containerScreen;
        block5: {
            block4: {
                Screen screen;
                if (!GuiEventHandler.canDisplay(event.getScreen()) || !((screen = event.getScreen()) instanceof InventoryScreen)) break block4;
                containerScreen = (InventoryScreen)screen;
                if (Screen.m_96637_()) break block5;
            }
            return;
        }
        Slot slotUnderMouse = containerScreen.getSlotUnderMouse();
        if (slotUnderMouse != null && slotUnderMouse.m_6657_()) {
            event.setCanceled(true);
            PacketHandler.INSTANCE.sendToServer((Object)new C2SFavoriteItemPacket(containerScreen.getSlotUnderMouse().f_40219_));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static <T extends AbstractContainerMenu> void drawFavorites(ContainerScreenEvent.Render.Background event) {
        AbstractContainerScreen containerScreen = event.getContainerScreen();
        if (!GuiEventHandler.canDisplay(containerScreen)) {
            return;
        }
        AbstractContainerMenu playerContainer = containerScreen.m_6262_();
        PoseStack matrices = event.getPoseStack();
        for (int k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                Slot slot = (Slot)playerContainer.f_38839_.get(j + (k + 1) * 9);
                ItemStack stack = slot.m_7993_();
                if (!ItemStackUtils.isFavorited(stack)) continue;
                int xoffset = 8;
                int yoffset = 84;
                GuiComponent.m_93172_((PoseStack)matrices, (int)(containerScreen.getGuiLeft() + j * 18 + xoffset), (int)(containerScreen.getGuiTop() + k * 18 + yoffset), (int)(containerScreen.getGuiLeft() + j * 18 + 16 + xoffset), (int)(containerScreen.getGuiTop() + k * 18 + 16 + yoffset), (int)(DropOffConfig.favorite_color_cache << 8));
            }
        }
        NonNullList stacks = playerContainer.m_38927_();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)stacks.get(i + 36);
            if (!ItemStackUtils.isFavorited(stack)) continue;
            int xoffset = 8;
            int yoffset = 142;
            GuiComponent.m_93172_((PoseStack)matrices, (int)(containerScreen.getGuiLeft() + i * 18 + xoffset), (int)(containerScreen.getGuiTop() + yoffset), (int)(containerScreen.getGuiLeft() + i * 18 + 16 + xoffset), (int)(containerScreen.getGuiTop() + 16 + yoffset), (int)(DropOffConfig.favorite_color_cache << 8));
        }
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean canDisplay(Screen screen) {
        return screen instanceof AbstractContainerScreen && GuiEventHandler.canDisplay((AbstractContainerScreen)screen);
    }

    public static <T extends AbstractContainerMenu> boolean canDisplay(AbstractContainerScreen<T> screen) {
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            return true;
        }
        if (screen instanceof HorseInventoryScreen) {
            return false;
        }
        try {
            String screenMenuRegistry = ForgeRegistries.MENU_TYPES.getKey((Object)screen.m_6262_().m_6772_()).toString();
            return ((List)DropOffConfig.Client.whitelistedContainers.get()).contains(screenMenuRegistry);
        }
        catch (Exception e) {
            Class<?> clazz = screen.m_6262_().getClass();
            if (!bad_classes.contains(clazz)) {
                DropOff.LOGGER.error(clazz + " does not have a container type registered to it! This is a bug in the other mod and should be reported to them.  The buttons will not display in this gui!");
                bad_classes.add(clazz);
            }
            return false;
        }
    }

    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        if (ItemStackUtils.isFavorited(stack)) {
            e.getToolTip().add(Component.m_237115_((String)"dropoff.tooltip.favorited"));
        }
    }
}

