/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.tile;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.block.HarvesterPylonBlock;
import net.permutated.pylons.tile.AbstractPylonTile;

public class HarvesterPylonTile
extends AbstractPylonTile {
    Status workStatus = Status.NONE;

    public HarvesterPylonTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.HARVESTER_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{3, 5, 7, 9};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.m_41720_() instanceof HoeItem;
    }

    @Override
    protected boolean canAccessInventory() {
        return (Boolean)ConfigManager.SERVER.harvesterCanBeAutomated.get();
    }

    private boolean requiresTool() {
        return Boolean.TRUE.equals(ConfigManager.SERVER.harvesterRequiresTool.get());
    }

    private int getWorkDelay() {
        return (Integer)ConfigManager.SERVER.harvesterWorkDelay.get();
    }

    @Override
    public void updateContainer(FriendlyByteBuf packetBuffer) {
        super.updateContainer(packetBuffer);
        packetBuffer.m_130068_((Enum)this.workStatus);
    }

    @Override
    public void tick() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getWorkDelay())) {
                boolean waterlogged;
                BlockPos above = this.m_58899_().m_7494_();
                BlockEntity target = this.f_58857_.m_7702_(above);
                if (target == null) {
                    this.workStatus = Status.MISSING_INVENTORY;
                    return;
                }
                IItemHandler itemHandler = target.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).resolve().orElse(null);
                if (itemHandler == null) {
                    this.workStatus = Status.MISSING_INVENTORY;
                    return;
                }
                int hoeSlot = -1;
                if (this.requiresTool()) {
                    for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                        if (!this.isItemValid(this.itemStackHandler.getStackInSlot(i))) continue;
                        hoeSlot = i;
                        break;
                    }
                    if (hoeSlot == -1) {
                        this.workStatus = Status.MISSING_TOOL;
                        return;
                    }
                }
                int workY = (waterlogged = ((Boolean)this.m_58900_().m_61143_((Property)HarvesterPylonBlock.WATERLOGGED)).booleanValue()) ? above.m_123342_() : this.m_58899_().m_123342_();
                int radius = (this.range.get() - 1) / 2;
                int minX = above.m_123341_() - radius;
                int minZ = above.m_123343_() - radius;
                int maxX = above.m_123341_() + radius;
                int maxZ = above.m_123343_() + radius;
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        int maxAge;
                        BlockState blockState;
                        Block block;
                        BlockPos workPos = new BlockPos(x, workY, z);
                        if (!this.f_58857_.m_46749_(workPos) || !((block = (blockState = this.f_58857_.m_8055_(workPos)).m_60734_()) instanceof CropBlock)) continue;
                        CropBlock crop = (CropBlock)block;
                        IntegerProperty ageProperty = crop.m_7959_();
                        int currentAge = (Integer)blockState.m_61143_((Property)ageProperty);
                        int minAge = (Integer)Collections.min(ageProperty.m_6908_());
                        if (minAge == (maxAge = ((Integer)Collections.max(ageProperty.m_6908_())).intValue()) || currentAge < maxAge) continue;
                        if (this.requiresTool()) {
                            if (hoeSlot == -1) {
                                this.workStatus = Status.MISSING_TOOL;
                                return;
                            }
                            ItemStack replace = this.itemStackHandler.getStackInSlot(hoeSlot).m_41777_();
                            if (replace.m_220157_(1, this.f_58857_.m_213780_(), null)) {
                                replace.m_41774_(1);
                            }
                            this.itemStackHandler.setStackInSlot(hoeSlot, replace);
                        }
                        ItemStack seedStack = crop.m_7397_((BlockGetter)this.f_58857_, workPos, blockState);
                        List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)workPos, null);
                        BlockState modified = (BlockState)blockState.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(minAge));
                        boolean updated = this.f_58857_.m_46597_(workPos, modified);
                        if (!updated) {
                            this.workStatus = Status.UPDATE_ERROR;
                            Pylons.LOGGER.error("Failed to reset crop age for position: {}", (Object)workPos);
                            return;
                        }
                        for (ItemStack drop : drops) {
                            boolean result;
                            if (!seedStack.m_41619_() && drop.m_41720_() == seedStack.m_41720_()) {
                                drop.m_41774_(1);
                            }
                            if (drop.m_41619_() || (result = this.insertItemOrDiscard(itemHandler, drop))) continue;
                            this.workStatus = Status.INVENTORY_FULL;
                            return;
                        }
                    }
                }
                this.workStatus = Status.WORKING;
            }
        }
    }

    private boolean insertItemOrDiscard(IItemHandler itemHandler, ItemStack itemStack) {
        ItemStack progress = itemStack;
        for (int slot = 0; slot < itemHandler.getSlots() && !(progress = itemHandler.insertItem(slot, progress, false)).m_41619_(); ++slot) {
        }
        return progress.m_41619_();
    }

    public static enum Status {
        NONE,
        WORKING,
        MISSING_TOOL,
        MISSING_INVENTORY,
        INVENTORY_FULL,
        UPDATE_ERROR;

    }
}

