/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.tile;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.tile.AbstractPylonTile;
import net.permutated.pylons.util.TranslationKey;

public class ExpulsionPylonTile
extends AbstractPylonTile {
    private List<ResourceKey<Level>> allowedDimensions = null;

    public ExpulsionPylonTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.EXPULSION_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{1, 3, 5};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.m_41720_() instanceof PlayerFilterCard;
    }

    protected AABB getBoundingBox(ServerLevel level) {
        Integer maxRadius;
        ChunkPos chunkPos = level.m_46745_(this.f_58858_).m_7697_();
        AABB aabb = new AABB((double)chunkPos.m_45604_(), (double)level.m_141937_(), (double)chunkPos.m_45605_(), (double)chunkPos.m_45608_() + 1.0, (double)level.m_151558_() + 1.0, (double)chunkPos.m_45609_() + 1.0);
        int selected = this.range.get() - 1;
        if (selected > (maxRadius = (Integer)ConfigManager.SERVER.expulsionPylonMaxRadius.get())) {
            selected = maxRadius;
        }
        if (selected > 0) {
            return aabb.m_82400_((double)selected * 8.0);
        }
        return aabb;
    }

    @Override
    public void tick() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            AABB aabb;
            List players;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(10) && this.owner != null && this.isAllowedDimension() && this.isAllowedLocation() && !(players = serverLevel.m_45976_(ServerPlayer.class, aabb = this.getBoundingBox(serverLevel))).isEmpty()) {
                List<UUID> allowed = this.allowedPlayers();
                for (ServerPlayer player : players) {
                    if (this.canAccess((Player)player) || allowed.contains(player.m_20148_())) continue;
                    this.doRespawn(serverLevel.m_7654_(), player);
                }
            }
        }
    }

    @Override
    public void updateContainer(FriendlyByteBuf packetBuffer) {
        super.updateContainer(packetBuffer);
        packetBuffer.writeBoolean(this.isAllowedDimension());
        packetBuffer.writeBoolean(this.isAllowedLocation());
    }

    public boolean isAllowedDimension() {
        if (this.f_58857_ != null) {
            if (this.allowedDimensions == null) {
                ArrayList<ResourceKey> temp = new ArrayList<ResourceKey>();
                List allowed = (List)ConfigManager.SERVER.expulsionAllowedDimensions.get();
                for (String key : allowed) {
                    temp.add(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(key)));
                }
                this.allowedDimensions = ImmutableList.copyOf(temp);
            }
            return this.allowedDimensions.contains(this.f_58857_.m_46472_());
        }
        return false;
    }

    public boolean isAllowedLocation() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            AABB workArea;
            ServerLevel serverLevel = (ServerLevel)level;
            int spawnRadius = serverLevel.m_46469_().m_46215_(GameRules.f_46147_);
            int configRadius = (Integer)ConfigManager.SERVER.expulsionWorldSpawnRadius.get();
            AABB bb = new AABB(serverLevel.m_220360_());
            AABB area = bb.m_82400_((double)Math.max(configRadius, spawnRadius));
            return !area.m_82381_(workArea = this.getBoundingBox(serverLevel));
        }
        return false;
    }

    private List<UUID> allowedPlayers() {
        ArrayList<UUID> allowed = new ArrayList<UUID>();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            CompoundTag tag;
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof PlayerFilterCard) || (tag = stack.m_41737_("pylons")) == null || !tag.m_128403_("uuid")) continue;
            allowed.add(tag.m_128342_("uuid"));
        }
        return allowed;
    }

    private void doRespawn(MinecraftServer server, ServerPlayer player) {
        BlockPos respawnPosition = player.m_8961_();
        float respawnAngle = player.m_8962_();
        boolean flag = player.m_8964_();
        ServerLevel respawnLevel = server.m_129880_(player.m_8963_());
        Optional optional = respawnLevel != null && respawnPosition != null ? Player.m_36130_((ServerLevel)respawnLevel, (BlockPos)respawnPosition, (float)respawnAngle, (boolean)flag, (boolean)true) : Optional.empty();
        ServerLevel actualLevel = respawnLevel != null && optional.isPresent() ? respawnLevel : server.m_129783_();
        ServerPlayer dummyPlayer = new ServerPlayer(server, actualLevel, player.m_36316_(), null);
        if (optional.isPresent()) {
            float actualAngle;
            BlockState blockstate = actualLevel.m_8055_(respawnPosition);
            boolean isAnchor = blockstate.m_60713_(Blocks.f_50724_);
            Vec3 spawnPos = (Vec3)optional.get();
            if (!blockstate.m_204336_(BlockTags.f_13038_) && !isAnchor) {
                actualAngle = respawnAngle;
            } else {
                Vec3 vector3d = Vec3.m_82539_((Vec3i)respawnPosition).m_82546_(spawnPos).m_82541_();
                actualAngle = (float)Mth.m_14175_((double)(Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.2957763671875 - 90.0));
            }
            dummyPlayer.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, actualAngle, 0.0f);
            Vec3 spawnPosition = Vec3.m_82539_((Vec3i)dummyPlayer.m_20183_());
            if (this.getBoundingBox(actualLevel).m_82390_(spawnPosition)) {
                return;
            }
        }
        while (!actualLevel.m_45786_((Entity)dummyPlayer) && dummyPlayer.m_20186_() < 256.0) {
            dummyPlayer.m_6034_(dummyPlayer.m_20185_(), dummyPlayer.m_20186_() + 1.0, dummyPlayer.m_20189_());
        }
        player.m_8999_(actualLevel, dummyPlayer.m_20185_(), dummyPlayer.m_20186_(), dummyPlayer.m_20189_(), dummyPlayer.m_146908_(), dummyPlayer.m_146909_());
        player.m_213846_((Component)Component.m_237110_((String)TranslationKey.chat("expelled"), (Object[])new Object[]{this.getOwnerName()}).m_130940_(ChatFormatting.RED));
    }
}

