/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import com.google.common.collect.Streams;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeFloweringRecipeCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation ID = new ResourceLocation("productivebees", "bee_flowering");
    private final IDrawable icon;
    private final IDrawable background;

    public BeeFloweringRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_flowering_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 70, 82);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_41940_));
    }

    public RecipeType<Recipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.BEE_FLOWERING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.productivebees.bee_flowering");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 29, 12).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.bee)).setSlotName("source");
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        try {
            List<Object> blockList = new ArrayList<Block>();
            if (recipe.blockTag != null) {
                blockList = Streams.stream((Iterable)Registry.f_122824_.m_206058_(recipe.blockTag)).map(Holder::m_203334_).toList();
            } else if (recipe.fluidTag != null) {
                fluidStacks = Streams.stream((Iterable)Registry.f_122822_.m_206058_(recipe.fluidTag)).map(fluidHolder -> new FluidStack((Fluid)fluidHolder.m_203334_(), 1000)).toList();
            } else if (recipe.block != null) {
                blockList.add(recipe.block);
            } else if (recipe.fluid != null) {
                fluidStacks.add(new FluidStack(recipe.fluid, 1000));
            }
            for (Block block : blockList) {
                ItemStack item = new ItemStack((ItemLike)block.m_5456_());
                if (!item.m_41720_().equals(Items.f_41852_)) {
                    itemStacks.add(item);
                    continue;
                }
                if (!(block instanceof CocoaBlock)) continue;
                itemStacks.add(new ItemStack((ItemLike)Items.f_42533_));
            }
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.warn("Failed to find flowering requirements for " + recipe);
        }
        if (!fluidStacks.isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 51).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, fluidStacks)).setSlotName("inputFluid");
        }
        if (!itemStacks.isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 51).addItemStacks(itemStacks)).setSlotName("inputItem");
        }
    }

    public static List<Recipe> getFlowersRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        HashMap<String, TagKey<Block>> flowering = new HashMap<String, TagKey<Block>>();
        flowering.put("productivebees:blue_banded_bee", ModTags.RIVER_FLOWERS);
        flowering.put("productivebees:green_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:nomad_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:chocolate_mining_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:ashy_mining_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:reed_bee", ModTags.SWAMP_FLOWERS);
        flowering.put("productivebees:resin_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:sweat_bee", ModTags.SNOW_FLOWERS);
        flowering.put("productivebees:yellow_black_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:lumber_bee", ModTags.LUMBER);
        flowering.put("productivebees:quarry_bee", ModTags.QUARRY);
        flowering.put("productivebees:creeper_bee", ModTags.POWDERY);
        TagKey defaultBlockTag = BlockTags.f_13041_;
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            if (entry.getValue().isConfigurable()) {
                TagKey<Block> flowerTag;
                CompoundTag nbt = BeeReloadListener.INSTANCE.getData(entry.getValue().getBeeType().toString());
                if (nbt.m_128441_("flowerTag")) {
                    flowerTag = ModTags.getBlockTag(new ResourceLocation(nbt.m_128461_("flowerTag")));
                    recipes.add(Recipe.createBlock(flowerTag, entry.getValue()));
                    continue;
                }
                if (nbt.m_128441_("flowerBlock")) {
                    if (nbt.m_128461_("flowerBlock").contains("#")) {
                        flowerTag = ModTags.getBlockTag(new ResourceLocation(nbt.m_128461_("flowerBlock").replace("#", "")));
                        recipes.add(Recipe.createBlock(flowerTag, entry.getValue()));
                        continue;
                    }
                    Block flowerBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("flowerBlock")));
                    recipes.add(Recipe.createBlock(flowerBlock, entry.getValue()));
                    continue;
                }
                if (nbt.m_128441_("flowerFluid")) {
                    TagKey<Fluid> flowerFluid;
                    if (nbt.m_128461_("flowerFluid").contains("#")) {
                        flowerFluid = ModTags.getFluidTag(new ResourceLocation(nbt.m_128461_("flowerFluid").replace("#", "")));
                        recipes.add(Recipe.createFluid(flowerFluid, entry.getValue()));
                        continue;
                    }
                    flowerFluid = (TagKey<Fluid>)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("flowerFluid")));
                    recipes.add(Recipe.createFluid(flowerFluid, entry.getValue()));
                    continue;
                }
                recipes.add(Recipe.createBlock((TagKey<Block>)defaultBlockTag, entry.getValue()));
                continue;
            }
            if (flowering.containsKey(entry.getValue().getBeeType().toString())) {
                TagKey blockTag = (TagKey)flowering.get(entry.getValue().getBeeType().toString());
                recipes.add(Recipe.createBlock((TagKey<Block>)blockTag, entry.getValue()));
                continue;
            }
            recipes.add(Recipe.createBlock((TagKey<Block>)defaultBlockTag, entry.getValue()));
        }
        return recipes;
    }

    public record Recipe(TagKey<Block> blockTag, Block block, TagKey<Fluid> fluidTag, Fluid fluid, BeeIngredient bee) {
        public static Recipe createBlock(TagKey<Block> blockTag, BeeIngredient bee) {
            return new Recipe(blockTag, null, null, null, bee);
        }

        public static Recipe createBlock(Block block, BeeIngredient bee) {
            return new Recipe(null, block, null, null, bee);
        }

        public static Recipe createFluid(TagKey<Fluid> fluidTag, BeeIngredient bee) {
            return new Recipe(null, null, fluidTag, null, bee);
        }

        public static Recipe createFluid(Fluid fluid, BeeIngredient bee) {
            return new Recipe(null, null, null, fluid, bee);
        }
    }
}

