/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractRecipeBuilder
implements RecipeBuilder {

    public static class FluidOutput {
        private final String fluidString;
        private final int amount;

        public FluidOutput(String fluidString, int amount) {
            this.fluidString = fluidString;
            this.amount = amount;
        }

        public FluidOutput(String fluidString) {
            this(fluidString, 50);
        }

        public JsonElement toJson() {
            JsonObject output = new JsonObject();
            JsonObject fluid = new JsonObject();
            if (this.fluidString.startsWith("#")) {
                fluid.addProperty("tag", this.fluidString.substring(1));
            } else {
                fluid.addProperty("fluid", this.fluidString);
            }
            output.add("fluid", (JsonElement)fluid);
            output.addProperty("amount", (Number)this.amount);
            return output;
        }
    }

    public static class ModItemOutput
    extends IngredientOutput {
        private final String ingredient;

        public ModItemOutput(String ingredient, int chance, int min, int max) {
            super(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}), chance, min, max);
            this.ingredient = ingredient;
        }

        public ModItemOutput(String ingredient, int chance) {
            this(ingredient, chance, 0, 0);
        }

        public ModItemOutput(String ingredient) {
            this(ingredient, 100);
        }

        @Override
        public JsonElement toJson() {
            JsonObject output = new JsonObject();
            JsonObject item = new JsonObject();
            if (this.ingredient.startsWith("#")) {
                item.addProperty("tag", this.ingredient);
            } else {
                item.addProperty("item", this.ingredient);
            }
            output.add("item", (JsonElement)item);
            if (this.chance != 100) {
                output.addProperty("chance", (Number)this.chance);
            }
            if (this.min != 0) {
                output.addProperty("min", (Number)this.min);
            }
            if (this.max != 0) {
                output.addProperty("max", (Number)this.max);
            }
            return output;
        }
    }

    public static class IngredientOutput {
        private final Ingredient ingredient;
        protected final int chance;
        protected final int min;
        protected final int max;

        public IngredientOutput(Ingredient ingredient, int chance, int min, int max) {
            this.ingredient = ingredient;
            this.chance = chance;
            this.min = min;
            this.max = max;
        }

        public IngredientOutput(Ingredient ingredient, int chance) {
            this(ingredient, chance, 0, 0);
        }

        public IngredientOutput(Ingredient ingredient) {
            this(ingredient, 100);
        }

        public JsonElement toJson() {
            JsonObject output = new JsonObject();
            output.add("item", this.ingredient.m_43942_());
            if (this.chance != 100) {
                output.addProperty("chance", (Number)this.chance);
            }
            if (this.min != 0) {
                output.addProperty("min", (Number)this.chance);
            }
            if (this.max != 0) {
                output.addProperty("max", (Number)this.chance);
            }
            return output;
        }
    }
}

