/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib.geometry;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Position;

public interface Rectangle {
    public Position pos();

    default public double x() {
        return this.pos().x();
    }

    default public double y() {
        return this.pos().y();
    }

    public double width();

    public double height();

    default public double xMax() {
        return this.x() + this.width();
    }

    default public double yMax() {
        return this.y() + this.height();
    }

    default public Rectangle offsetPos(double xAmount, double yAmount) {
        return Rectangle.create(this.x() + xAmount, this.y() + yAmount, this.width(), this.height());
    }

    default public Rectangle setPos(double newX, double newY) {
        return Rectangle.create(newX, newY, this.width(), this.height());
    }

    default public Rectangle setSize(double width, double height) {
        return Rectangle.create(this.x(), this.y(), width, height);
    }

    default public Rectangle offsetSize(double xAmount, double yAmount) {
        return Rectangle.create(this.x(), this.y(), this.width() + xAmount, this.height() + yAmount);
    }

    default public boolean intersects(double x, double y, double w, double h) {
        double x0 = this.x();
        double y0 = this.y();
        return x + w > x0 && y + h > y0 && x < x0 + this.width() && y < y0 + this.height();
    }

    default public boolean intersects(Rectangle other) {
        double x0 = this.x();
        double y0 = this.y();
        return other.x() + other.width() > x0 && other.y() + other.height() > y0 && other.x() < x0 + this.width() && other.y() < y0 + this.height();
    }

    default public Rectangle intersect(Rectangle other) {
        double x = Math.max(this.x(), other.x());
        double y = Math.max(this.y(), other.y());
        double width = Math.max(0.0, Math.min(this.xMax(), other.xMax()) - this.x());
        double height = Math.max(0.0, Math.min(this.yMax(), other.yMax()) - this.y());
        return Rectangle.create(x, y, width, height);
    }

    default public Rectangle combine(Rectangle ... combineWith) {
        double x = this.x();
        double y = this.y();
        double maxX = this.xMax();
        double maxY = this.yMax();
        for (Rectangle other : combineWith) {
            x = Math.min(x, other.x());
            y = Math.min(y, other.y());
            maxX = Math.max(maxX, other.xMax());
            maxY = Math.max(maxY, other.yMax());
        }
        return Rectangle.create(x, y, maxX - x, maxY - y);
    }

    default public boolean contains(double x, double y) {
        return x >= this.x() && x <= this.x() + this.width() && y >= this.y() && y <= this.y() + this.height();
    }

    default public double size(Axis axis) {
        return axis == Axis.X ? this.width() : this.height();
    }

    default public double min(Axis axis) {
        return axis == Axis.X ? this.x() : this.y();
    }

    default public double max(Axis axis) {
        return axis == Axis.X ? this.xMax() : this.yMax();
    }

    default public double distance(Axis axis, Position position) {
        double pos = position.get(axis);
        double min = this.min(axis);
        double max = this.max(axis);
        return pos < min ? min - pos : (pos > max ? pos - max : 0.0);
    }

    public static Rectangle create(Position position, double width, double height) {
        return new Immutable(position, width, height);
    }

    public static Rectangle create(double x, double y, double width, double height) {
        return new Immutable(Position.create(x, y), width, height);
    }

    public static Rectangle create(GuiParent<?> parent) {
        return new Bound(Position.create(parent), parent);
    }

    public static Rectangle create(Position position, Supplier<Double> getWidth, Supplier<Double> getHeight) {
        return new Dynamic(position, getWidth, getHeight);
    }

    default public Mutable mutable() {
        return new Mutable(new Position.Mutable(this.x(), this.y()), this.width(), this.height());
    }

    public record Immutable(Position position, double xSize, double ySize) implements Rectangle
    {
        @Override
        public Position pos() {
            return this.position;
        }

        @Override
        public double width() {
            return this.xSize;
        }

        @Override
        public double height() {
            return this.ySize;
        }

        @Override
        public String toString() {
            return "Immutable{pos=" + this.pos() + ", width=" + this.width() + ", height=" + this.height() + "}";
        }
    }

    public record Bound(Position position, GuiParent<?> parent) implements Rectangle
    {
        @Override
        public Position pos() {
            return this.position;
        }

        @Override
        public double width() {
            return this.parent.xSize();
        }

        @Override
        public double height() {
            return this.parent.ySize();
        }

        @Override
        public String toString() {
            return "Bound{pos=" + this.pos() + ", width=" + this.width() + ", height=" + this.height() + "}";
        }
    }

    public record Dynamic(Position position, Supplier<Double> getWidth, Supplier<Double> getHeight) implements Rectangle
    {
        @Override
        public Position pos() {
            return this.position;
        }

        @Override
        public double width() {
            return this.getWidth.get();
        }

        @Override
        public double height() {
            return this.getHeight.get();
        }

        @Override
        public String toString() {
            return "Dynamic{pos=" + this.pos() + ", width=" + this.width() + ", height=" + this.height() + "}";
        }
    }

    public static class Mutable
    implements Rectangle {
        private Position.Mutable pos;
        private double width;
        private double height;

        public Mutable(Position.Mutable pos, double width, double height) {
            this.pos = pos;
            this.width = width;
            this.height = height;
        }

        @Override
        public Position pos() {
            return this.pos;
        }

        @Override
        public double width() {
            return this.width;
        }

        @Override
        public double height() {
            return this.height;
        }

        @Override
        public Rectangle offsetPos(double xAmount, double yAmount) {
            this.pos.offset(xAmount, yAmount);
            return this;
        }

        @Override
        public Rectangle setPos(double newX, double newY) {
            this.pos.set(newX, newY);
            return this;
        }

        @Override
        public Rectangle setSize(double width, double height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public Rectangle offsetSize(double xAmount, double yAmount) {
            this.width += xAmount;
            this.height += yAmount;
            return this;
        }

        @Override
        public Rectangle intersect(Rectangle other) {
            double x = Math.max(this.x(), other.x());
            double y = Math.max(this.y(), other.y());
            this.width = Math.max(0.0, Math.min(this.xMax(), other.xMax()) - this.x());
            this.height = Math.max(0.0, Math.min(this.yMax(), other.yMax()) - this.y());
            return this.setPos(x, y);
        }

        public void set(Rectangle rectangle) {
            this.pos.set(rectangle.x(), rectangle.y());
            this.width = rectangle.width();
            this.height = rectangle.height();
        }

        @Override
        public Rectangle combine(Rectangle ... combineWith) {
            double x = this.x();
            double y = this.y();
            double maxX = this.xMax();
            double maxY = this.yMax();
            for (Rectangle other : combineWith) {
                x = Math.min(x, other.x());
                y = Math.min(y, other.y());
                maxX = Math.max(maxX, other.xMax());
                maxY = Math.max(maxY, other.yMax());
            }
            return this.setPos(x, y).setSize(maxX - x, maxY - y);
        }

        public Immutable immutable() {
            return new Immutable(Position.create(this.x(), this.y()), this.width(), this.height());
        }
    }
}

