/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.config.subconfig.ThirdPartyConfig;
import me.desht.pneumaticcraft.common.thirdparty.GenericIntegrationHandler;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.botania.Botania;
import me.desht.pneumaticcraft.common.thirdparty.cofhcore.CoFHCore;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ComputerCraft;
import me.desht.pneumaticcraft.common.thirdparty.create.Create;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.gamestages.Gamestages;
import me.desht.pneumaticcraft.common.thirdparty.immersiveengineering.ImmersiveEngineering;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.Mekanism;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TheOneProbe;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraftforge.fml.ModList;

public enum ThirdPartyManager {
    INSTANCE;

    private static final GenericIntegrationHandler GENERIC;
    private static final IThirdParty IMPLICIT_INIT;
    private final List<IThirdParty> thirdPartyMods = new ArrayList<IThirdParty>();
    private IDocsProvider docsProvider = new IDocsProvider.NoDocsProvider();
    private final Set<ModType> loadedModTypes = EnumSet.noneOf(ModType.class);

    public static ThirdPartyManager instance() {
        return INSTANCE;
    }

    public IDocsProvider getDocsProvider() {
        return this.docsProvider;
    }

    private void discoverMods() {
        HashMap<String, Supplier<IThirdParty>> thirdPartyClasses = new HashMap<String, Supplier<IThirdParty>>();
        try {
            thirdPartyClasses.put("computercraft", ComputerCraft::new);
            thirdPartyClasses.put("waila", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("theoneprobe", TheOneProbe::new);
            thirdPartyClasses.put("curios", Curios::new);
            thirdPartyClasses.put("botania", Botania::new);
            thirdPartyClasses.put("patchouli", Patchouli::new);
            thirdPartyClasses.put("jei", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("immersiveengineering", ImmersiveEngineering::new);
            thirdPartyClasses.put("mekanism", Mekanism::new);
            thirdPartyClasses.put("appliedenergistics2", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("cofh_core", CoFHCore::new);
            thirdPartyClasses.put("crafttweaker", () -> IMPLICIT_INIT);
            thirdPartyClasses.put("gamestages", Gamestages::new);
            thirdPartyClasses.put("create", Create::new);
        }
        catch (Throwable e) {
            Log.error("A class loader loaded a class where we didn't expect it to do so! Please report, as third party content is broken.", new Object[0]);
            e.printStackTrace();
        }
        ThirdPartyConfig.setupDefaults(thirdPartyClasses.keySet());
        ArrayList<String> modNames = new ArrayList<String>();
        this.thirdPartyMods.add(GENERIC);
        for (Map.Entry entry : thirdPartyClasses.entrySet()) {
            if (!ThirdPartyConfig.isEnabled((String)entry.getKey()) || !ModList.get().isLoaded((String)entry.getKey())) continue;
            IThirdParty mod = (IThirdParty)((Supplier)entry.getValue()).get();
            this.thirdPartyMods.add(mod);
            if (mod.modType() != null) {
                this.loadedModTypes.add(mod.modType());
            }
            modNames.add((String)entry.getKey());
        }
        Log.info("Thirdparty integration activated for [" + String.join((CharSequence)",", modNames) + "]", new Object[0]);
    }

    public void preInit() {
        this.discoverMods();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.preInit();
            }
            catch (Throwable e) {
                this.logError(e, thirdParty.getClass(), "PreInit");
            }
        }
    }

    public void init() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.init();
            }
            catch (Throwable e) {
                this.logError(e, thirdParty.getClass(), "Init");
            }
        }
    }

    public void postInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.postInit();
            }
            catch (Throwable e) {
                this.logError(e, thirdParty.getClass(), "PostInit");
            }
        }
    }

    public void clientInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientInit();
                if (!(thirdParty instanceof IDocsProvider)) continue;
                this.docsProvider = (IDocsProvider)((Object)thirdParty);
            }
            catch (Throwable e) {
                this.logError(e, thirdParty.getClass(), "Client Init");
            }
        }
    }

    private void logError(Throwable e, Class<?> cls, String when) {
        Log.error("Third party integration error: class: %s, phase: %s", cls.getName(), when);
        e.printStackTrace();
    }

    public boolean isModTypeLoaded(ModType modType) {
        return this.loadedModTypes.contains((Object)modType);
    }

    static {
        GENERIC = new GenericIntegrationHandler();
        IMPLICIT_INIT = new IThirdParty(){};
    }

    public static enum ModType {
        COMPUTER,
        DOCUMENTATION;

    }
}

