/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.VacuumPumpBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class VacuumPumpRenderer
extends AbstractBlockEntityModelRenderer<VacuumPumpBlockEntity> {
    private static final int BLADE_COUNT = 6;
    private static final String BLADE = "blade";
    private final ModelPart blade;

    public VacuumPumpRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.m_173582_(PNCModelLayers.VACUUM_PUMP);
        this.blade = root.m_171324_(BLADE);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BLADE, CubeListBuilder.m_171558_().m_171514_(24, 25).m_171517_("blade_0", 0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 3.0f), PartPose.m_171419_((float)-0.5f, (float)14.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Override
    public void renderModel(VacuumPumpBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)Textures.MODEL_VACUUM_PUMP));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        this.renderBlades(te, partialTicks, matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
    }

    private void renderBlades(VacuumPumpBlockEntity te, float partialTicks, PoseStack matrixStackIn, VertexConsumer builder, int combinedLightIn, int combinedOverlayIn) {
        float rotation = Mth.m_14179_((float)partialTicks, (float)te.oldRotation, (float)te.rotation) + 1.0f;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, (double)-0.68f, 1.0);
        matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
        for (int i = 0; i < 6; ++i) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(rotation * 2.0f + ((float)i + 0.5f) / 6.0f * 360.0f));
            matrixStackIn.m_85837_(0.0, 0.0, 0.0625);
            this.blade.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
    }
}

